/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image;

import de.jave.image.greyscale.GGreyscaleImage;
import de.jave.image.greyscale.GreyscaleImageFactory;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageLoader {
    public static BufferedImage loadImage(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("The image file does not exist: " + file.getAbsolutePath());
        }
        return ImageIO.read(file);
    }

    public static GGreyscaleImage loadAsGreyScaleImage(File file) throws IOException {
        BufferedImage image = ImageLoader.loadImage(file);
        int oldWidth = image.getWidth();
        int oldHeight = image.getHeight();
        int[] pixels2 = new int[oldWidth * oldHeight];
        PixelGrabber pg2 = new PixelGrabber(image, 0, 0, oldWidth, oldHeight, pixels2, 0, oldWidth);
        try {
            pg2.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println("Internal Error: " + e.toString());
            return null;
        }
        if ((pg2.getStatus() & 0x80) != 0) {
            System.err.println("Internal Error: image fetch aborted or errored");
            return null;
        }
        return new GreyscaleImageFactory().createGreyscaleImage(pixels2, oldWidth, oldHeight);
    }
}

