/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii.tablecreation;

import de.jave.image2ascii.tablecreation.GreyScaleImageFieldData;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public class GreyScaleImageFieldComponent
extends JComponent {
    private static final int ALPHA = 200;
    private static final Font FONT = new Font("Monospaced", 0, 11);
    private GreyScaleImageFieldData data;

    public GreyScaleImageFieldComponent(GreyScaleImageFieldData data) {
        this.data = data;
        this.setBackground(Color.white);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        if (this.data.getImage() != null) {
            this.data.getImage().paint(g, 0, 0);
        }
        if (this.data.getFieldBounds() != null && this.data.getGreyScaleTable() != null) {
            Rectangle2D rectangle;
            int i;
            for (i = 32; i < 127; ++i) {
                rectangle = this.data.getFieldBounds().getInnerFieldRectangle(i);
                int nw = this.data.getGreyScaleTable().getValueNW(i);
                g.setColor(GreyScaleImageFieldComponent.createGreyscaleColor(nw));
                g.fillRect((int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.getWidth() / 2, (int)rectangle.getHeight() / 2);
                int ne = this.data.getGreyScaleTable().getValueNE(i);
                g.setColor(GreyScaleImageFieldComponent.createGreyscaleColor(ne));
                g.fillRect((int)(rectangle.getX() + rectangle.getWidth() / 2.0), (int)rectangle.getY(), (int)rectangle.getWidth() / 2, (int)rectangle.getHeight() / 2);
                int sw = this.data.getGreyScaleTable().getValueSW(i);
                g.setColor(GreyScaleImageFieldComponent.createGreyscaleColor(sw));
                g.fillRect((int)rectangle.getX(), (int)(rectangle.getY() + rectangle.getHeight() / 2.0), (int)(rectangle.getWidth() / 2.0), (int)(rectangle.getHeight() / 2.0));
                int se = this.data.getGreyScaleTable().getValueSE(i);
                g.setColor(GreyScaleImageFieldComponent.createGreyscaleColor(se));
                g.fillRect((int)(rectangle.getX() + rectangle.getWidth() / 2.0), (int)(rectangle.getY() + rectangle.getHeight() / 2.0), (int)(rectangle.getWidth() / 2.0), (int)(rectangle.getHeight() / 2.0));
            }
            for (i = 32; i < 127; ++i) {
                rectangle = this.data.getFieldBounds().getInnerFieldRectangle(i);
                Point2D.Double center = new Point2D.Double(rectangle.getCenterX(), rectangle.getCenterY());
                double width = rectangle.getWidth();
                double height = rectangle.getHeight();
                int value = this.data.getGreyScaleTable().getBrightnessForChar((char)i);
                int ovalWidth = (int)width / 2;
                int ovalHeight = (int)height / 2;
                int ovalX = (int)((Point2D)center).getX() - ovalWidth / 2;
                int ovalY = (int)((Point2D)center).getY() - ovalHeight / 2;
                g.setColor(Color.WHITE);
                g.fillOval(ovalX, ovalY, ovalWidth, ovalHeight);
                g.setColor(GreyScaleImageFieldComponent.createGreyscaleColor(value));
                g.fillOval(ovalX, ovalY, ovalWidth, ovalHeight);
                g.setColor(Color.BLACK);
                g.drawOval(ovalX, ovalY, ovalWidth, ovalHeight);
            }
            g.setColor(new Color(1.0f, 0.0f, 0.0f, 0.3f));
            g.draw(this.data.getFieldBounds().getBottomInnerHandleRectangle());
            g.draw(this.data.getFieldBounds().getBottomOuterHandleRectangle());
            g.draw(this.data.getFieldBounds().getLeftInnerHandleRectangle());
            g.draw(this.data.getFieldBounds().getLeftOuterHandleRectangle());
            g.draw(this.data.getFieldBounds().getRightInnerHandleRectangle());
            g.draw(this.data.getFieldBounds().getRightOuterHandleRectangle());
            g.draw(this.data.getFieldBounds().getTopInnerHandleRectangle());
            g.draw(this.data.getFieldBounds().getTopOuterHandleRectangle());
            g.setColor(Color.red);
            g.draw(this.data.getFieldBounds().getRectangle());
            g.setFont(FONT);
            g.setColor(Color.blue);
            for (i = 32; i < 127; ++i) {
                rectangle = this.data.getFieldBounds().getInnerFieldRectangle(i);
                g.draw(rectangle);
                g.drawString("" + (char)i, (int)(rectangle.getX() + 2.0), (int)(rectangle.getY() - 2.0));
            }
        }
    }

    private static Color createGreyscaleColor(int greyscaleValue) {
        return new Color(greyscaleValue, greyscaleValue, greyscaleValue, 200);
    }
}

