/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.ascii.plate.CharacterMetrics;
import de.jave.ascii.plate.CharacterSizeModel;
import de.jave.ascii.plate.ruler.AsciiRulerProperties;
import de.jave.ascii.plate.ruler.HorizontalRulerRenderingStrategy;
import de.jave.ascii.plate.ruler.RulerComponent;
import de.jave.ascii.plate.ruler.VerticalRulerRenderingStrategy;
import de.jave.gui.xor.IXorPainter;
import de.jave.jave.CharacterSets;
import de.jave.jave.CompressedDocumentState;
import de.jave.jave.JavEApplication;
import de.jave.jave.JaveSelection;
import de.jave.jave.PlateDocument;
import de.jave.jave.Point2d;
import de.jave.jave.Selection;
import de.jave.jave.Tool;
import de.jave.jave.plate.ToolManager;
import de.jave.jave.preferences.ColorScheme;
import de.jave.jave.preferences.PlatePreferences;
import de.jave.jave.rendering.ConnectedLinesViewRenderer;
import de.jave.jave.tool.text.RowRange;
import de.jave.jave.watermark.IWatermarkPainter;
import de.jave.jave.watermark.IWatermarkPainterExclusive;
import de.jave.lib.CharacterPlate;
import de.jave.lib.area.BooleanArea;
import de.jave.lib.gui.IStatusDisplay;
import de.jave.text.TextTools;
import de.jave.undo.LogFile;
import de.jave.undo.UndoManager;
import de.jave.util.RelativeTimeClock;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import net.disy.commons.core.model.ObjectModel;
import net.disy.commons.core.model.listener.IChangeListener;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.fontchooser.model.FontModel;
import net.disy.commons.swing.mousecursor.CursorId;
import net.disy.commons.swing.mousecursor.CursorProvider;

public class Plate
extends JComponent
implements MouseListener,
MouseMotionListener,
KeyListener {
    private static final int MIN_FONT_SIZE = 7;
    private static final int MAX_FONT_SIZE = 16;
    private final JScrollPane scrollPanel;
    private IXorPainter xorPainter = null;
    private boolean xorPainterDisplayed = false;
    private final CharacterSizeModel characterSizeModel = new CharacterSizeModel();
    private IStatusDisplay status;
    private IWatermarkPainterExclusive watermarkPainterExclusive;
    private List<IWatermarkPainter> watermarkPainters;
    private Selection selection;
    private boolean grid;
    private boolean connectedLinesView;
    private boolean markIllegal;
    private final JavEApplication jave;
    private final PlateDocument document;
    private boolean keyMark1 = false;
    private boolean keyMark2 = false;
    private boolean keyMark3 = false;
    private boolean shiftDown = false;
    private boolean controlDown = false;
    private boolean altDown = false;
    private boolean mouseRightButton = false;
    private final AsciiRulerProperties rulerProperties;
    private final ToolManager toolManager;
    private final PlatePreferences platePreferences;
    private final ObjectModel<ColorScheme> colorSchemeModel;

    public Plate(PlateDocument document, JavEApplication parent, final PlatePreferences platePreferences, ToolManager toolManager, final FontModel displayFontModel, ObjectModel<ColorScheme> colorSchemeModel) {
        Ensure.ensureArgumentNotNull(document);
        Ensure.ensureArgumentNotNull(parent);
        Ensure.ensureArgumentNotNull(platePreferences);
        Ensure.ensureArgumentNotNull(toolManager);
        Ensure.ensureArgumentNotNull(displayFontModel);
        Ensure.ensureArgumentNotNull(colorSchemeModel);
        this.platePreferences = platePreferences;
        this.jave = parent;
        this.colorSchemeModel = colorSchemeModel;
        this.toolManager = toolManager;
        this.rulerProperties = new AsciiRulerProperties(this.characterSizeModel);
        this.rulerProperties.setShowMouseLocation(true);
        platePreferences.getRulerModel().addChangeListener(new IChangeListener(){

            @Override
            public void stateChanged() {
                Plate.this.rulerProperties.setHorizontalRulerVisible(platePreferences.getRulerModel().getValue());
                Plate.this.rulerProperties.setVerticalRulerVisible(platePreferences.getRulerModel().getValue());
            }
        });
        this.rulerProperties.setHorizontalRulerVisible(platePreferences.getRulerModel().getValue());
        this.rulerProperties.setVerticalRulerVisible(platePreferences.getRulerModel().getValue());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.scrollPanel = new JScrollPane(this);
        this.scrollPanel.setColumnHeaderView(new RulerComponent(new HorizontalRulerRenderingStrategy(), this, this.rulerProperties));
        this.scrollPanel.setRowHeaderView(new RulerComponent(new VerticalRulerRenderingStrategy(), this, this.rulerProperties));
        this.scrollPanel.setAutoscrolls(false);
        this.updateScrollIncrements();
        this.setGrid(platePreferences.getGridVisibilityModel().getValue());
        this.setMarkIllegalChars(platePreferences.getMarkIllegalModel().getValue());
        this.setConnectedLinesView(platePreferences.getConnectedLinesViewModel().getValue());
        platePreferences.getGridVisibilityModel().addChangeListener(new IChangeListener(){

            @Override
            public void stateChanged() {
                Plate.this.setGrid(platePreferences.getGridVisibilityModel().getValue());
            }
        });
        platePreferences.getMarkIllegalModel().addChangeListener(new IChangeListener(){

            @Override
            public void stateChanged() {
                Plate.this.setMarkIllegalChars(platePreferences.getMarkIllegalModel().getValue());
            }
        });
        platePreferences.getConnectedLinesViewModel().addChangeListener(new IChangeListener(){

            @Override
            public void stateChanged() {
                Plate.this.setConnectedLinesView(platePreferences.getConnectedLinesViewModel().getValue());
            }
        });
        this.document = document;
        this.selection = document.getSelection();
        this.selection.setPlate(this);
        this.handleDocumentSizeChanged();
        this.setScrollPoint(document.getScrollOrigin());
        this.repaint();
        this.initializeUndoManager(document);
        this.setFont(displayFontModel.getFont());
        displayFontModel.addChangeListener(new IChangeListener(){

            @Override
            public void stateChanged() {
                Plate.this.setFont(displayFontModel.getFont());
            }
        });
    }

    public PlatePreferences getPlatePreferences() {
        return this.platePreferences;
    }

    private void initializeUndoManager(PlateDocument document) {
        if (document.getUndoManager() == null) {
            document.setUndoManager(new UndoManager(this.getDocumentState(null)));
            document.getUndoManager().setMaxSize(524288);
            try {
                LogFile logFile = new LogFile();
                document.getUndoManager().setLogFile(logFile);
            }
            catch (Exception e) {
                System.err.println("Unable to create a new logfile: " + e);
            }
            RelativeTimeClock clock = new RelativeTimeClock();
            document.setRelativeTimeClock(clock);
        }
    }

    private Tool getCurrentTool() {
        return this.toolManager.getCurrentTool();
    }

    public ToolManager getToolManager() {
        return this.toolManager;
    }

    private void updateScrollIncrements() {
        this.scrollPanel.getVerticalScrollBar().setUnitIncrement(this.getCharHeight());
        this.scrollPanel.getHorizontalScrollBar().setUnitIncrement(this.getCharWidth());
        this.scrollPanel.getVerticalScrollBar().setBlockIncrement(this.scrollPanel.getVisibleRect().height);
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    public synchronized void setXORPainter(IXorPainter newPainter) {
        Graphics g;
        if (this.xorPainterDisplayed && this.xorPainter != null && (g = this.getGraphics()) != null) {
            this.xorPainter.paintXor(g);
            this.xorPainterDisplayed = false;
        }
        this.xorPainter = newPainter;
        if (newPainter == null) {
            this.xorPainterDisplayed = false;
        } else {
            g = this.getGraphics();
            if (g != null) {
                this.xorPainter.paintXor(g);
                this.xorPainterDisplayed = true;
            }
        }
    }

    public void setMix(boolean what) {
        if (this.document == null) {
            return;
        }
        this.document.getContent().setMix(what);
    }

    public void addWatermarkPainter(IWatermarkPainterExclusive p) {
        this.watermarkPainterExclusive = p;
    }

    public void addWatermarkPainter(IWatermarkPainter p) {
        if (p instanceof IWatermarkPainterExclusive) {
            this.addWatermarkPainter((IWatermarkPainterExclusive)p);
            return;
        }
        if (this.watermarkPainters == null) {
            this.watermarkPainters = new ArrayList<IWatermarkPainter>(10);
        }
        this.watermarkPainters.add(p);
    }

    public void removeWatermarkPainter(IWatermarkPainter p) {
        if (p == this.watermarkPainterExclusive) {
            this.watermarkPainterExclusive = null;
        } else {
            this.watermarkPainters.remove(p);
        }
    }

    public PlateDocument getDocument() {
        return this.document;
    }

    public boolean hasDocument() {
        return this.document != null;
    }

    public CompressedDocumentState getDocumentState(String actionName) {
        char[][] cContent = this.document.getContent().getContent();
        Point cLocation = this.getScrollPoint();
        char[][] cSelectionContent = null;
        Point cSelectionLocation = null;
        BooleanArea cSelectionMask = null;
        if (this.hasSelection()) {
            cSelectionContent = this.selection.getContent().getContent();
            cSelectionLocation = this.selection.getLocation();
            cSelectionMask = this.selection.getMask();
        }
        Point cursorLocation = this.document.getCursorLocation();
        String toolName = null;
        if (this.getCurrentTool() != null) {
            toolName = this.getCurrentTool().getName();
        }
        return new CompressedDocumentState(cContent, cLocation, cSelectionContent, cSelectionLocation, cSelectionMask, cursorLocation, toolName, actionName, this.colorSchemeModel.getValue());
    }

    private Point getScrollPoint() {
        return new Point(this.scrollPanel.getHorizontalScrollBar().getValue(), this.scrollPanel.getVerticalScrollBar().getValue());
    }

    public void setContent(CharacterPlate cp) {
        if (this.document == null) {
            throw new RuntimeException("ERROR: No document in plate.setContent()");
        }
        this.document.setContent(cp);
        this.handleDocumentSizeChanged();
    }

    public void handleDocumentSizeChanged() {
        this.rulerProperties.setDocumentSize(this.getDocumentSize());
        this.revalidate();
        this.repaint();
        this.jave.updateSizeLabelToDocumentSize();
    }

    private void setScrollPoint(Point point) {
        this.scrollPanel.getHorizontalScrollBar().setValue(point.x);
        this.scrollPanel.getVerticalScrollBar().setValue(point.y);
    }

    public boolean isInside(Point location) {
        return this.isInside(location.x, location.y);
    }

    public boolean isInside(int x, int y) {
        return x >= 0 && y >= 0 && x < this.document.getSize().width && y < this.document.getSize().height;
    }

    public boolean isEmpty() {
        return this.document.isEmpty();
    }

    public void crop() {
        if (!this.hasSelection()) {
            Insets in = this.document.getContent().getEmptyInsets();
            if (in.left == 0 && in.right == 0 && in.top == 0 && in.bottom == 0) {
                return;
            }
            CharacterPlate content = this.document.getContent();
            int newWidth = content.getWidth() - in.left - in.right;
            int newHeight = content.getHeight() - in.top - in.bottom;
            CharacterPlate cp = content.getCopy(in.left, in.top, newWidth, newHeight);
            content.setSize(newWidth, newHeight);
            content.clear();
            boolean wasMix = content.isMix();
            content.setMix(false);
            cp.pasteInto(content, 0, 0);
            content.setMix(wasMix);
            this.setCursor(CursorProvider.getInstance().getCursor(CursorId.CROSSHAIR_SELECTION));
            this.handleDocumentSizeChanged();
            return;
        }
        this.cropToSelection();
        this.setCursor(CursorProvider.getInstance().getCursor(CursorId.CROSSHAIR_SELECTION));
    }

    private void cropToSelection() {
        if (!this.selection.hasSelection()) {
            return;
        }
        int newWidth = this.selection.getWidth();
        int newHeight = this.selection.getHeight();
        CharacterPlate content = this.document.getContent();
        content.setSize(newWidth, newHeight);
        boolean wasMix = content.isMix();
        content.setMix(false);
        content.clear();
        CharacterPlate newContent = this.selection.getContent();
        newContent.pasteInto(content, 0, 0);
        this.selection.delete();
        content.setMix(wasMix);
        this.handleDocumentSizeChanged();
    }

    public void unselect() {
        this.selection.delete();
        this.jave.updateSelectionMenu();
        this.repaint();
    }

    public Point getPasteLocation() {
        if (this.hasSelection()) {
            return this.selection.getLocation();
        }
        return this.document.getCursorLocation();
    }

    public void setSelection(Rectangle region) {
        this.setSelection(region, this.cut(region));
    }

    public void setSelectionContent(CharacterPlate cp) {
        this.setSelectionContent(new JaveSelection(cp));
    }

    public void setSelectionContent(JaveSelection cp) {
        Rectangle region = this.selection.getRegion();
        int h = cp.getHeight();
        if (h == 0) {
            this.unselect();
            return;
        }
        int w = cp.getWidth();
        if (w == 0) {
            this.unselect();
            return;
        }
        region.height = h;
        region.width = w;
        this.setSelection(region, cp);
    }

    @Deprecated
    public void setSelectionContent(char[][] ch) {
        this.setSelectionContent(new CharacterPlate(ch));
    }

    public void setSelection(Rectangle region, CharacterPlate content) {
        this.selection.set(region, new JaveSelection(content));
        this.jave.updateSelectionMenu();
        this.repaint();
    }

    public void setSelection(Rectangle region, JaveSelection content) {
        this.selection.set(region, content);
        this.jave.updateSelectionMenu();
        this.repaint();
    }

    public Point moveSelection(int dx, int dy, boolean collisionDetection) {
        Point p = this.selection.move(dx, dy, collisionDetection);
        this.repaint();
        return p;
    }

    public Point moveSelection(int dx, int dy) {
        Point p = this.selection.move(dx, dy);
        this.repaint();
        return p;
    }

    public boolean hasSelection() {
        if (this.selection == null) {
            return false;
        }
        return this.selection.hasSelection();
    }

    public CharacterPlate getSelectionContent() {
        return this.selection.getContent();
    }

    public Rectangle getSelectionRegion() {
        return this.selection.getRegion();
    }

    public boolean selectionContains(Point location) {
        return this.selection.contains(location);
    }

    public Selection getSelection() {
        return this.selection;
    }

    public void zoomIn() {
        int currentSize = this.getFont().getSize();
        if (currentSize < 16) {
            this.setFont(this.getFont().deriveFont((float)currentSize + 1.0f));
        }
    }

    public void zoomOut() {
        int currentSize = this.getFont().getSize();
        if (currentSize > 7) {
            this.setFont(this.getFont().deriveFont((float)currentSize - 1.0f));
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.characterSizeModel.setCharSize(CharacterMetrics.createCharacterMetrics(font));
        this.updateScrollIncrements();
        this.revalidate();
        this.repaint();
    }

    @Override
    public void setCursor(Cursor cursor) {
        if (!cursor.equals(this.getCursor())) {
            super.setCursor(cursor);
        }
    }

    public void setStatusDisplay(IStatusDisplay status) {
        this.status = status;
    }

    public void showStatus(String s) {
        if (this.status != null) {
            this.status.showStatus(s);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.document == null) {
            return new Dimension(80 * this.getCharWidth() + 1, 24 * this.getCharHeight() + 1);
        }
        return new Dimension(this.getDocumentWidth() * this.getCharWidth() + 4, this.getDocumentHeight() * this.getCharHeight() + 4);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public char[][] copy(Rectangle rectangle) {
        return this.document.getContent().getCopy(rectangle).getContent();
    }

    public CharacterPlate cut(Rectangle rectangle) {
        CharacterPlate content = this.document.getContent();
        int width = content.getWidth();
        int height = content.getHeight();
        CharacterPlate sel = new CharacterPlate(rectangle.width, rectangle.height);
        for (int x = 0; x < rectangle.width; ++x) {
            int xx = x + rectangle.x;
            for (int y = 0; y < rectangle.height; ++y) {
                int yy = y + rectangle.y;
                if (xx < 0 || xx >= width || yy < 0 || yy >= height) continue;
                sel.setForce(x, y, content.get(xx, yy));
                content.set(xx, yy, ' ');
            }
        }
        this.repaint();
        return sel;
    }

    public void setPlateSize(Dimension d) {
        this.setPlateSize(d.width, d.height);
    }

    public void setPlateSize(int newWidth, int newHeight) {
        if (this.document.getSize().width == newWidth && this.document.getSize().height == newHeight) {
            return;
        }
        if (this.hasSelection()) {
            this.selection.paste();
            this.selection.delete();
        }
        CharacterPlate content = this.document.getContent();
        content.setSize(newWidth, newHeight);
        this.handleDocumentSizeChanged();
    }

    @Deprecated
    public int getDocumentHeight() {
        if (this.document == null) {
            return -1;
        }
        return this.document.getSize().height;
    }

    @Deprecated
    public int getDocumentWidth() {
        if (this.document == null) {
            return -1;
        }
        return this.document.getSize().width;
    }

    public Dimension getDocumentSize() {
        if (this.document == null) {
            return null;
        }
        return this.document.getSize();
    }

    public void insertLine(int line) {
        CharacterPlate content = this.document.getContent();
        content.insertLine(line);
        this.handleDocumentSizeChanged();
    }

    public void insertLine(int line, String text) {
        CharacterPlate content = this.document.getContent();
        content.insertLine(line, text);
        this.handleDocumentSizeChanged();
    }

    public void addColumnsRight(int count) {
        CharacterPlate content = this.document.getContent();
        content.addColumnsRight(count);
        this.handleDocumentSizeChanged();
    }

    public void removeLine(int line) {
        CharacterPlate content = this.document.getContent();
        content.removeLine(line);
        this.handleDocumentSizeChanged();
    }

    public void setText(String text) {
        this.setPlateSize(TextTools.getDimensionOf(text));
        CharacterPlate content = this.document.getContent();
        int height = content.getHeight();
        int width = content.getWidth();
        StringTokenizer st = new StringTokenizer(text, "\n\r\f");
        for (int y = 0; st.hasMoreTokens() && y < height; ++y) {
            String s = st.nextToken();
            for (int x = 0; x < s.length() && x < width; ++x) {
                content.setForce(x, y, s.charAt(x));
            }
        }
        this.repaint();
    }

    public CharacterPlate getContent() {
        return this.document.getContent();
    }

    public JaveSelection getContentOfInterest() {
        if (this.document == null) {
            return null;
        }
        if (this.hasSelection()) {
            return this.selection.getJaveSelection();
        }
        return new JaveSelection(this.document.getContent());
    }

    public void setContentOfInterest(JaveSelection sel) {
        if (this.hasSelection()) {
            this.setSelectionContent(sel);
        } else {
            this.document.setContent(sel.getContent());
            this.handleDocumentSizeChanged();
        }
    }

    public final void beep() {
        this.getToolkit().beep();
    }

    public void clear() {
        this.unselect();
        this.document.getContent().clear();
        this.handleDocumentSizeChanged();
    }

    public boolean isMouseRightButton() {
        return this.mouseRightButton;
    }

    public void saveCurrentState() {
        this.saveCurrentState(null);
    }

    public void saveCurrentState(String actionName) {
        if (this.document == null) {
            return;
        }
        CompressedDocumentState state = this.getDocumentState(actionName);
        long duration = this.document.getRelativeTimeClock().getMillisSinceLastCall();
        if ((duration /= 2L) > 1000L) {
            duration = 1000L;
        }
        state.setDuration((int)duration);
        this.document.getUndoManager().saveCurrentState(state);
        if (!this.document.isModified()) {
            this.document.setModified(true);
            this.jave.updateFrameTitle();
        }
        this.jave.updateUndoRedo();
        this.document.documentChanged();
    }

    public Point getScreenPointFor(Point location) {
        return this.getScreenPointFor(location.x, location.y);
    }

    public Point getScreenPointFor(int x, int y) {
        return this.getScreenPoint(new Point(x, y));
    }

    public Point getScreenPointFor(Point2d p) {
        return this.getScreenPointFor(p.getX(), p.getY());
    }

    public Point getScreenPointFor(double x, double y) {
        Point origin = this.getPlateOrigin();
        return new Point((int)(x * (double)this.getCharWidth() + (double)origin.x), (int)(y * (double)this.getCharHeight() + (double)origin.y));
    }

    public Point getLocationForScreenPoint(Point point) {
        Point location = this.getLocationForScreenPointAnywhere(point);
        if (location.x >= 0 && location.y >= 0 && location.x < this.getDocumentWidth() && location.y < this.getDocumentHeight()) {
            return location;
        }
        if (this.getCurrentTool().containsScreenPoint(point) || this.getCurrentTool().containsLocation(location)) {
            return location;
        }
        return null;
    }

    private Point getLocationForScreenPointAnywhere(Point point) {
        Point plateOrigin = this.getPlateOrigin();
        int x = point.x - plateOrigin.x;
        int y = point.y - plateOrigin.y;
        int xLocation = x / this.getCharWidth();
        int yLocation = y / this.getCharHeight();
        Point location = new Point(xLocation, yLocation);
        return location;
    }

    public void ensureVisible(Point location) {
        this.scrollRectToVisible(this.getRectangleForLocation(new Point(location.x, location.y)));
    }

    private Rectangle getRectangleForLocation(Point location) {
        Point screenPoint = this.getScreenPoint(location);
        return new Rectangle(screenPoint, new Dimension(this.getCharWidth(), this.getCharHeight()));
    }

    private Point getScreenPoint(Point location) {
        Point origin = this.getPlateOrigin();
        int x = location.x * this.getCharWidth() + origin.x;
        int y = location.y * this.getCharHeight() + origin.y;
        return new Point(x, y);
    }

    public Point2d getRealLocationForScreenPoint(Point point) {
        Point origin = this.getPlateOrigin();
        double x = (double)(point.x - origin.x) / (double)this.getCharWidth();
        double y = (double)(point.y - origin.y) / (double)this.getCharHeight();
        return new Point2d(x, y);
    }

    private Point getPlateOrigin() {
        PlateDocument r = this.getDocument();
        int documentPixelWidth = r.getSize().width * this.getCharWidth();
        PlateDocument r1 = this.getDocument();
        int documentPixelHeight = r1.getSize().height * this.getCharHeight();
        int requiredWidth = documentPixelWidth + 4;
        int requiredHeight = documentPixelHeight + 4;
        int availableWidth = this.scrollPanel.getVisibleRect().width;
        int availableHeight = this.scrollPanel.getVisibleRect().height;
        int x = 1;
        int y = 1;
        if (availableHeight > requiredHeight) {
            y += (availableHeight - requiredHeight) / 2;
        }
        if (availableWidth > requiredWidth) {
            x += (availableWidth - requiredWidth) / 2;
        }
        Point origin = new Point(x, y);
        this.rulerProperties.setPlateOrigin(origin);
        return origin;
    }

    public void repaintCursor() {
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        Dimension d = this.getSize();
        if (this.document == null) {
            g.setColor(this.colorSchemeModel.getValue().getColorPlateEmpty());
            g.fillRect(0, 0, d.width, d.height);
            return;
        }
        Point plateOrigin = this.getPlateOrigin();
        ColorScheme colorScheme = this.document.getColorScheme();
        g.setColor(colorScheme.getColorPlateEmpty());
        g.fillRect(0, 0, d.width, d.height);
        int documentWidth = this.getDocumentWidth();
        int documentHeight = this.getDocumentHeight();
        g.setColor(colorScheme.getColorPlateBackground());
        g.fillRect(plateOrigin.x, plateOrigin.y, documentWidth * this.getCharWidth(), documentHeight * this.getCharHeight());
        if (this.watermarkPainterExclusive != null) {
            this.watermarkPainterExclusive.paint(g, plateOrigin, colorScheme, this.getCharWidth(), this.getCharHeight());
        } else if (this.watermarkPainters != null) {
            for (int i = 0; i < this.watermarkPainters.size(); ++i) {
                IWatermarkPainter painter = this.watermarkPainters.get(i);
                painter.paint(g, plateOrigin, colorScheme, this.getCharWidth(), this.getCharHeight());
            }
        }
        this.paintGrid(g, plateOrigin, colorScheme);
        this.paintDocumentBorder(g, plateOrigin, colorScheme);
        this.paintDocumentContents(g, plateOrigin);
        this.paintIllegalCharacterMarks(g, plateOrigin);
        this.selection.paint(g, colorScheme);
        this.xorPainterDisplayed = false;
        this.selection.paintBorder((Graphics2D)g, colorScheme);
        g.setFont(this.getFont());
        this.getCurrentTool().paintCursorFeature((Graphics2D)g, plateOrigin, colorScheme);
        Plate plate = this;
        synchronized (plate) {
            if (!this.xorPainterDisplayed && this.xorPainter != null) {
                this.xorPainter.paintXor(g);
                this.xorPainterDisplayed = true;
            }
        }
    }

    private void paintDocumentContents(Graphics g, Point plateOrigin) {
        g.setColor(this.getDocument().getColorScheme().getColorText());
        g.setFont(this.getFont());
        RowRange rowRange = this.getVisibleRowRange();
        if (this.connectedLinesView) {
            ConnectedLinesViewRenderer.paintConnectedLinesView(g, this.getContent(), rowRange, plateOrigin, this.characterSizeModel.getCharacterSize());
        } else {
            CharacterPlate content = this.getContent();
            for (int y = rowRange.getRowStartIndex(); y <= rowRange.getRowEndIndex(); ++y) {
                g.drawString(new String(content.getContent()[y]), plateOrigin.x, plateOrigin.y + y * this.getCharHeight() + this.characterSizeModel.getCharacterSize().getAscent());
            }
        }
    }

    private RowRange getVisibleRowRange() {
        int y1;
        int yEnd;
        Point plateOrigin = this.getPlateOrigin();
        Rectangle clipBounds = this.scrollPanel.getViewport().getViewRect();
        int y0 = clipBounds.y - plateOrigin.y;
        int yStart = y0 / this.getCharHeight();
        if (yStart < 0) {
            yStart = 0;
        }
        if ((yEnd = (y1 = y0 + clipBounds.height) / this.getCharHeight()) > this.getDocumentHeight() - 1) {
            yEnd = this.getDocumentHeight() - 1;
        }
        return new RowRange(yStart, yEnd);
    }

    private void paintIllegalCharacterMarks(Graphics g, Point plateOrigin) {
        if (!this.markIllegal) {
            return;
        }
        g.setColor(Color.red);
        CharacterPlate content = this.getContent();
        RowRange rowRange = this.getVisibleRowRange();
        int documentWidth = this.getDocumentWidth();
        for (int y = rowRange.getRowStartIndex(); y <= rowRange.getRowEndIndex(); ++y) {
            for (int x = 0; x < documentWidth; ++x) {
                char ch = content.get(x, y);
                if (CharacterSets.isLegal(ch)) continue;
                g.drawOval(plateOrigin.x + x * this.getCharWidth() - 2, plateOrigin.y + y * this.getCharHeight() - 2, this.getCharWidth() + 4, this.getCharHeight() + 4);
            }
        }
    }

    private void paintDocumentBorder(Graphics g, Point plateOrigin, ColorScheme colorScheme) {
        int documentWidth = this.getDocumentWidth();
        int documentHeight = this.getDocumentHeight();
        g.setColor(colorScheme.getColorPlateShadow());
        g.drawRect(plateOrigin.x, plateOrigin.y, documentWidth * this.getCharWidth(), documentHeight * this.getCharHeight());
        g.fillRect(plateOrigin.x + documentWidth * this.getCharWidth(), plateOrigin.y + 3, 3, documentHeight * this.getCharHeight());
        g.fillRect(plateOrigin.x + 2, plateOrigin.y + documentHeight * this.getCharHeight(), documentWidth * this.getCharWidth() - 2, 3);
    }

    private void paintGrid(Graphics g, Point plateOrigin, ColorScheme colorScheme) {
        if (!this.grid) {
            return;
        }
        int documentWidth = this.getDocumentWidth();
        int documentHeight = this.getDocumentHeight();
        g.setColor(colorScheme.getColorPlateLines());
        for (int xIndex = 0; xIndex <= documentWidth; ++xIndex) {
            g.drawLine(plateOrigin.x + xIndex * this.getCharWidth(), plateOrigin.y, plateOrigin.x + xIndex * this.getCharWidth(), plateOrigin.y + documentHeight * this.getCharHeight());
        }
        for (int yIndex = 0; yIndex <= documentHeight; ++yIndex) {
            g.drawLine(plateOrigin.x, plateOrigin.y + yIndex * this.getCharHeight(), plateOrigin.x + documentWidth * this.getCharWidth(), plateOrigin.y + yIndex * this.getCharHeight());
        }
    }

    public void paintPreview(Graphics g, CharacterPlate pl, ColorScheme colorScheme, int x0, int y0, Point location) {
        this.paintPreview(g, pl, colorScheme, x0, y0, location.x, location.y);
    }

    public void paintPreview(Graphics g, CharacterPlate pl, ColorScheme colorScheme, int x0, int y0, int locationX, int locationY) {
        g.setColor(colorScheme.getColorToolPreview());
        g.setFont(this.getFont());
        Point p0 = this.getScreenPointFor(locationX, locationY);
        int height = pl.getHeight();
        for (int y = 0; y < height; ++y) {
            char[] line = pl.getContent()[y];
            boolean empty = true;
            for (int i = 0; empty && i < line.length; ++i) {
                if (line[i] == ' ') continue;
                empty = false;
            }
            CharacterPlate content = this.document.getContent();
            for (int i = 0; i < line.length; ++i) {
                if (!content.contains(locationX + i, locationY + y)) continue;
                line[i] = content.getPasteResult(line[i], locationX + i, locationY + y);
            }
            if (empty) continue;
            g.drawString(new String(line), p0.x - x0 * this.getCharWidth(), p0.y + (y - y0) * this.getCharHeight() + this.characterSizeModel.getCharacterSize().getAscent());
        }
    }

    public void showCoordinates(Point location) {
        if (location == null) {
            this.showStatus("");
        } else {
            this.showStatus("(" + location.x + "," + location.y + ")");
        }
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        Tool.setMetaDown(evt.isMetaDown());
        if (this.document == null) {
            return;
        }
        this.getCurrentTool().mouseClicked(evt.getPoint(), this.getLocationForScreenPoint(evt.getPoint()), evt);
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.requestFocus();
        Tool.setMetaDown(evt.isMetaDown());
        this.mouseRightButton = evt.isMetaDown();
        if (this.document == null) {
            return;
        }
        this.getCurrentTool().mousePressed(evt.getPoint(), this.getLocationForScreenPoint(evt.getPoint()), evt);
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        if (this.document == null) {
            return;
        }
        Tool.setMetaDown(evt.isMetaDown());
        this.getCurrentTool().mouseReleased(evt.getPoint(), this.getLocationForScreenPointAnywhere(evt.getPoint()), evt);
        if (this.shiftDown) {
            this.shiftDown = false;
            this.getCurrentTool().shiftReleased();
        }
        if (this.controlDown) {
            this.controlDown = false;
            this.getCurrentTool().controlReleased();
        }
        this.mouseRightButton = false;
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
        if (this.document == null) {
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        this.setCursor(this.getCurrentTool().getCursor());
        this.getCurrentTool().mouseEntered(evt.getPoint(), this.getLocationForScreenPoint(evt.getPoint()), evt);
    }

    @Override
    public void mouseExited(MouseEvent evt) {
        if (this.document == null) {
            return;
        }
        this.showStatus("");
        this.getCurrentTool().mouseExited(evt.getPoint(), this.getLocationForScreenPoint(evt.getPoint()), evt);
        this.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        char ch;
        if (this.document == null) {
            return;
        }
        Point location = this.getLocationForScreenPoint(evt.getPoint());
        this.showCoordinates(location);
        if (location != null && this.markIllegal && this.isInside(location) && !CharacterSets.isLegal(ch = this.getChar(location.x, location.y))) {
            this.showStatus("Illegal Character: " + ch);
        }
        this.getCurrentTool().mouseMoved(evt.getPoint(), location, evt);
        if (location == null) {
            this.setCursor(Cursor.getDefaultCursor());
        } else {
            this.setCursor(this.getCurrentTool().getCursor());
        }
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        if (this.document == null) {
            return;
        }
        this.scrollRectToVisible(new Rectangle(evt.getX(), evt.getY(), 1, 1));
        Point location = this.getLocationForScreenPointAnywhere(evt.getPoint());
        this.getCurrentTool().mouseDragged(evt.getPoint(), location, evt);
        if (location == null) {
            this.setCursor(Cursor.getDefaultCursor());
        } else {
            this.setCursor(this.getCurrentTool().getCursor());
        }
    }

    @Override
    public void keyTyped(KeyEvent evt) {
        if (this.document == null) {
            return;
        }
        char ch = evt.getKeyChar();
        if (this.keyMark1) {
            if (ch == ' ') {
                this.getCurrentTool().keyTyped('\u00b4', evt);
                this.keyMark1 = false;
                return;
            }
            if (ch == 'a') {
                this.getCurrentTool().keyTyped('\u00e1', evt);
                this.keyMark1 = false;
                return;
            }
            if (ch == 'o') {
                this.getCurrentTool().keyTyped('\u00f3', evt);
                this.keyMark1 = false;
                return;
            }
            if (ch == 'i') {
                this.getCurrentTool().keyTyped('\u00ed', evt);
                this.keyMark1 = false;
                return;
            }
            if (ch == 'u') {
                this.getCurrentTool().keyTyped('\u00fa', evt);
                this.keyMark1 = false;
                return;
            }
            this.keyMark1 = false;
        }
        if (this.keyMark2) {
            if (ch == ' ') {
                this.getCurrentTool().keyTyped('`', evt);
                this.keyMark2 = false;
                return;
            }
            if (ch == 'a') {
                this.getCurrentTool().keyTyped('\u00e0', evt);
                this.keyMark2 = false;
                return;
            }
            if (ch == 'o') {
                this.getCurrentTool().keyTyped('\u00f2', evt);
                this.keyMark2 = false;
                return;
            }
            if (ch == 'i') {
                this.getCurrentTool().keyTyped('\u00ec', evt);
                this.keyMark2 = false;
                return;
            }
            if (ch == 'u') {
                this.getCurrentTool().keyTyped('\u00f9', evt);
                this.keyMark2 = false;
                return;
            }
            this.keyMark2 = false;
        }
        if (this.keyMark3) {
            if (ch == ' ') {
                this.getCurrentTool().keyTyped('^', evt);
                this.keyMark3 = false;
                return;
            }
            if (ch == 'a') {
                this.getCurrentTool().keyTyped('\u00e2', evt);
                this.keyMark3 = false;
                return;
            }
            if (ch == 'o') {
                this.getCurrentTool().keyTyped('\u00f4', evt);
                this.keyMark3 = false;
                return;
            }
            if (ch == 'i') {
                this.getCurrentTool().keyTyped('\u00ee', evt);
                this.keyMark3 = false;
                return;
            }
            if (ch == 'u') {
                this.getCurrentTool().keyTyped('\u00fb', evt);
                this.keyMark3 = false;
                return;
            }
            this.keyMark3 = false;
        }
        this.getCurrentTool().keyTyped(ch, evt);
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        if (this.document == null) {
            return;
        }
        int code = evt.getKeyCode();
        switch (code) {
            case 155: {
                this.toggleInsert();
                break;
            }
            case 33: {
                this.scrollBlockUp(evt.isControlDown());
                evt.consume();
                return;
            }
            case 34: {
                this.scrollBlockDown(evt.isControlDown());
                evt.consume();
                return;
            }
            case 35: {
                if (!evt.isControlDown()) break;
                this.scrollEnd();
                break;
            }
            case 36: {
                if (!evt.isControlDown()) break;
                this.scrollHome();
            }
        }
        char ch = evt.getKeyChar();
        if (ch == '+' && evt.isControlDown()) {
            this.jave.doZoomPlus();
            evt.consume();
            return;
        }
        if (ch == '-' && evt.isControlDown()) {
            this.jave.doZoomMinus();
            evt.consume();
            return;
        }
        if (this.keyMark1 && code != 93 && (ch < 'a' || ch > 'z') && ch != ' ') {
            this.keyMark1 = false;
        }
        if (this.keyMark2 && code != 93 && (ch < 'a' || ch > 'z') && ch != ' ') {
            this.keyMark2 = false;
        }
        if (this.keyMark3 && code != 92 && (ch < 'a' || ch > 'z') && ch != ' ') {
            this.keyMark3 = false;
        }
        if (code == 93 && !evt.isShiftDown()) {
            if (this.keyMark1) {
                this.getCurrentTool().keyTyped('\u00b4', evt);
                this.keyMark1 = false;
                return;
            }
            this.keyMark1 = true;
        }
        if (code == 93 && evt.isShiftDown()) {
            if (this.keyMark2) {
                this.getCurrentTool().keyTyped('`', evt);
                this.keyMark2 = false;
                return;
            }
            this.keyMark2 = true;
        }
        if (code == 92 && !evt.isShiftDown()) {
            if (this.keyMark3) {
                this.getCurrentTool().keyTyped('^', evt);
                this.keyMark3 = false;
                return;
            }
            this.keyMark3 = true;
        }
        if (!this.shiftDown && evt.isShiftDown()) {
            this.shiftDown = true;
            this.getCurrentTool().shiftPressed();
        }
        if (!this.controlDown && evt.isControlDown()) {
            this.controlDown = true;
            this.getCurrentTool().controlPressed();
        }
        if (!this.altDown && evt.isAltDown()) {
            this.altDown = true;
            this.getCurrentTool().altPressed();
        }
        this.getCurrentTool().keyPressed(code, evt);
    }

    private void scrollBlockUp(boolean controlDown) {
        JScrollBar verticalScrollBar = this.scrollPanel.getVerticalScrollBar();
        int rowCount = this.getVisibleRowRange().getRowCount() - 3;
        int dy = rowCount * this.getCharHeight();
        verticalScrollBar.setValue(verticalScrollBar.getValue() - dy);
        if (!controlDown) {
            this.getCurrentTool().cursorUp(rowCount);
        }
    }

    private void scrollBlockDown(boolean controlDown) {
        JScrollBar verticalScrollBar = this.scrollPanel.getVerticalScrollBar();
        int rowCount = this.getVisibleRowRange().getRowCount() - 3;
        int dy = rowCount * this.getCharHeight();
        verticalScrollBar.setValue(verticalScrollBar.getValue() + dy);
        if (!controlDown) {
            this.getCurrentTool().cursorDown(rowCount);
        }
    }

    private void scrollEnd() {
        JScrollBar verticalScrollBar = this.scrollPanel.getVerticalScrollBar();
        verticalScrollBar.setValue(verticalScrollBar.getMaximum());
    }

    private void scrollHome() {
        JScrollBar verticalScrollBar = this.scrollPanel.getVerticalScrollBar();
        verticalScrollBar.setValue(verticalScrollBar.getMinimum());
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        if (this.document == null) {
            return;
        }
        this.getCurrentTool().keyReleased(evt);
        if (this.shiftDown) {
            this.shiftDown = false;
            this.getCurrentTool().shiftReleased();
        }
        if (this.controlDown) {
            this.controlDown = false;
            this.getCurrentTool().controlReleased();
        }
        if (this.altDown) {
            this.altDown = false;
            this.getCurrentTool().altReleased();
        }
    }

    private void toggleInsert() {
        this.jave.toggleInsert();
    }

    public void drawString(String text, int x0, int y0) {
        for (int i = 0; i < text.length(); ++i) {
            this.setChar(x0 + i, y0, text.charAt(i));
        }
    }

    public void pan(int dx, int dy) {
        if (dx == 0 && dy == 0) {
            return;
        }
        while (dx > 0) {
            this.panRight();
            --dx;
        }
        while (dx < 0) {
            this.panLeft();
            ++dx;
        }
        while (dy > 0) {
            this.panDown();
            --dy;
        }
        while (dy < 0) {
            this.panUp();
            ++dy;
        }
        this.repaint(50L);
    }

    private void panLeft() {
        this.getContent().panLeft();
    }

    private void panRight() {
        this.getContent().panRight();
    }

    private void panUp() {
        this.getContent().panUp();
    }

    private void panDown() {
        this.getContent().panDown();
    }

    public String getUndoActionName() {
        if (this.document == null || this.document.getUndoManager() == null) {
            return "";
        }
        return this.document.getUndoManager().getUndoActionName();
    }

    public String getRedoActionName() {
        if (this.document == null || this.document.getUndoManager() == null) {
            return "";
        }
        return this.document.getUndoManager().getRedoActionName();
    }

    public boolean canUndo() {
        if (this.document == null || this.document.getUndoManager() == null) {
            return false;
        }
        return this.document.getUndoManager().canUndo();
    }

    public boolean canRedo() {
        if (this.document == null || this.document.getUndoManager() == null) {
            return false;
        }
        return this.document.getUndoManager().canRedo();
    }

    public synchronized void redo() {
        if (this.document == null || !this.canRedo()) {
            System.err.println("ERROR! redo can not be performed!");
            return;
        }
        CompressedDocumentState d = (CompressedDocumentState)this.document.getUndoManager().redo();
        this.setDocumentState(d);
        this.setToolState(d);
        this.setCursorState(d);
        this.document.documentChanged();
    }

    public synchronized void undo() {
        if (this.document == null || !this.canUndo()) {
            System.err.println("ERROR! undo can not be performed!");
            return;
        }
        CompressedDocumentState d = (CompressedDocumentState)this.document.getUndoManager().undo();
        this.setDocumentState(d);
        CompressedDocumentState next = (CompressedDocumentState)this.document.getUndoManager().getNextState();
        if (next != null) {
            this.setToolState(next);
        }
        this.setCursorState(d);
        this.document.documentChanged();
    }

    private void setDocumentState(CompressedDocumentState d) {
        this.document.setDocumentState(d);
        this.selection = this.document.getSelection();
        this.selection.setPlate(this);
        this.jave.performSetColorScheme(d.getColorScheme());
        this.handleDocumentSizeChanged();
        this.setScrollPoint(this.document.getScrollOrigin());
    }

    private void setToolState(CompressedDocumentState d) {
        int index;
        String toolName = d.getToolName();
        if (toolName != null && (index = this.toolManager.getToolIndex(toolName)) != -1) {
            this.jave.setTool(index);
        }
    }

    private void setCursorState(CompressedDocumentState d) {
        Point cursorLocation = this.document.getCursorLocation();
        cursorLocation.x = d.getCursorLocation().x;
        cursorLocation.y = d.getCursorLocation().y;
    }

    public char getChar(int x, int y) {
        return this.getContent().get(x, y);
    }

    public void setChar(Point location, char ch) {
        if (location == null) {
            return;
        }
        this.setChar(location.x, location.y, ch);
    }

    public void setChar(int x, int y, char ch) {
        if (x < 0 || y < 0 || x >= this.getDocumentWidth() || y >= this.getDocumentHeight()) {
            return;
        }
        CharacterPlate content = this.getContent();
        if (ch != content.get(x, y)) {
            content.set(x, y, ch);
        }
    }

    public void setCharForce(Point location, char ch) {
        if (location == null) {
            return;
        }
        this.setCharForce(location.x, location.y, ch);
    }

    public void setCharForce(int x, int y, char ch) {
        if (x < 0 || y < 0 || x >= this.getDocumentWidth() || y >= this.getDocumentHeight()) {
            return;
        }
        CharacterPlate content = this.getContent();
        if (ch != content.get(x, y)) {
            content.setForce(x, y, ch);
        }
    }

    public boolean hasGrid() {
        return this.grid;
    }

    private void setGrid(boolean grid) {
        if (this.grid != grid) {
            this.grid = grid;
            this.repaint();
        }
    }

    private void setConnectedLinesView(boolean connectedLinesView) {
        if (this.connectedLinesView == connectedLinesView) {
            return;
        }
        this.connectedLinesView = connectedLinesView;
        this.repaint();
    }

    private void setMarkIllegalChars(boolean what) {
        if (this.markIllegal != what) {
            this.markIllegal = what;
            this.repaint();
        }
    }

    public CharacterMetrics getCharacterMetrics() {
        return this.characterSizeModel.getCharacterSize();
    }

    public JComponent getComponent() {
        return this.scrollPanel;
    }

    @Deprecated
    public int getCharHeight() {
        return this.getCharacterMetrics().getHeight();
    }

    @Deprecated
    public int getCharWidth() {
        return this.getCharacterMetrics().getWidth();
    }

    @Deprecated
    public int getCharAscent() {
        return this.getCharacterMetrics().getAscent();
    }

    public ObjectModel<ColorScheme> getColorSchemeModel() {
        return this.colorSchemeModel;
    }
}

