/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.algorithm;

import de.jave.jave.configuration.ConfigurationException;
import de.jave.jave.configuration.IJavaInitializationContext;
import de.jave.jave.configuration.IJaveInitializable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import net.disy.commons.core.io.IOUtilities;

public class GeneralAlgorithmConfiguration
implements IJaveInitializable {
    private static final GeneralAlgorithmConfiguration instance = new GeneralAlgorithmConfiguration();
    private static final String DEFAULT_MIRROR = " !\"#$%&`)(*+,-.\\QfSEPZ6F8P:;>=<?@A8CG37DHILXJMNO9092TUVWXYS]/[^_'edcba1gdjiJjmnoqp+zjuvwxys}|{~";
    private static final String DEFAULT_FLIP = " i_#$%&.()*+`-'\\Qj5342eJ8d:;<=>JGVBCDEL@HI7KFWNOb0BZJAAMXhS[/]v\",gpcq6tay!1krwuobdlzfn^mxhs{|}_";
    private static final String DEFAULT_ROTATE180 = " i_#$%&,)(*+'-`/0lZEkS9L86:;>=<L@V8CG3JDHIFX7WNOdQ8SJAAMXhZ]\\[v\".eqcpaj6y!f41wuodbJs1n^mxhz}|{_";
    private static final String DEFAULT_ROTATE90R = " i_#$%&,)(*+'-`/0lZEkS9L86:;>=<L@V8CG3JDHIFX7WNOdQ8SJAAMXhZ]\\[v\".eqcpaj6y!f41wuodbJs1n^mxhz}|{_";
    private static final String DEFAULT_ROTATE90L = " i_#$%&,)(*+'-`/0lZEkS9L86:;>=<L@V8CG3JDHIFX7WNOdQ8SJAAMXhZ]\\[v\".eqcpaj6y!f41wuodbJs1n^mxhz}|{_";
    private static String mirror = " !\"#$%&`)(*+,-.\\QfSEPZ6F8P:;>=<?@A8CG37DHILXJMNO9092TUVWXYS]/[^_'edcba1gdjiJjmnoqp+zjuvwxys}|{~";
    private static String flip = " i_#$%&.()*+`-'\\Qj5342eJ8d:;<=>JGVBCDEL@HI7KFWNOb0BZJAAMXhS[/]v\",gpcq6tay!1krwuobdlzfn^mxhs{|}_";
    private static String rotate180 = " i_#$%&,)(*+'-`/0lZEkS9L86:;>=<L@V8CG3JDHIFX7WNOdQ8SJAAMXhZ]\\[v\".eqcpaj6y!f41wuodbJs1n^mxhz}|{_";
    private static String rotate90R = " i_#$%&,)(*+'-`/0lZEkS9L86:;>=<L@V8CG3JDHIFX7WNOdQ8SJAAMXhZ]\\[v\".eqcpaj6y!f41wuodbJs1n^mxhz}|{_";
    private static String rotate90L = " i_#$%&,)(*+'-`/0lZEkS9L86:;>=<L@V8CG3JDHIFX7WNOdQ8SJAAMXhZ]\\[v\".eqcpaj6y!f41wuodbJs1n^mxhz}|{_";

    private GeneralAlgorithmConfiguration() {
    }

    public static GeneralAlgorithmConfiguration getInstance() {
        return instance;
    }

    @Override
    public void initialize(IJavaInitializationContext context) throws ConfigurationException {
        File configurationFile = context.getConfigurationFile("./config/general.txt");
        mirror = null;
        flip = null;
        rotate180 = null;
        rotate90R = null;
        rotate90L = null;
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(configurationFile));
            String line = null;
            while ((line = br.readLine()) != null) {
                int i1;
                if (line.length() <= 0 || line.charAt(0) == '#') continue;
                if (line.trim().startsWith("MIRROR=")) {
                    i1 = line.indexOf(61);
                    mirror = line.substring(i1 + 1);
                    continue;
                }
                if (line.trim().startsWith("FLIP=")) {
                    i1 = line.indexOf(61);
                    flip = line.substring(i1 + 1);
                    continue;
                }
                if (line.trim().startsWith("ROTATE180=")) {
                    i1 = line.indexOf(61);
                    rotate180 = line.substring(i1 + 1);
                    continue;
                }
                if (line.trim().startsWith("ROTATE90R=")) {
                    i1 = line.indexOf(61);
                    rotate90R = line.substring(i1 + 1);
                    continue;
                }
                if (!line.trim().startsWith("ROTATE90L=")) continue;
                i1 = line.indexOf(61);
                rotate90L = line.substring(i1 + 1);
            }
        }
        catch (IOException e) {
            try {
                throw new ConfigurationException(configurationFile, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtilities.close(br);
                throw throwable;
            }
        }
        IOUtilities.close(br);
        if (GeneralAlgorithmConfiguration.undefined(mirror)) {
            throw new ConfigurationException(configurationFile, "MIRROR is not defined or erratic.");
        }
        if (GeneralAlgorithmConfiguration.undefined(flip)) {
            throw new ConfigurationException(configurationFile, "FLIP is not defined or erratic.");
        }
        if (GeneralAlgorithmConfiguration.undefined(rotate180)) {
            throw new ConfigurationException(configurationFile, "ROTATE180 is not defined or erratic.");
        }
        if (GeneralAlgorithmConfiguration.undefined(rotate90R)) {
            throw new ConfigurationException(configurationFile, "ROTATE90R is not defined or erratic.");
        }
        if (GeneralAlgorithmConfiguration.undefined(rotate90L)) {
            throw new ConfigurationException(configurationFile, "ROTATE90L is not defined or erratic.");
        }
    }

    private static final boolean undefined(String code) {
        return code == null || code.length() != 95;
    }

    public String getFlip() {
        return flip;
    }

    public String getMirror() {
        return mirror;
    }

    public String getRotate180() {
        return rotate180;
    }

    public String getRotate90Left() {
        return rotate90L;
    }

    public String getRotate90Right() {
        return rotate90R;
    }
}

