/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.algorithm.repair;

public class AsciiRepairRule {
    private final int value;
    private final char[] chLine1;
    private final char[] chLine2;

    public AsciiRepairRule(int value, char[] chLine1, char[] chLine2) {
        this.value = value;
        this.chLine1 = chLine1;
        this.chLine2 = chLine2;
    }

    public static AsciiRepairRule getFrom(String l1, String l2, String l3) {
        try {
            int value = Integer.parseInt(l1.trim());
            while (l2.length() < l3.length()) {
                l2 = l2 + " ";
            }
            while (l3.length() < l2.length()) {
                l3 = l3 + " ";
            }
            return new AsciiRepairRule(value, l2.toCharArray(), l3.toCharArray());
        }
        catch (Exception e) {
            System.err.println(e);
            return null;
        }
    }

    public int rate(char[] a, char[] b) {
        int result = 0;
        for (int x = 0; x < a.length - this.chLine1.length + 1; ++x) {
            int i;
            boolean applies = true;
            for (i = 0; i < this.chLine1.length && applies; ++i) {
                if (this.chLine1[i] == '?' || this.chLine1[i] == a[x + i] || this.chLine1[i] == '!' && a[x + i] != ' ') continue;
                applies = false;
            }
            for (i = 0; i < this.chLine2.length && applies; ++i) {
                if (this.chLine2[i] == '?' || this.chLine2[i] == b[x + i] || this.chLine2[i] == '!' && b[x + i] != ' ') continue;
                applies = false;
            }
            if (!applies) continue;
            result += this.value;
        }
        return result;
    }
}

