/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.tool.text;

import de.jave.jave.JavEApplication;
import de.jave.jave.SelectionTool;
import de.jave.jave.Tool;
import de.jave.jave.icon.JaveIcons;
import de.jave.jave.plate.JaveMainPanel;
import de.jave.jave.preferences.BooleanPreferenceModel;
import de.jave.jave.preferences.ColorScheme;
import de.jave.jave.tool.text.CursorBlinker;
import de.jave.jave.tool.text.CursorMovement;
import de.jave.jave.tool.text.CursorMovementUi;
import de.jave.jave.tool.text.Direction;
import de.jave.jave.tool.text.ICursorMovementVisitor;
import de.jave.lib.CharacterPlate;
import de.jave.lib.Toolbox;
import de.jave.text.TextTools;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;
import net.disy.commons.swing.mousecursor.CursorId;
import net.disy.commons.swing.mousecursor.CursorProvider;
import net.disy.commons.swing.ui.ObjectUiListCellRenderer;

public class TextTool
extends Tool {
    private Point point1;
    private Rectangle selectionRegion;
    private JCheckBox cbMix;
    private static final boolean DEFAULT_MIX = false;
    private JComboBox chMovement;
    private Direction lastDirection = Direction.RIGHT;
    private final CursorBlinker blinkThread;

    public TextTool(JaveMainPanel mainPanel, JavEApplication jave, BooleanPreferenceModel cursorBlockStyle) {
        super(mainPanel, jave);
        Ensure.ensureArgumentNotNull(cursorBlockStyle);
        this.blinkThread = new CursorBlinker(mainPanel.getActiveEditorModel(), cursorBlockStyle);
        this.blinkThread.setInsert(TextTool.isInsert());
    }

    @Override
    public void cursorUp(int lines) {
        Point cursorLocation = this.getCursorLocation();
        cursorLocation.y -= lines;
        if (cursorLocation.y < 0) {
            cursorLocation.y = 0;
        }
        this.blinkThread.updateCursor();
    }

    @Override
    public void cursorDown(int lines) {
        Point cursorLocation = this.getCursorLocation();
        cursorLocation.y += lines;
        if (cursorLocation.y >= this.getPlate().getDocumentHeight()) {
            cursorLocation.y = this.getPlate().getDocumentHeight() - 1;
        }
        this.blinkThread.updateCursor();
    }

    private static boolean isOppositeDirection(Direction dir1, Direction dir2) {
        return dir1.isOpposite(dir2);
    }

    @Override
    public JComponent createOptionsComponent() {
        this.chMovement = new JComboBox<CursorMovement>(CursorMovement.values());
        this.chMovement.setRenderer(new ObjectUiListCellRenderer(new CursorMovementUi()));
        this.chMovement.setSelectedIndex(0);
        this.chMovement.addItemListener(this);
        this.cbMix = new JCheckBox("Mix Characters", false);
        this.cbMix.addItemListener(this);
        JPanel panel = new JPanel(new GridDialogLayout(2, false));
        panel.add((Component)new JLabel("Cursor movement:"), GridDialogLayoutData.RIGHT);
        panel.add(this.chMovement);
        panel.add(this.cbMix);
        return panel;
    }

    @Override
    public String getName() {
        return "Text";
    }

    @Override
    public Icon getIcon() {
        return JaveIcons.TOOL_TEXT_ICON;
    }

    @Override
    public void takeToHand() {
        this.setCursor(CursorProvider.getInstance().getCursor(CursorId.TEXT));
        this.blinkThread.setActive(true);
    }

    @Override
    public void putAside(boolean nextToolIsSelectionTool) {
        this.blinkThread.setActive(false);
    }

    @Override
    public void checkSize() {
        Point cursorLocation = this.getCursorLocation();
        if (cursorLocation.x >= this.getPlate().getDocumentWidth()) {
            cursorLocation.x = this.getPlate().getDocumentWidth() - 1;
        } else if (cursorLocation.x < 0) {
            cursorLocation.x = 0;
        }
        if (cursorLocation.y >= this.getPlate().getDocumentHeight()) {
            cursorLocation.y = this.getPlate().getDocumentHeight() - 1;
        } else if (cursorLocation.y < 0) {
            cursorLocation.y = 0;
        }
    }

    @Override
    public void paintCursorFeature(Graphics2D g, Point plateOrigin, ColorScheme colorScheme) {
        if (this.selectionRegion != null) {
            this.showStatus("(" + this.selectionRegion.x + "," + this.selectionRegion.y + ") -> (" + (this.selectionRegion.x + this.selectionRegion.width) + "," + this.selectionRegion.y + this.selectionRegion.height + ") = (" + this.selectionRegion.width + "," + this.selectionRegion.height + ")");
            g.setColor(colorScheme.getColorTool());
            Point p = this.getScreenPointFor(this.selectionRegion.x, this.selectionRegion.y);
            g.drawRect(p.x, p.y, this.selectionRegion.width * this.getPlate().getCharWidth(), this.selectionRegion.height * this.getPlate().getCharHeight());
        }
    }

    @Override
    public void mousePressed(Point point, Point location, MouseEvent evt) {
        if (location == null) {
            return;
        }
        this.blinkThread.setHasSelection(false);
        this.selectionRegion = null;
        this.point1 = point;
        Point cursorLocation = this.getCursorLocation();
        cursorLocation.x = location.x;
        cursorLocation.y = location.y;
        this.blinkThread.updateCursor();
    }

    @Override
    public void mouseDragged(Point point, Point location, MouseEvent evt) {
        Point cursorLocation = this.getCursorLocation();
        if (location == null || this.point1 == null || cursorLocation == null || evt.isMetaDown()) {
            return;
        }
        if (Toolbox.abs(this.point1.x - point.x) > 2 || Toolbox.abs(this.point1.y - point.y) > 2) {
            Rectangle r = TextTool.getRectangleFor(cursorLocation, location);
            if (r.equals(this.selectionRegion)) {
                return;
            }
            this.blinkThread.setHasSelection(true);
            this.selectionRegion = r;
            this.blinkThread.updateCursor();
            this.repaintCursor();
        } else if (this.selectionRegion != null) {
            this.selectionRegion = null;
            this.blinkThread.setHasSelection(false);
            this.repaintCursor();
        }
    }

    @Override
    public void mouseReleased(Point point, Point location, MouseEvent evt) {
        if (this.selectionRegion != null) {
            this.jave.switchToSelectonTool();
            this.getPlate().setSelection(this.selectionRegion);
            this.point1 = null;
            this.blinkThread.setHasSelection(false);
            this.selectionRegion = null;
            SelectionTool st = this.jave.getSelectionTool();
            st.synchronizeToSelection();
            return;
        }
        if (evt.getClickCount() == 2 && this.getPlate().isInside(location) && this.getPlate().getChar(location.x, location.y) != ' ') {
            Rectangle r = this.getAutoSelectRegion(location.x, location.y);
            this.jave.switchToSelectonTool();
            this.getPlate().setSelection(r);
            this.point1 = null;
            this.blinkThread.setHasSelection(false);
            this.selectionRegion = null;
            SelectionTool st = this.jave.getSelectionTool();
            st.synchronizeToSelection();
            return;
        }
        this.point1 = null;
        this.blinkThread.setHasSelection(false);
        this.selectionRegion = null;
    }

    private void moveToTrack() {
        char c;
        Point cursorLocation = this.getCursorLocation();
        int x = cursorLocation.x;
        int y = cursorLocation.y;
        if (x + 1 < this.getPlate().getDocumentWidth() && (c = this.getPlate().getChar(x + 1, y)) != ' ' && !this.lastDirection.isOpposite(Direction.RIGHT)) {
            this.moveCursorRight();
            return;
        }
        if (y + 1 < this.getPlate().getDocumentHeight() && (c = this.getPlate().getChar(x, y + 1)) != ' ' && !TextTool.isOppositeDirection(this.lastDirection, Direction.DOWN)) {
            this.moveCursorDown();
            return;
        }
        if (x > 0 && (c = this.getPlate().getChar(x - 1, y)) != ' ' && !TextTool.isOppositeDirection(this.lastDirection, Direction.LEFT)) {
            this.moveCursorLeft();
            return;
        }
        if (y > 0 && (c = this.getPlate().getChar(x, y - 1)) != ' ' && !TextTool.isOppositeDirection(this.lastDirection, Direction.UP)) {
            this.moveCursorUp();
            return;
        }
        if (x + 1 < this.getPlate().getDocumentWidth() && y > 0 && (c = this.getPlate().getChar(x + 1, y - 1)) != ' ' && !TextTool.isOppositeDirection(this.lastDirection, Direction.RIGHT_UP)) {
            this.moveCursorRightUp();
            return;
        }
        if (x + 1 < this.getPlate().getDocumentWidth() && y + 1 < this.getPlate().getDocumentHeight() && (c = this.getPlate().getChar(x + 1, y + 1)) != ' ' && !TextTool.isOppositeDirection(this.lastDirection, Direction.RIGHT_DOWN)) {
            this.moveCursorRightDown();
            return;
        }
        if (x > 0 && y > 0 && (c = this.getPlate().getChar(x - 1, y - 1)) != ' ' && !TextTool.isOppositeDirection(this.lastDirection, Direction.LEFT_UP)) {
            this.moveCursorLeftUp();
            return;
        }
        if (x > 0 && y + 1 < this.getPlate().getDocumentHeight() && (c = this.getPlate().getChar(x - 1, y + 1)) != ' ' && !TextTool.isOppositeDirection(this.lastDirection, Direction.LEFT_DOWN)) {
            this.moveCursorLeftDown();
            return;
        }
        this.moveCursorRight();
    }

    public void charEntered(char ch) {
        if (ch < ' ' || ch > '\u00ff' || ch > '~' && ch < '\u0091') {
            return;
        }
        Point cursorLocation = this.getCursorLocation();
        if (insert) {
            this.setMixMode(false);
            if (cursorLocation.x == this.getPlate().getDocumentWidth() - 1) {
                this.getPlate().setChar(cursorLocation, ch);
                this.getPlate().addColumnsRight(1);
            } else {
                CharacterPlate cp = this.getPlate().getContent();
                String lineContent = cp.getLine(cursorLocation.y, cursorLocation.x);
                if (lineContent.charAt(lineContent.length() - 1) != ' ') {
                    this.getPlate().addColumnsRight(1);
                } else {
                    lineContent = lineContent.substring(0, lineContent.length() - 1);
                }
                cp.paste(lineContent, cursorLocation.x + 1, cursorLocation.y);
                this.getPlate().setChar(cursorLocation, ch);
            }
        } else {
            this.setMixMode(this.cbMix.isSelected());
            this.getPlate().setChar(cursorLocation, ch);
        }
        CursorMovement movement = (CursorMovement)((Object)this.chMovement.getSelectedItem());
        movement.accept(new ICursorMovementVisitor(){

            @Override
            public void visitNormal(CursorMovement cursorMovement) {
                TextTool.this.moveCursorRight();
            }

            @Override
            public void visitDirected(CursorMovement cursorMovement) {
                if (TextTool.this.lastDirection == Direction.UP) {
                    TextTool.this.moveCursorUp();
                } else if (TextTool.this.lastDirection == Direction.DOWN) {
                    TextTool.this.moveCursorDown();
                } else if (TextTool.this.lastDirection == Direction.RIGHT) {
                    TextTool.this.moveCursorRight();
                } else if (TextTool.this.lastDirection == Direction.LEFT) {
                    TextTool.this.moveCursorLeft();
                } else if (TextTool.this.lastDirection == null) {
                    TextTool.this.moveCursorRight();
                }
            }

            @Override
            public void visitTrackFollowing(CursorMovement cursorMovement) {
                TextTool.this.moveToTrack();
            }

            @Override
            public void visitNone(CursorMovement cursorMovement) {
            }
        });
        this.getPlate().ensureVisible(cursorLocation);
        this.blinkThread.updateCursor();
        this.repaintAll();
        this.getPlate().saveCurrentState("text");
    }

    @Override
    public void setInsert(boolean what) {
        super.setInsert(what);
        this.blinkThread.setInsert(insert);
        this.blinkThread.updateCursor();
        this.cbMix.setEnabled(!what);
    }

    public void setCursorLocation(int x, int y) {
        Point cursorLocation = this.getCursorLocation();
        cursorLocation.x = x;
        cursorLocation.y = y;
        this.getPlate().ensureVisible(cursorLocation);
        this.blinkThread.updateCursor();
    }

    private void backSpace() {
        Point cursorLocation = this.getCursorLocation();
        if (cursorLocation.x == 0 && cursorLocation.y == 0) {
            this.beep();
            this.blinkThread.updateCursor();
            return;
        }
        if (!insert) {
            this.moveCursorLeft();
            this.getPlate().setCharForce(cursorLocation, ' ');
        } else {
            boolean lineEnd;
            if (cursorLocation.x == 0) {
                CharacterPlate cp = this.getPlate().getContent();
                String currentLine = TextTools.trimRight(cp.getLine(cursorLocation.y));
                String prevLine = TextTools.trimRight(cp.getLine(cursorLocation.y - 1));
                if (prevLine.length() == 0) {
                    this.getPlate().removeLine(cursorLocation.y - 1);
                    --cursorLocation.y;
                } else {
                    if (prevLine.length() + currentLine.length() >= cp.getWidth()) {
                        this.getPlate().addColumnsRight(prevLine.length() + currentLine.length() - cp.getWidth());
                    }
                    cp.paste(currentLine, prevLine.length(), cursorLocation.y - 1);
                    this.getPlate().removeLine(cursorLocation.y);
                    --cursorLocation.y;
                    cursorLocation.x = prevLine.length();
                }
                this.blinkThread.updateCursor();
                return;
            }
            CharacterPlate cp = this.getPlate().getContent();
            String lineContent = TextTools.trimRight(cp.getLine(cursorLocation.y, cursorLocation.x));
            boolean bl = lineEnd = lineContent.length() == 0;
            if (!lineEnd) {
                this.moveCursorLeft();
                cp.paste(lineContent, cursorLocation.x, cursorLocation.y);
                this.getPlate().setCharForce(cursorLocation.x + lineContent.length(), cursorLocation.y, ' ');
            } else {
                this.moveCursorLeft();
                this.getPlate().setCharForce(cursorLocation, ' ');
            }
        }
        this.getPlate().ensureVisible(cursorLocation);
        this.repaintAll();
        this.saveCurrentState("text");
        this.blinkThread.updateCursor();
    }

    private void delete() {
        Point cursorLocation = this.getCursorLocation();
        if (!insert) {
            this.getPlate().setCharForce(cursorLocation, ' ');
        } else {
            CharacterPlate cp = this.getDocument().getContent();
            if (cursorLocation.x == this.getPlate().getDocumentWidth()) {
                int x;
                String lineContent = cp.getLine(cursorLocation.y, cursorLocation.x + 1);
                for (x = lineContent.length() - 1; x > 0 && lineContent.charAt(x) == ' '; --x) {
                }
                lineContent = lineContent.substring(0, x + 1);
                this.getPlate().removeLine(cursorLocation.y);
                x = cp.getWidth();
                while (cp.get(x - 1, cursorLocation.y - 1) == ' ') {
                    --x;
                }
                if (x + lineContent.length() >= cp.getWidth()) {
                    this.getPlate().addColumnsRight(x + lineContent.length() - cp.getWidth());
                }
                cp.paste(lineContent, x, cursorLocation.y - 1);
                cursorLocation.x = x;
                --cursorLocation.y;
            } else {
                String lineContent = cp.getLine(cursorLocation.y, cursorLocation.x + 1);
                cp.paste(lineContent, cursorLocation.x, cursorLocation.y);
                cp.delete(cp.getWidth() - 1, cursorLocation.y, cp.getWidth() - 1, cursorLocation.y);
            }
        }
        this.getPlate().ensureVisible(cursorLocation);
        this.repaintAll();
        this.saveCurrentState("text");
        this.blinkThread.updateCursor();
    }

    private void enter() {
        Point cursorLocation = this.getCursorLocation();
        if (!insert || shiftDown) {
            this.moveCursorNewline();
            this.getPlate().ensureVisible(cursorLocation);
            this.blinkThread.updateCursor();
            return;
        }
        CharacterPlate cp = this.getPlate().getContent();
        String lineContent = cp.getLine(cursorLocation.y, cursorLocation.x);
        cp.delete(cursorLocation.x, cursorLocation.y, cp.getWidth() - 1, cursorLocation.y);
        this.getPlate().insertLine(cursorLocation.y + 1, lineContent);
        this.moveCursorNewline();
        this.getPlate().ensureVisible(cursorLocation);
        this.getPlate().saveCurrentState("text");
        this.blinkThread.updateCursor();
    }

    @Override
    public void keyTyped(char ch, KeyEvent evt) {
        this.charEntered(ch);
    }

    @Override
    public void keyPressed(int code, KeyEvent evt) {
        if (code == 9 && controlDown) {
            return;
        }
        if (code == 27) {
            this.point1 = null;
            this.blinkThread.setHasSelection(false);
            this.selectionRegion = null;
            this.repaintCursor();
            return;
        }
        Point cursorLocation = this.getCursorLocation();
        if (shiftDown && (code == 38 || code == 40 || code == 37 || code == 39)) {
            int dx = 0;
            boolean dy = false;
            switch (code) {
                case 38: {
                    if (cursorLocation.y != 0) break;
                    this.beep();
                    return;
                }
                case 40: {
                    break;
                }
                case 37: {
                    if (cursorLocation.x == 0) {
                        this.beep();
                        return;
                    }
                    dx = 1;
                    break;
                }
            }
            this.jave.switchToSelectonTool();
            this.getPlate().setSelection(new Rectangle(cursorLocation.x - dx, cursorLocation.y - 0, 1, 1));
            SelectionTool st = this.jave.getSelectionTool();
            st.synchronizeToSelection();
            evt.consume();
            return;
        }
        switch (code) {
            case 127: {
                this.delete();
                return;
            }
            case 8: {
                this.backSpace();
                return;
            }
            case 38: {
                this.moveCursorUp();
                this.getPlate().ensureVisible(cursorLocation);
                this.blinkThread.updateCursor();
                evt.consume();
                return;
            }
            case 40: {
                this.moveCursorDown();
                this.getPlate().ensureVisible(cursorLocation);
                this.blinkThread.updateCursor();
                evt.consume();
                return;
            }
            case 39: {
                this.moveCursorRight();
                this.getPlate().ensureVisible(cursorLocation);
                this.blinkThread.updateCursor();
                evt.consume();
                return;
            }
            case 9: {
                for (int i = 0; i < 8; ++i) {
                    this.moveCursorRight();
                }
                this.getPlate().ensureVisible(cursorLocation);
                this.blinkThread.updateCursor();
                return;
            }
            case 37: {
                this.moveCursorLeft();
                this.getPlate().ensureVisible(cursorLocation);
                this.blinkThread.updateCursor();
                evt.consume();
                return;
            }
            case 35: {
                if (evt.isControlDown()) {
                    this.moveCursorCtrlEnd();
                } else {
                    this.moveCursorEnd();
                }
                this.getPlate().ensureVisible(cursorLocation);
                this.blinkThread.updateCursor();
                return;
            }
            case 36: {
                if (evt.isControlDown()) {
                    this.moveCursorCtrlPos1();
                } else {
                    this.moveCursorPos1();
                }
                this.getPlate().ensureVisible(cursorLocation);
                this.blinkThread.updateCursor();
                return;
            }
            case 10: {
                this.enter();
                return;
            }
        }
    }

    private void moveCursorRight() {
        Point cursorLocation = this.getCursorLocation();
        if (cursorLocation.x + 1 == this.getPlate().getDocumentWidth()) {
            this.beep();
        } else {
            ++cursorLocation.x;
        }
        this.lastDirection = Direction.RIGHT;
    }

    private void moveCursorLeft() {
        Point cursorLocation = this.getCursorLocation();
        if (cursorLocation.x == 0) {
            this.beep();
        } else {
            --cursorLocation.x;
        }
        this.lastDirection = Direction.LEFT;
    }

    private void moveCursorNewline() {
        Point cursorLocation = this.getCursorLocation();
        if (cursorLocation.y + 1 == this.getPlate().getDocumentHeight()) {
            this.beep();
        } else {
            cursorLocation.x = 0;
            ++cursorLocation.y;
        }
    }

    private void moveCursorRightDown() {
        Point cursorLocation = this.getCursorLocation();
        if (cursorLocation.y + 1 == this.getPlate().getDocumentHeight() || cursorLocation.x + 1 == this.getPlate().getDocumentWidth()) {
            this.beep();
        } else {
            ++cursorLocation.y;
            ++cursorLocation.x;
        }
        this.lastDirection = Direction.RIGHT_DOWN;
    }

    private void moveCursorRightUp() {
        Point cursorLocation = this.getCursorLocation();
        if (cursorLocation.y == 0 || cursorLocation.x + 1 == this.getPlate().getDocumentWidth()) {
            this.beep();
        } else {
            --cursorLocation.y;
            ++cursorLocation.x;
        }
        this.lastDirection = Direction.RIGHT_UP;
    }

    private void moveCursorLeftDown() {
        Point cursorLocation = this.getCursorLocation();
        if (cursorLocation.y + 1 == this.getPlate().getDocumentHeight() || cursorLocation.x == 0) {
            this.beep();
        } else {
            ++cursorLocation.y;
            --cursorLocation.x;
        }
        this.lastDirection = Direction.LEFT_DOWN;
    }

    private void moveCursorLeftUp() {
        Point cursorLocation = this.getCursorLocation();
        if (cursorLocation.y == 0 || cursorLocation.x == 0) {
            this.beep();
        } else {
            --cursorLocation.y;
            --cursorLocation.x;
        }
        this.lastDirection = Direction.LEFT_UP;
    }

    private void moveCursorDown() {
        Point cursorLocation = this.getCursorLocation();
        if (cursorLocation.y + 1 == this.getPlate().getDocumentHeight()) {
            this.beep();
        } else {
            ++cursorLocation.y;
        }
        this.lastDirection = Direction.DOWN;
    }

    private void moveCursorUp() {
        Point cursorLocation = this.getCursorLocation();
        if (cursorLocation.y == 0) {
            this.beep();
        } else {
            --cursorLocation.y;
        }
        this.lastDirection = Direction.UP;
    }

    private void moveCursorEnd() {
        Point cursorLocation = this.getCursorLocation();
        if (insert) {
            CharacterPlate cp = this.getPlate().getContent();
            String lineContent = TextTools.trimRight(cp.getLine(cursorLocation.y));
            int newX = lineContent.length();
            if (newX > this.getPlate().getDocumentWidth() - 1) {
                this.getPlate().addColumnsRight(1);
            }
            cursorLocation.x = newX == cursorLocation.x ? this.getPlate().getDocumentWidth() - 1 : newX;
            return;
        }
        cursorLocation.x = this.getPlate().getDocumentWidth() - 1;
    }

    private void moveCursorPos1() {
        Point cursorLocation = this.getCursorLocation();
        cursorLocation.x = 0;
    }

    private void moveCursorCtrlEnd() {
        Point cursorLocation = this.getCursorLocation();
        cursorLocation.x = this.getPlate().getDocumentWidth() - 1;
        cursorLocation.y = this.getPlate().getDocumentHeight() - 1;
    }

    private void moveCursorCtrlPos1() {
        Point cursorLocation = this.getCursorLocation();
        cursorLocation.x = 0;
        cursorLocation.y = 0;
    }
}

