/*
 * Decompiled with CFR 0.152.
 */
package de.jave.lib;

import java.awt.Color;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Random;
import java.util.Vector;

public class Toolbox {
    private static Random rand;

    private Toolbox() {
    }

    public static String getStackTrace(Throwable th) {
        StringWriter strout = new StringWriter();
        PrintWriter prnout = new PrintWriter(strout);
        th.printStackTrace(prnout);
        prnout.flush();
        return strout.toString();
    }

    public static final URL toURL(File file) throws MalformedURLException {
        String path = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            path = path.replace(File.separatorChar, '/');
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/") && file.isDirectory()) {
            path = path + "/";
        }
        return new URL("file", "", path);
    }

    public static final String toJavaString(String s) {
        StringBuffer sb = new StringBuffer("\"");
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == '\"') {
                sb.append("\\\"");
                continue;
            }
            if (ch == '\\') {
                sb.append("\\\\");
                continue;
            }
            sb.append(ch);
        }
        sb.append('\"');
        return sb.toString();
    }

    public static final String getDateString() {
        Calendar rightNow = Calendar.getInstance();
        int sec = rightNow.get(13);
        int min = rightNow.get(12);
        String secStr = sec < 10 ? "0" + sec : String.valueOf(sec);
        String minStr = min < 10 ? "0" + min : String.valueOf(min);
        String date = rightNow.get(1) + "/" + (rightNow.get(2) + 1) + "/" + rightNow.get(5) + " " + rightNow.get(11) + ":" + minStr + ":" + secStr;
        return date;
    }

    public static String colorToHexString(Color color) {
        String red = Integer.toHexString(color.getRed());
        String green = Integer.toHexString(color.getGreen());
        String blue = Integer.toHexString(color.getBlue());
        if (red.length() == 1) {
            red = "0" + red;
        }
        if (green.length() == 1) {
            green = "0" + green;
        }
        if (blue.length() == 1) {
            blue = "0" + blue;
        }
        return red + green + blue;
    }

    public static Color hexStringToColor(String color) {
        if (color.length() == 6) {
            color = color.toLowerCase();
        } else if (color.length() == 7) {
            color = color.substring(1).toLowerCase();
        } else {
            throw new RuntimeException("Wrong format for color: " + color);
        }
        int red = 16 * Toolbox.hexToInt(color.charAt(0)) + Toolbox.hexToInt(color.charAt(1));
        int green = 16 * Toolbox.hexToInt(color.charAt(2)) + Toolbox.hexToInt(color.charAt(3));
        int blue = 16 * Toolbox.hexToInt(color.charAt(4)) + Toolbox.hexToInt(color.charAt(5));
        return new Color(red, green, blue);
    }

    protected static final int hexToInt(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'a' && ch <= 'f') {
            return 10 + ch - 97;
        }
        throw new RuntimeException("Wrong format for hexadecimal number: " + ch);
    }

    public static double round(double x, int length) {
        int mult = (int)Math.pow(10.0, length);
        return Math.rint(x * (double)mult) / (double)mult;
    }

    public static Color toColor(int value, int min, int max) {
        if (value > max) {
            value = max;
        }
        value = max - value;
        double hue = ((double)value - (double)min) / ((double)max - (double)min) * 2.0 / 3.0;
        Color c = new Color(Color.HSBtoRGB((float)hue, 1.0f, 0.7f));
        return c;
    }

    public static int random(int min, int max) {
        if (rand == null) {
            rand = new Random();
        }
        return min + Math.abs(rand.nextInt()) % (max - min + 1);
    }

    public static double random() {
        if (rand == null) {
            rand = new Random();
        }
        return rand.nextDouble();
    }

    public static String randomString() {
        return Toolbox.randomString(2000);
    }

    public static String randomString(int maxLength) {
        if (rand == null) {
            rand = new Random();
        }
        int length = Math.abs(rand.nextInt() % maxLength);
        char[] b = new char[length];
        for (int i = 0; i < b.length; ++i) {
            int r = Math.abs(rand.nextInt()) % 38;
            b[i] = r >= 26 ? 32 : (char)(r + 65);
        }
        String s = new String(b);
        return s;
    }

    public static void sortStringsBubbleSort(String[] strings) {
        for (int i = 0; i < strings.length - 1; ++i) {
            for (int j = i + 1; j < strings.length; ++j) {
                if (strings[i].compareTo(strings[j]) <= 0) continue;
                String t = strings[i];
                strings[i] = strings[j];
                strings[j] = t;
            }
        }
    }

    public static String fill(String source, char fill, int length) {
        if (source.length() >= length) {
            return source;
        }
        int f = length - source.length();
        for (int i = 0; i < f; ++i) {
            source = source + fill;
        }
        return source;
    }

    public static String fill(int source, char fill, int length) {
        String s = String.valueOf(source);
        if (s.length() >= length) {
            return s;
        }
        int f = length - s.length();
        for (int i = 0; i < f; ++i) {
            s = fill + s;
        }
        return s;
    }

    public static String fill(double source, char fill, int length) {
        String s = String.valueOf(source);
        if (s.length() >= length) {
            return s;
        }
        int f = length - s.length();
        for (int i = 0; i < f; ++i) {
            s = fill + s;
        }
        return s;
    }

    public static String format(double num, int decimals, boolean plusMinus, char fill, int length) {
        String result = String.valueOf(Toolbox.round(num, decimals));
        if (plusMinus && num > 0.0) {
            result = "+" + result;
        }
        if (result.length() >= length) {
            return result;
        }
        int f = length - result.length();
        for (int i = 0; i < f; ++i) {
            result = fill + result;
        }
        return result;
    }

    public static int nextPrim(int start) {
        while (!Toolbox.isPrim(start)) {
            ++start;
        }
        return start;
    }

    public static boolean isPrim(int number) {
        if (number < 2) {
            return false;
        }
        int max = (int)Math.sqrt(number);
        int c = 1;
        while (c++ < max) {
            if ((double)number / (double)c != (double)(number / c)) continue;
            return false;
        }
        return true;
    }

    public static String byteSizeToString(long size) {
        String result = "";
        int GB = (int)(size / 0x40000000L);
        if (GB > 0) {
            result = "" + GB;
            if (GB < 10) {
                int i = (int)((double)size / 1.073741824E9 * 100.0) % 100;
                if (i != 0) {
                    result = i < 10 ? result + ".0" + i : result + "." + i;
                }
            } else if (GB < 100) {
                result = result + "." + (int)((double)size / 1.073741824E9 * 10.0) % 10;
            }
            result = result + " GByte";
            return result;
        }
        int MB = (int)(size / 0x100000L);
        if (MB > 0) {
            result = "" + MB;
            if (MB < 10) {
                int i = (int)((double)size / 1048576.0 * 100.0) % 100;
                if (i != 0) {
                    result = i < 10 ? result + ".0" + i : result + "." + i;
                }
            } else if (MB < 100) {
                result = result + "." + (int)((double)size / 1048576.0 * 10.0) % 10;
            }
            result = result + " MByte";
            return result;
        }
        int KB = (int)(size / 1024L);
        if (KB > 0) {
            result = "" + KB;
            if (KB < 10) {
                int i = (int)((double)size / 1024.0 * 100.0) % 100;
                if (i != 0) {
                    result = i < 10 ? result + ".0" + i : result + "." + i;
                }
            } else if (KB < 100) {
                result = result + "." + (int)((double)size / 1024.0 * 10.0) % 10;
            }
            result = result + " kByte";
            return result;
        }
        return size + " Byte";
    }

    public static String urlDecoder(String encoded) {
        StringBuffer decoded = new StringBuffer();
        int len = encoded.length();
        for (int i = 0; i < len; ++i) {
            if (encoded.charAt(i) == '%' && i + 2 < len) {
                int d1 = Character.digit(encoded.charAt(i + 1), 16);
                int d2 = Character.digit(encoded.charAt(i + 2), 16);
                if (d1 != -1 && d2 != -1) {
                    decoded.append((char)((d1 << 4) + d2));
                }
                i += 2;
                continue;
            }
            if (encoded.charAt(i) == '+') {
                decoded.append(' ');
                continue;
            }
            decoded.append(encoded.charAt(i));
        }
        return decoded.toString();
    }

    public static String toUU(String s) {
        s = s.replace(' ', '+');
        return s;
    }

    public static void removeDublicates(Vector r) {
        Toolbox.quickSort(r);
        for (int i = 0; i < r.size() - 1; ++i) {
            if (!r.elementAt(i).equals(r.elementAt(i + 1))) continue;
            r.removeElementAt(i + 1);
            --i;
        }
    }

    private static void quickSort(int[] a, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            int mid = a[(lo0 + hi0) / 2];
            while (lo <= hi) {
                while (lo < hi0 && a[lo] < mid) {
                    ++lo;
                }
                while (hi > lo0 && a[hi] > mid) {
                    --hi;
                }
                if (lo > hi) continue;
                Toolbox.swap(a, lo, hi);
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                Toolbox.quickSort(a, lo0, hi);
            }
            if (lo < hi0) {
                Toolbox.quickSort(a, lo, hi0);
            }
        }
    }

    private static void swap(int[] a, int i, int j) {
        int t = a[i];
        a[i] = a[j];
        a[j] = t;
    }

    public static void quickSort(int[] a) {
        Toolbox.quickSort(a, 0, a.length - 1);
    }

    public static int compareToIgnoreCase(String s1, String s2) {
        int n1 = s1.length();
        int n2 = s2.length();
        int i1 = 0;
        for (int i2 = 0; i1 < n1 && i2 < n2; ++i1, ++i2) {
            char c2;
            char c1 = s1.charAt(i1);
            if (c1 == (c2 = s2.charAt(i2)) || (c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2)) || (c1 = Character.toLowerCase(c1)) == (c2 = Character.toLowerCase(c2))) continue;
            return c1 - c2;
        }
        return n1 - n2;
    }

    public static void quickSort(String[] s) {
        Arrays.sort(s);
    }

    public static void quickSort(Vector r) {
        Toolbox.qSort(r, 0, r.size() - 1);
    }

    private static void qSort(Vector a, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            Comparable mid = (Comparable)a.elementAt((lo0 + hi0) / 2);
            while (lo <= hi) {
                while (lo < hi0 && ((Comparable)a.elementAt(lo)).compareTo(mid) > 0) {
                    ++lo;
                }
                while (hi > lo0 && ((Comparable)a.elementAt(hi)).compareTo(mid) < 0) {
                    --hi;
                }
                if (lo > hi) continue;
                Comparable cache = (Comparable)a.elementAt(lo);
                a.setElementAt(a.elementAt(hi), lo);
                a.setElementAt(cache, hi);
                cache = null;
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                Toolbox.qSort(a, lo0, hi);
            }
            if (lo < hi0) {
                Toolbox.qSort(a, lo, hi0);
            }
        }
    }

    public static double roundSignificant(double x, int length) {
        double f;
        if (length <= 0) {
            throw new IllegalArgumentException("Not a valid value for significant ciffers: " + length);
        }
        if (x == 0.0) {
            return x;
        }
        long mult = 1L;
        if (x < 0.0) {
            mult *= -1L;
            x *= -1.0;
        }
        if (x < (f = Math.pow(10.0, length - 1))) {
            while (x < f) {
                x *= 10.0;
                mult *= 10L;
            }
            x = Math.rint(x) / (double)mult;
            return x;
        }
        while (x >= f) {
            x /= 10.0;
            mult *= 10L;
        }
        x *= 10.0;
        x = Math.rint(x) * (double)(mult /= 10L);
        return x;
    }

    public static void main(String[] args) {
        System.err.println(Toolbox.nextPrim(1000));
    }

    public static boolean bothNullOrEquals(Object value1, Object value2) {
        if (value1 == null) {
            return value2 == null;
        }
        return value1.equals(value2);
    }

    public static final int abs(int i) {
        return i < 0 ? -i : i;
    }

    public static final int min(int a, int b) {
        return a < b ? a : b;
    }

    public static final int max(int a, int b) {
        return a > b ? a : b;
    }

    public static final int max(int a, int b, int c) {
        return Toolbox.max(a, Toolbox.max(b, c));
    }

    public static final int max(int a, int b, int c, int d) {
        return Toolbox.max(Toolbox.max(a, b), Toolbox.max(c, d));
    }
}

