/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.db;

import cib.cad.db.Marker;
import cib.cad.db.comp.Component;
import cib.util.coll.ObservableSet;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MarkerMap
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final int GEOMETRY_CHAIN = 0;
    public static final int TEXT_CHAIN = 1;
    public static final int CONTROL_POINT_CHAIN = 2;
    public static final int IMAGE_CHAIN = 3;
    public static final int N_CHAINS = 4;
    protected ObservableSet<Component> m_componentSet = null;
    protected ObservableSet<Component> m_selectSet = null;
    protected Map<Component, Marker> m_map = new HashMap<Component, Marker>();
    protected Set<Listener> m_listeners = new HashSet<Listener>();

    protected MarkerMap() {
    }

    public MarkerMap(ObservableSet<Component> componentSet, ObservableSet<Component> selectSet) {
        this.m_componentSet = componentSet;
        this.m_componentSet.addListener(new ObservableSet.Listener<Component>(){
            private static final long serialVersionUID = 0L;

            @Override
            public void wasAdded(Component o) {
                MarkerMap.this._add(o);
            }

            @Override
            public void wasChanged(Component o) {
            }

            @Override
            public void wasRemoved(Component o) {
                MarkerMap.this._remove(o);
            }
        });
        for (Component comp : componentSet) {
            this._add(comp);
        }
        this.m_selectSet = selectSet;
        this.m_selectSet.addListener(new ObservableSet.Listener<Component>(){
            private static final long serialVersionUID = 0L;

            @Override
            public void wasAdded(Component o) {
                Marker m = MarkerMap.this.getMarker(o);
                m.mark();
                MarkerMap.this._notifyListeners(o, true);
            }

            @Override
            public void wasChanged(Component o) {
            }

            @Override
            public void wasRemoved(Component o) {
                Marker m = MarkerMap.this.getMarker(o);
                m.mark(false);
                MarkerMap.this._notifyListeners(o, false);
            }
        });
    }

    public boolean addListener(Listener l) {
        return this.m_listeners.add(l);
    }

    public boolean removeListener(Listener l) {
        return this.m_listeners.remove(l);
    }

    public void clearListeners() {
        this.m_listeners.clear();
    }

    private void _notifyListeners(Component o) {
        for (Listener l : this.m_listeners) {
            l.markerWasChanged(o);
        }
    }

    private void _notifyListeners(Component o, boolean status) {
        for (Listener l : this.m_listeners) {
            l.marked(o, status);
        }
    }

    private void _notifyListeners(Component o, int chain, int idx, boolean status) {
        for (Listener l : this.m_listeners) {
            l.markedPrimitive(o, chain, idx, status);
        }
    }

    public Marker getMarker(Component obj) {
        Marker m = this.m_map.get(obj);
        if (m == null) {
            throw new IllegalArgumentException();
        }
        return m;
    }

    public void putMarker(Component o, Marker m) {
        this.m_map.put(o, m);
    }

    public void getAllMarkers(Map<Component, Marker> map) {
        map.clear();
        Set<Component> comps = this.m_map.keySet();
        for (Component comp : comps) {
            Marker m = this.m_map.get(comp);
            map.put(comp, (Marker)m.clone());
        }
    }

    private boolean _add(Component obj) {
        if (this.m_map.containsKey(obj)) {
            return false;
        }
        this.m_map.put(obj, new Marker(4));
        return true;
    }

    private boolean _remove(Component obj) {
        return this.m_map.remove(obj) != null;
    }

    public boolean isMarked(Component obj) {
        return this.getMarker(obj).isMarked();
    }

    public void mark(Component obj, boolean status) {
        if (this.getMarker(obj).isMarked() != status) {
            this.getMarker(obj).mark(status);
            this._notifyListeners(obj);
            this._notifyListeners(obj, status);
        }
    }

    public void mark(Component obj) {
        if (!this.getMarker(obj).isMarked()) {
            this.getMarker(obj).mark();
            this._notifyListeners(obj);
            this._notifyListeners(obj, true);
        }
    }

    public boolean hasMarkedPrimitives(Component obj, int chain) {
        return this.getMarker(obj).hasMarkedPrimitives(chain);
    }

    public boolean primitiveMarked(Component obj, int chain, int index) {
        return this.getMarker(obj).primitiveMarked(chain, index);
    }

    public void markPrimitive(Component obj, int chain, int index, boolean status) {
        if (this.getMarker(obj).primitiveMarked(chain, index) != status) {
            this.getMarker(obj).markPrimitive(chain, index, status);
            this._notifyListeners(obj);
            this._notifyListeners(obj, chain, index, status);
        }
    }

    public void markPrimitive(Component obj, int chain, int index) {
        if (!this.getMarker(obj).primitiveMarked(chain, index)) {
            this.getMarker(obj).markPrimitive(chain, index);
            this._notifyListeners(obj);
            this._notifyListeners(obj, chain, index, true);
        }
    }

    public void clearChain(Component obj, int chain) {
        if (this.getMarker(obj).hasMarkedPrimitives(chain)) {
            this.getMarker(obj).clearChain(chain);
            this._notifyListeners(obj);
        }
    }

    public String toString() {
        return this.m_map.toString();
    }

    public static class Listener {
        public void markerWasChanged(Component o) {
        }

        public void marked(Component o, boolean status) {
        }

        public void markedPrimitive(Component o, int chain, int idx, boolean status) {
        }
    }
}

