/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.db.att;

import cib.cad.db.att.AttributeTupleFactory;
import cib.cad.db.att.Attributes;
import cib.cad.db.att._AttributeNamespaces;
import cib.cad.db.comp.Component;
import cib.cad.lang.Messages;
import cib.util.coll.ObservableSet;
import cib.util.geo.Geo2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class AttributeManager
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final int ALPHA = 180;
    private static AttributeManager s_instance = null;
    private _AttributeNamespaces m_attNamespaces;
    private AttributeTupleFactory m_attFactory;
    private Attributes m_defaultAttributes;
    private Set<Listener> m_listeners = new HashSet<Listener>();

    private AttributeManager() {
        if (s_instance == null) {
            s_instance = this;
        }
        this.m_attNamespaces = _AttributeNamespaces.getNamespaces();
        this.m_attFactory = AttributeTupleFactory.getFactory();
        this.m_defaultAttributes = new Attributes();
    }

    public static AttributeManager getAttributeManager() {
        if (s_instance == null) {
            new AttributeManager();
        }
        return s_instance;
    }

    public void setComponentSet(ObservableSet<Component> set) {
        Iterator<ObservableSet.Listener<Component>> it = set.listenerIterator();
        while (it.hasNext()) {
            ObservableSet.Listener<Component> l = it.next();
            if (!l.getClass().getName().startsWith("cib.cad.db.att.AttributeManager$")) continue;
            return;
        }
        set.addListener(new ObservableSet.Listener<Component>(){
            private static final long serialVersionUID = 0L;

            @Override
            public void wasAdded(Component comp) {
                Attributes attr = comp.getAttributes();
                if (attr == null) {
                    comp.setAttributes(AttributeManager.this.m_defaultAttributes);
                }
            }
        });
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        s_instance = this;
    }

    protected AttributeTupleFactory getAttributeTupleFactory() {
        return this.m_attFactory;
    }

    public Attributes getDefaultAttributes() {
        return this.m_defaultAttributes;
    }

    public void setDefaultAttributes(Attributes at) {
        this.m_defaultAttributes = at;
        Iterator<Listener> it = this.m_listeners.iterator();
        while (it.hasNext()) {
            it.next().defaultAttributesChanged();
        }
    }

    public void addLineWidth(String name, double lineWidth) {
        int action = this.m_attNamespaces.addLineWidth(name, lineWidth);
        Iterator<Listener> it = this.m_listeners.iterator();
        while (it.hasNext()) {
            if (action == 1) {
                it.next().lineWidthAdded(name);
                continue;
            }
            if (action == 3) {
                it.next().lineWidthChanged(name);
                continue;
            }
            throw new InternalError();
        }
    }

    public double getLineWidth(String name) {
        return this.m_attNamespaces.getLineWidth(name);
    }

    public Set<String> getLineWidths() {
        return this.m_attNamespaces.getLineWidths();
    }

    public void removeLineWidth(String name) {
        this.m_attNamespaces.removeLineWidth(name);
        Iterator<Listener> it = this.m_listeners.iterator();
        while (it.hasNext()) {
            it.next().lineWidthRemoved(name);
        }
    }

    public boolean containsLineWidth(String name) {
        return this.m_attNamespaces.containsLineWidth(name);
    }

    public String getLocalizedLineWidthName(String name) {
        return this.m_attNamespaces.getLocalizedLineWidthName(name);
    }

    public void addLinePattern(String name, double[] linePattern) {
        if (linePattern != null) {
            if (linePattern.length == 0) {
                linePattern = null;
            } else if (linePattern.length == 1) {
                if (linePattern[0] < Geo2D.getEps()) {
                    throw new IllegalArgumentException(Messages.getString("db.att.AttributeManager.0"));
                }
                linePattern = new double[]{linePattern[0], linePattern[0]};
            } else {
                double length = 0.0;
                int i = 0;
                while (i < linePattern.length) {
                    length += linePattern[i];
                    ++i;
                }
                if (length < Geo2D.getEps()) {
                    throw new IllegalArgumentException(Messages.getString("db.att.AttributeManager.1"));
                }
            }
        }
        int action = this.m_attNamespaces.addLinePattern(name, linePattern);
        Iterator<Listener> it = this.m_listeners.iterator();
        while (it.hasNext()) {
            if (action == 1) {
                it.next().linePatternAdded(name);
                continue;
            }
            if (action == 3) {
                it.next().linePatternChanged(name);
                continue;
            }
            throw new InternalError();
        }
    }

    public double[] getLinePattern(String name) {
        return this.m_attNamespaces.getLinePattern(name);
    }

    public Set<String> getLinePatterns() {
        return this.m_attNamespaces.getLinePatterns();
    }

    public void removeLinePattern(String name) {
        this.m_attNamespaces.removeLinePattern(name);
        Iterator<Listener> it = this.m_listeners.iterator();
        while (it.hasNext()) {
            it.next().linePatternRemoved(name);
        }
    }

    public boolean containsLinePattern(String name) {
        return this.m_attNamespaces.containsLinePattern(name);
    }

    public String getLocalizedLinePatternName(String name) {
        return this.m_attNamespaces.getLocalizedLinePatternName(name);
    }

    public Stroke getModelStroke(String width, String pattern) {
        return this.m_attNamespaces.getModelStroke(width, pattern);
    }

    public double getModelTextSize(String textSize) {
        return this.m_attNamespaces.getModelTextSize(textSize);
    }

    public Paint getModelFillPaint(String paint) {
        return this.m_attNamespaces.getModelFillPaint(paint);
    }

    public void addDrawPaint(String name, Paint drawPaint) {
        int action = this.m_attNamespaces.addDrawPaint(name, drawPaint);
        Iterator<Listener> it = this.m_listeners.iterator();
        while (it.hasNext()) {
            if (action == 1) {
                it.next().drawPaintAdded(name);
                continue;
            }
            if (action == 3) {
                it.next().drawPaintChanged(name);
                continue;
            }
            throw new InternalError();
        }
    }

    public Paint getDrawPaint(String name) {
        return this.m_attNamespaces.getDrawPaint(name);
    }

    public Set<String> getDrawPaints() {
        return this.m_attNamespaces.getDrawPaints();
    }

    public void removeDrawPaint(String name) {
        this.m_attNamespaces.removeDrawPaint(name);
        Iterator<Listener> it = this.m_listeners.iterator();
        while (it.hasNext()) {
            it.next().drawPaintRemoved(name);
        }
    }

    public boolean containsDrawPaint(String name) {
        return this.m_attNamespaces.containsDrawPaint(name);
    }

    public String getLocalizedDrawPaintName(String name) {
        return this.m_attNamespaces.getLocalizedDrawPaintName(name);
    }

    public void addFillPaint(String name, Paint fillPaint) {
        int action = this.m_attNamespaces.addFillPaint(name, fillPaint);
        Iterator<Listener> it = this.m_listeners.iterator();
        while (it.hasNext()) {
            if (action == 1) {
                it.next().fillPaintAdded(name);
                continue;
            }
            if (action == 3) {
                it.next().fillPaintChanged(name);
                continue;
            }
            throw new InternalError();
        }
    }

    public Paint getFillPaint(String name) {
        return this.m_attNamespaces.getFillPaint(name);
    }

    public Set<String> getFillPaints() {
        return this.m_attNamespaces.getFillPaints();
    }

    public void removeFillPaint(String name) {
        this.m_attNamespaces.removeFillPaint(name);
        Iterator<Listener> it = this.m_listeners.iterator();
        while (it.hasNext()) {
            it.next().fillPaintRemoved(name);
        }
    }

    public boolean containsFillPaint(String name) {
        return this.m_attNamespaces.containsFillPaint(name);
    }

    public String getLocalizedFillPaintName(String name) {
        return this.m_attNamespaces.getLocalizedFillPaintName(name);
    }

    public void addFontFamily(String name, String fontFamily) {
        int action = this.m_attNamespaces.addFontFamily(name, fontFamily);
        Iterator<Listener> it = this.m_listeners.iterator();
        while (it.hasNext()) {
            if (action == 1) {
                it.next().fontFamilyAdded(name);
                continue;
            }
            if (action == 3) {
                it.next().fontFamilyChanged(name);
                continue;
            }
            throw new InternalError();
        }
    }

    public boolean fontFamilyDefined(String name) {
        return this.m_attNamespaces.fontFamilyDefined(name);
    }

    public String getFontFamily(String name) {
        return this.m_attNamespaces.getFontFamily(name);
    }

    public Set<String> getFontFamilies() {
        return this.m_attNamespaces.getFontFamilies();
    }

    public void removeFontFamily(String name) {
        this.m_attNamespaces.removeFontFamily(name);
        Iterator<Listener> it = this.m_listeners.iterator();
        while (it.hasNext()) {
            it.next().fontFamilyRemoved(name);
        }
    }

    public boolean containsFontFamily(String name) {
        return this.m_attNamespaces.containsFontFamily(name);
    }

    public String getLocalizedFontFamilyName(String name) {
        return this.m_attNamespaces.getLocalizedFontFamilyName(name);
    }

    public void addTextSize(String name, double textSize) {
        int action = this.m_attNamespaces.addTextSize(name, textSize);
        Iterator<Listener> it = this.m_listeners.iterator();
        while (it.hasNext()) {
            if (action == 1) {
                it.next().textSizeAdded(name);
                continue;
            }
            if (action == 3) {
                it.next().textSizeChanged(name);
                continue;
            }
            throw new InternalError();
        }
    }

    public double getTextSize(String name) {
        return this.m_attNamespaces.getTextSize(name);
    }

    public Set<String> getTextSizes() {
        return this.m_attNamespaces.getTextSizes();
    }

    public void removeTextSize(String name) {
        this.m_attNamespaces.removeTextSize(name);
        Iterator<Listener> it = this.m_listeners.iterator();
        while (it.hasNext()) {
            it.next().textSizeRemoved(name);
        }
    }

    public boolean containsTextSize(String name) {
        return this.m_attNamespaces.containsTextSize(name);
    }

    public String getLocalizedTextSizeName(String name) {
        return this.m_attNamespaces.getLocalizedTextSizeName(name);
    }

    public void addVisibility(String name, boolean visible) {
        int action = this.m_attNamespaces.addVisibility(name, visible);
        Iterator<Listener> it = this.m_listeners.iterator();
        while (it.hasNext()) {
            if (action == 1) {
                it.next().visibilityAdded(name);
                continue;
            }
            if (action == 3) {
                it.next().visibilityChanged(name);
                continue;
            }
            throw new InternalError();
        }
    }

    public boolean getVisibility(String name) {
        return this.m_attNamespaces.getVisibility(name);
    }

    public Set<String> getVisibilities() {
        return this.m_attNamespaces.getVisibilities();
    }

    public void removeVisibility(String name) {
        this.m_attNamespaces.removeVisibility(name);
        Iterator<Listener> it = this.m_listeners.iterator();
        while (it.hasNext()) {
            it.next().visibilityRemoved(name);
        }
    }

    public boolean containsVisibility(String name) {
        return this.m_attNamespaces.containsVisibility(name);
    }

    public String getLocalizedVisibilityName(String name) {
        return this.m_attNamespaces.getLocalizedVisibilityName(name);
    }

    public void addMutability(String name, boolean modifiable) {
        int action = this.m_attNamespaces.addMutability(name, modifiable);
        Iterator<Listener> it = this.m_listeners.iterator();
        while (it.hasNext()) {
            if (action == 1) {
                it.next().mutabilityAdded(name);
                continue;
            }
            if (action == 3) {
                it.next().mutabilityChanged(name);
                continue;
            }
            throw new InternalError();
        }
    }

    public boolean getMutability(String name) {
        return this.m_attNamespaces.getMutability(name);
    }

    public Set<String> getMutabilities() {
        return this.m_attNamespaces.getMutabilities();
    }

    public void removeMutability(String name) {
        this.m_attNamespaces.removeMutability(name);
        Iterator<Listener> it = this.m_listeners.iterator();
        while (it.hasNext()) {
            it.next().mutabilityRemoved(name);
        }
    }

    public boolean containsMutability(String name) {
        return this.m_attNamespaces.containsMutability(name);
    }

    public String getLocalizedMutabilityName(String name) {
        return this.m_attNamespaces.getLocalizedMutabilityName(name);
    }

    public String toString() {
        return String.valueOf(this.m_attNamespaces.toString()) + "\n" + Messages.getString("db.att.AttributeManager.3") + this.m_defaultAttributes + Messages.getString("db.att.AttributeManager.4");
    }

    public boolean addListener(Listener l) {
        return this.m_listeners.add(l);
    }

    public boolean removeListener(Listener l) {
        return this.m_listeners.remove(l);
    }

    public static class Listener
    implements Serializable {
        private static final long serialVersionUID = 0L;

        public void defaultAttributesChanged() {
        }

        public void lineWidthAdded(String name) {
        }

        public void lineWidthRemoved(String name) {
        }

        public void lineWidthChanged(String name) {
        }

        public void linePatternAdded(String name) {
        }

        public void linePatternRemoved(String name) {
        }

        public void linePatternChanged(String name) {
        }

        public void drawPaintAdded(String name) {
        }

        public void drawPaintRemoved(String name) {
        }

        public void drawPaintChanged(String name) {
        }

        public void fillPaintAdded(String name) {
        }

        public void fillPaintRemoved(String name) {
        }

        public void fillPaintChanged(String name) {
        }

        public void fontFamilyAdded(String name) {
        }

        public void fontFamilyRemoved(String name) {
        }

        public void fontFamilyChanged(String name) {
        }

        public void textSizeAdded(String name) {
        }

        public void textSizeRemoved(String name) {
        }

        public void textSizeChanged(String name) {
        }

        public void visibilityAdded(String name) {
        }

        public void visibilityRemoved(String name) {
        }

        public void visibilityChanged(String name) {
        }

        public void mutabilityAdded(String name) {
        }

        public void mutabilityRemoved(String name) {
        }

        public void mutabilityChanged(String name) {
        }
    }
}

