/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.db.att;

import cib.cad.db.att.AttributeManager;
import cib.cad.db.att.Attributes;
import cib.util.geo.Path2D;
import cib.util.view.FillPaint;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.Transparency;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DefaultFillPaint
implements FillPaint,
Transparency {
    private static final long serialVersionUID = 0L;
    private Color m_paint = Color.YELLOW;
    private Set<Pair> m_attributedPaths = null;
    private double m_tileWidth = 1.0;
    private double m_tileHeight = 1.0;
    private double m_paperToModel = 0.1;
    private transient AffineTransform m_m2v = null;
    private transient Paint m_texture = null;
    private boolean m_isMarked = false;
    private static final Point2D ORIGIN = new Point2D.Double(0.0, 0.0);
    private static final int MAXPIXEL = 500;
    private static final Color MAXCOLOR = new Color(180, 180, 180, 150);
    private int m_alpha = 255;

    public DefaultFillPaint(Color paint) {
        this.m_paint = paint;
        this.m_attributedPaths = new HashSet<Pair>();
    }

    public DefaultFillPaint(DefaultFillPaint dfp) {
        this.m_paint = dfp.m_paint;
        this.m_attributedPaths = dfp.m_attributedPaths;
        this.m_tileWidth = dfp.m_tileWidth;
        this.m_tileHeight = dfp.m_tileHeight;
        this.m_paperToModel = dfp.m_paperToModel;
        this.m_m2v = this.getModelToView();
        this.m_isMarked = dfp.m_isMarked;
        this.m_texture = dfp.m_texture;
        this.m_alpha = dfp.m_alpha;
    }

    public DefaultFillPaint(Color paint, double width, double height) {
        this.m_paint = paint;
        this.m_tileWidth = width;
        this.m_tileHeight = height;
        this.m_attributedPaths = new HashSet<Pair>();
    }

    public void add(Path2D path, Attributes att) {
        this.m_attributedPaths.add(new Pair(path, att));
    }

    @Override
    public void setPaperToModel(double p2m) {
        this.m_paperToModel = p2m;
    }

    @Override
    public double getPaperToModel() {
        return this.m_paperToModel;
    }

    @Override
    public void setModelToView(AffineTransform m2v) {
        this.m_m2v = m2v;
    }

    @Override
    public void setMarked(boolean marked) {
        this.m_isMarked = marked;
    }

    @Override
    public AffineTransform getModelToView() {
        if (this.m_m2v == null) {
            return new AffineTransform();
        }
        return (AffineTransform)this.m_m2v.clone();
    }

    @Override
    public void setTransparency(int alpha) {
        this.m_alpha = alpha;
    }

    private void generatePaint() {
        boolean textureError;
        Rectangle bild = new Rectangle();
        Point2D.Double ursprung = new Point2D.Double();
        this.m_m2v.transform(ORIGIN, ursprung);
        AffineTransform scaleTrf = AffineTransform.getScaleInstance(this.m_m2v.getScaleX(), this.m_m2v.getScaleY());
        Point2D.Double dim = new Point2D.Double(this.m_tileWidth, this.m_tileHeight);
        AffineTransform xform = AffineTransform.getScaleInstance(this.m_paperToModel, this.m_paperToModel);
        xform.preConcatenate(scaleTrf);
        xform.transform(dim, dim);
        double width = Math.abs(((Point2D)dim).getX());
        double height = Math.abs(((Point2D)dim).getY());
        bild.setBounds((int)Math.round(((Point2D)ursprung).getX()), (int)Math.round(((Point2D)ursprung).getY()), (int)Math.round(width), (int)Math.round(height));
        AffineTransform korr = AffineTransform.getScaleInstance(Math.abs((double)Math.round(((Point2D)dim).getX()) / ((Point2D)dim).getX()), Math.abs((double)Math.round(((Point2D)dim).getY()) / ((Point2D)dim).getY()));
        xform.concatenate(korr);
        double ty = -this.m_tileHeight;
        double tx = 0.0;
        AffineTransform model2bmp = AffineTransform.getTranslateInstance(tx, ty);
        model2bmp.preConcatenate(xform);
        boolean bl = textureError = bild.width > 500 || bild.height > 500 || bild.width < 1 || bild.height < 1;
        if (textureError) {
            this.m_texture = null;
            return;
        }
        BufferedImage bi = new BufferedImage(bild.width, bild.height, 6);
        Graphics2D big = bi.createGraphics();
        RenderingHints qualityHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        qualityHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        big.setRenderingHints(qualityHints);
        big.setTransform(model2bmp);
        if (this.m_paint != null) {
            big.setBackground(new Color(this.m_paint.getRed(), this.m_paint.getGreen(), this.m_paint.getBlue(), this.m_alpha));
        } else {
            big.setBackground(new Color(0, 0, 0, 0));
        }
        big.clearRect(-1, -1, bi.getWidth() + 1, bi.getHeight() + 1);
        Iterator<Pair> it = this.m_attributedPaths.iterator();
        while (it.hasNext()) {
            this.draw(big, it.next());
        }
        big.dispose();
        if (this.m_isMarked) {
            BufferedImage newBitmapHeight;
            int[] bandValues;
            int h;
            int w;
            int newWidth = bi.getWidth();
            int newHeight = bi.getHeight();
            if (newWidth % 4 != 0) {
                bild.width = 4 * bild.width;
                BufferedImage newBitmapWidth = new BufferedImage(newWidth *= 4, newHeight, 6);
                w = 0;
                while (w < bi.getWidth()) {
                    h = 0;
                    while (h < bi.getHeight()) {
                        bandValues = new int[4];
                        bi.getRaster().getPixel(w, h, bandValues);
                        newBitmapWidth.getRaster().setPixel(w, h, bandValues);
                        newBitmapWidth.getRaster().setPixel(w + bi.getWidth(), h, bandValues);
                        newBitmapWidth.getRaster().setPixel(w + 2 * bi.getWidth(), h, bandValues);
                        newBitmapWidth.getRaster().setPixel(w + 3 * bi.getWidth(), h, bandValues);
                        ++h;
                    }
                    ++w;
                }
                newBitmapWidth.flush();
                bi = newBitmapWidth;
                if (newHeight % 4 != 0) {
                    bild.height = 4 * bild.height;
                    newBitmapHeight = new BufferedImage(newWidth, newHeight *= 4, 6);
                    w = 0;
                    while (w < newBitmapWidth.getWidth()) {
                        h = 0;
                        while (h < newBitmapWidth.getHeight()) {
                            bandValues = new int[4];
                            newBitmapWidth.getRaster().getPixel(w, h, bandValues);
                            newBitmapHeight.getRaster().setPixel(w, h, bandValues);
                            newBitmapHeight.getRaster().setPixel(w, h + newBitmapWidth.getHeight(), bandValues);
                            newBitmapHeight.getRaster().setPixel(w, h + 2 * newBitmapWidth.getHeight(), bandValues);
                            newBitmapHeight.getRaster().setPixel(w, h + 3 * newBitmapWidth.getHeight(), bandValues);
                            ++h;
                        }
                        ++w;
                    }
                    newBitmapHeight.flush();
                    bi = newBitmapHeight;
                }
            } else if (newHeight % 4 != 0) {
                bild.height = 4 * bild.height;
                newBitmapHeight = new BufferedImage(newWidth, newHeight *= 4, 6);
                w = 0;
                while (w < bi.getWidth()) {
                    h = 0;
                    while (h < bi.getHeight()) {
                        bandValues = new int[4];
                        bi.getRaster().getPixel(w, h, bandValues);
                        newBitmapHeight.getRaster().setPixel(w, h, bandValues);
                        newBitmapHeight.getRaster().setPixel(w, h + bi.getHeight(), bandValues);
                        newBitmapHeight.getRaster().setPixel(w, h + 2 * bi.getHeight(), bandValues);
                        newBitmapHeight.getRaster().setPixel(w, h + 3 * bi.getHeight(), bandValues);
                        ++h;
                    }
                    ++w;
                }
                newBitmapHeight.flush();
                bi = newBitmapHeight;
            }
            int[] mask = new int[]{255, 0, 0, 0};
            WritableRaster wr = bi.getRaster();
            int w2 = 2;
            while (w2 < wr.getWidth()) {
                int h2 = 2;
                while (h2 < wr.getHeight()) {
                    wr.setPixel(w2, h2, mask);
                    wr.setPixel(w2 + 1, h2, mask);
                    wr.setPixel(w2, h2 + 1, mask);
                    wr.setPixel(w2 + 1, h2 + 1, mask);
                    h2 += 4;
                }
                w2 += 4;
            }
        }
        bi.flush();
        this.m_texture = new TexturePaint(bi, bild);
    }

    private void draw(Graphics2D g, Pair pair) {
        AttributeManager ns = AttributeManager.getAttributeManager();
        Shape path = pair.m_path.getShape();
        Paint draw = ns.getDrawPaint(pair.m_att.getDrawPaint());
        Paint fill = ns.getFillPaint(pair.m_att.getFillPaint());
        float lw = (float)ns.getLineWidth(pair.m_att.getLineWidth());
        float[] lp = null;
        double[] lp_d = ns.getLinePattern(pair.m_att.getLinePattern());
        if (lp_d != null) {
            int l = lp_d.length;
            lp = new float[l];
            int i = 0;
            while (i < l) {
                lp[i] = (float)lp_d[i];
                ++i;
            }
        }
        BasicStroke stroke = new BasicStroke(lw, 1, 1, 0.0f, lp, 0.0f);
        if (fill != null) {
            g.setPaint(this.setAlpha(fill));
            g.fill(path);
        }
        g.setStroke(stroke);
        g.setPaint(this.setAlpha(draw));
        g.draw(path);
    }

    private Paint setAlpha(Paint paint) {
        if (paint instanceof Color) {
            Color c = (Color)paint;
            return new Color(c.getRed(), c.getGreen(), c.getBlue(), this.m_alpha);
        }
        return paint;
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        Paint temp;
        if (this.m_attributedPaths.isEmpty() || this.m_tileWidth == 0.0 || this.m_tileHeight == 0.0 || this.m_m2v == null) {
            temp = this.m_paint == null ? new Color(0, 0, 0, 0) : this.m_paint;
        } else {
            this.generatePaint();
            temp = this.m_texture == null ? MAXCOLOR : this.m_texture;
        }
        if (hints == null) {
            hints = new RenderingHints(null);
        }
        return temp.createContext(cm, deviceBounds, userBounds, xform, hints);
    }

    @Override
    public int getTransparency() {
        return 3;
    }

    @Override
    public Object clone() {
        return new DefaultFillPaint(this);
    }

    @Override
    public Color getReplacementColor() {
        boolean textureError;
        Rectangle bild = new Rectangle();
        Point2D.Double ursprung = new Point2D.Double();
        this.m_m2v.transform(ORIGIN, ursprung);
        AffineTransform scaleTrf = AffineTransform.getScaleInstance(this.m_m2v.getScaleX(), this.m_m2v.getScaleY());
        Point2D.Double dim = new Point2D.Double(this.m_tileWidth, this.m_tileHeight);
        AffineTransform xform = AffineTransform.getScaleInstance(this.m_paperToModel, this.m_paperToModel);
        xform.preConcatenate(scaleTrf);
        xform.transform(dim, dim);
        double width = Math.abs(((Point2D)dim).getX());
        double height = Math.abs(((Point2D)dim).getY());
        bild.setBounds((int)Math.round(((Point2D)ursprung).getX()), (int)Math.round(((Point2D)ursprung).getY()), (int)Math.round(width), (int)Math.round(height));
        boolean bl = textureError = bild.width > 500 || bild.height > 500 || bild.width < 1 || bild.height < 1;
        if (textureError) {
            this.m_texture = null;
            return MAXCOLOR;
        }
        return null;
    }

    private class Pair
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private Path2D m_path = null;
        private Attributes m_att = null;

        public Pair(Path2D path, Attributes att) {
            this.m_path = path;
            this.m_att = att;
        }
    }
}

