/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.db.comp;

import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentAdapter;
import cib.cad.db.comp.CtrlSegments;
import cib.cad.db.feature.AreaFeature;
import cib.cad.db.feature.DistanceFeature;
import cib.cad.db.feature.Feature;
import cib.util.AttributedShape;
import cib.util.CoordSpace;
import cib.util.coll.NamedListIterator;
import cib.util.coll.NamedListIteratorAdapter;
import cib.util.geo.Geo2D;
import cib.util.geo.Path2D;
import cib.util.geo.Vector2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ComponentPath2D
extends ComponentAdapter
implements CtrlSegments {
    private static final long serialVersionUID = 0L;
    private Path2D m_path = null;
    private transient Map<Integer, Point2D> t_locs = new HashMap<Integer, Point2D>();
    private static final String[] FEATURE_NAMES = new String[]{"GEOMETRY.LENGTH", "GEOMETRY.AREA"};

    public ComponentPath2D() {
        this.m_path = new Path2D();
        this._setPathEps();
    }

    public ComponentPath2D(Path2D path) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        path.transformBy(cs.getUserToWorldTransform());
        this.m_path = path;
        this._setPathEps();
    }

    private void _setPathEps() {
        CoordSpace cs = CoordSpace.getCoordSpace();
        double eps = Geo2D.getEps() / cs.getNaturalUnitsPerWorldUnit();
        this.m_path.setEps(eps);
    }

    public void reset(Point2D p) {
        this.reset(p.getX(), p.getY());
    }

    public void reset(double x, double y) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform u2w = cs.getUserToWorldTransform();
        Point2D.Double p = new Point2D.Double(x, y);
        Point2D.Double pt = new Point2D.Double();
        u2w.transform(p, pt);
        this.m_path.reset(((Point2D)pt).getX(), ((Point2D)pt).getY());
        this._notifyWasChanged();
    }

    public boolean isEmpty() {
        return this.m_path.getVertexCount() <= 1;
    }

    public Path2D getPath() {
        CoordSpace cs = CoordSpace.getCoordSpace();
        Path2D path = (Path2D)this.m_path.clone();
        path.transformBy(cs.getWorldToUserTransform());
        return path;
    }

    public void moveTo(double x, double y) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform u2w = cs.getUserToWorldTransform();
        Point2D.Double p = new Point2D.Double(x, y);
        Point2D.Double pt = new Point2D.Double();
        u2w.transform(p, pt);
        this.m_path.moveTo(pt);
        this._notifyWasChanged();
    }

    public int lineTo(double x, double y) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform u2w = cs.getUserToWorldTransform();
        Point2D.Double p = new Point2D.Double(x, y);
        Point2D.Double pt = new Point2D.Double();
        u2w.transform(p, pt);
        int segName = this.m_path.lineTo(pt);
        this._notifyWasChanged();
        return segName;
    }

    public int quadTo(double x1, double y1, double x2, double y2) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform u2w = cs.getUserToWorldTransform();
        Point2D.Double p1 = new Point2D.Double(x1, y1);
        Point2D.Double p2 = new Point2D.Double(x2, y2);
        Point2D.Double p1t = new Point2D.Double();
        Point2D.Double p2t = new Point2D.Double();
        u2w.transform(p1, p1t);
        u2w.transform(p2, p2t);
        int segName = this.m_path.quadTo(p1t, p2t);
        this._notifyWasChanged();
        return segName;
    }

    public int cubicTo(double x1, double y1, double x2, double y2, double x3, double y3) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform u2w = cs.getUserToWorldTransform();
        Point2D.Double p1 = new Point2D.Double(x1, y1);
        Point2D.Double p2 = new Point2D.Double(x2, y2);
        Point2D.Double p3 = new Point2D.Double(x3, y3);
        Point2D.Double p1t = new Point2D.Double();
        Point2D.Double p2t = new Point2D.Double();
        Point2D.Double p3t = new Point2D.Double();
        u2w.transform(p1, p1t);
        u2w.transform(p2, p2t);
        u2w.transform(p3, p3t);
        int segName = this.m_path.cubicTo(p1t, p2t, p3t);
        this._notifyWasChanged();
        return segName;
    }

    public int arcTo(double ax, double ay, double ex, double ey) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform u2w = cs.getUserToWorldTransform();
        Point2D.Double ap = new Point2D.Double(ax, ay);
        Point2D.Double apt = new Point2D.Double();
        u2w.transform(ap, apt);
        Point2D.Double ep = new Point2D.Double(ex, ey);
        Point2D.Double ept = new Point2D.Double();
        u2w.transform(ep, ept);
        int segName = this.m_path.arcTo(apt, ept);
        this._notifyWasChanged();
        return segName;
    }

    public void close() {
        this.m_path.close();
        this._notifyWasChanged();
    }

    public void setAutoCleaning(boolean on) {
        this.m_path.setAutoCleaning(on);
    }

    public Point2D getStartVertexLocation() {
        if (this.m_path.getVertexCount() == 0) {
            return null;
        }
        CoordSpace cs = CoordSpace.getCoordSpace();
        int name = this.m_path.getVertexName(0);
        Point2D p = this.m_path.getVertexLocation(name, new Point2D.Double());
        AffineTransform w2u = cs.getWorldToUserTransform();
        return w2u.transform(p, p);
    }

    public Point2D getEndVertexLocation() {
        if (this.m_path.getVertexCount() == 0) {
            return null;
        }
        CoordSpace cs = CoordSpace.getCoordSpace();
        int name = this.m_path.getVertexName(this.m_path.getVertexCount() - 1);
        Point2D p = this.m_path.getVertexLocation(name, new Point2D.Double());
        AffineTransform w2u = cs.getWorldToUserTransform();
        return w2u.transform(p, p);
    }

    public void removeVertex(int name) {
        this.m_path.removeVertex(name);
        this._notifyWasChanged();
    }

    private AttributedShape _getShape() {
        this._setPathEps();
        CoordSpace cs = CoordSpace.getCoordSpace();
        Shape s = cs.getWorldToUserTransform().createTransformedShape(this.m_path.getShape());
        AttributedShape as = this._attributeShape(new AttributedShape(s));
        return as;
    }

    public int splitSegment(int name) {
        int newSegName = this.m_path.splitSegment(name);
        this._notifyWasChanged();
        return newSegName;
    }

    public void setSegment(int name, int type, double[] crds) {
        double[] wcrds = null;
        switch (type) {
            case 5: {
                wcrds = new double[]{};
                break;
            }
            case 0: 
            case 1: {
                wcrds = new double[4];
                break;
            }
            case 2: 
            case 4: {
                wcrds = new double[6];
                break;
            }
            case 3: {
                wcrds = new double[8];
            }
        }
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform u2w = cs.getUserToWorldTransform();
        u2w.transform(crds, 0, wcrds, 0, wcrds.length / 2);
        this.m_path.setSegment(name, type, wcrds);
        this._notifyWasChanged();
    }

    public int getSegment(int name, double[] crds) {
        double[] wcrds = new double[8];
        int type = this.m_path.getSegment(name, wcrds);
        int dim = 0;
        switch (type) {
            case 5: {
                dim = 0;
                break;
            }
            case 0: 
            case 1: {
                dim = 4;
                break;
            }
            case 2: 
            case 4: {
                dim = 6;
                break;
            }
            case 3: {
                dim = 8;
            }
        }
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform w2u = cs.getWorldToUserTransform();
        w2u.transform(wcrds, 0, crds, 0, dim / 2);
        return type;
    }

    public void removeSegment(int name) {
        this.m_path.removeSegment(name);
        this._notifyWasChanged();
    }

    @Override
    public Object clone() {
        ComponentPath2D comp = (ComponentPath2D)super.clone();
        comp.m_path = (Path2D)this.m_path.clone();
        return comp;
    }

    @Override
    public void assign(Component rhs) {
        ComponentPath2D rhsComp = (ComponentPath2D)rhs;
        this.m_path = (Path2D)rhsComp.m_path.clone();
        super.assign(rhs);
    }

    @Override
    public NamedListIterator<Point2D> controlPointIterator() {
        return new _NamedListIteratorAdapter();
    }

    @Override
    public int getCtrlType(int name) {
        if (this.m_path.containsVertex(name)) {
            return 2;
        }
        if (this.m_path.containsSegment(name)) {
            double[] crds = new double[8];
            int segType = this.m_path.getSegment(name, crds);
            switch (segType) {
                case 0: {
                    return 4;
                }
                case 1: {
                    return 8;
                }
                case 2: {
                    return 16;
                }
                case 3: {
                    return 32;
                }
                case 4: {
                    return 64;
                }
                case 5: {
                    return 128;
                }
            }
            throw new IllegalArgumentException();
        }
        return 1;
    }

    @Override
    public boolean hasControlPoint(int name) {
        return this.m_path.containsVertex(name) || this.m_path.containsSegment(name) || this.m_path.containsSegmentPoint(name);
    }

    @Override
    public Point2D getControlPoint(int name) throws IllegalArgumentException {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform w2u = cs.getWorldToUserTransform();
        if (this.m_path.containsVertex(name)) {
            Point2D p = this.m_path.getVertexLocation(name, new Point2D.Double());
            return w2u.transform(p, p);
        }
        if (this.m_path.containsSegment(name)) {
            Point2D p = this.m_path.getSegmentRepresentativeLocation(name, new Point2D.Double());
            return w2u.transform(p, p);
        }
        if (this.m_path.containsSegmentPoint(name)) {
            Point2D p = this.m_path.getSegmentPointLocation(name, new Point2D.Double());
            return w2u.transform(p, p);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getVertexSegmentCount(int vtxName) {
        int n = 0;
        if (this.m_path.containsVertex(vtxName)) {
            if (-1 != this.m_path.getPreviousSegmentName(vtxName)) {
                ++n;
            }
            if (-1 != this.m_path.getNextSegmentName(vtxName)) {
                ++n;
            }
        }
        return n;
    }

    @Override
    public int getVertexSegmentAt(int vtxName, int iSegment) {
        int name0 = this.m_path.getPreviousSegmentName(vtxName);
        int name1 = this.m_path.getNextSegmentName(vtxName);
        if (iSegment == 0) {
            if (name0 != -1) {
                return name0;
            }
            if (name1 != -1) {
                return name1;
            }
        } else if (iSegment == 1 && name0 != -1 && name1 != -1) {
            return name1;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getSegmentVertex1(int segName) {
        if (!this.m_path.containsSegment(segName)) {
            throw new IllegalArgumentException();
        }
        return this.m_path.getSegmentStartVertex(segName);
    }

    @Override
    public int getSegmentVertex2(int segName) {
        if (!this.m_path.containsSegment(segName)) {
            throw new IllegalArgumentException();
        }
        return this.m_path.getSegmentEndVertex(segName);
    }

    @Override
    public int getSegmentPointCount(int segName) {
        if (!this.m_path.containsSegment(segName)) {
            throw new IllegalArgumentException();
        }
        return this.getControlPointChildrenCount(segName) - 2;
    }

    @Override
    public int getSegmentPointAt(int segName, int iPoint) {
        int nPoints = this.getSegmentPointCount(segName);
        if (iPoint < 0 || iPoint >= nPoints) {
            throw new IllegalArgumentException();
        }
        return this.getControlPointChild(segName, iPoint);
    }

    @Override
    public int getSegmentCrds(int segName, double[] crds) {
        if (!this.m_path.containsSegment(segName)) {
            throw new IllegalArgumentException();
        }
        switch (this.getSegment(segName, crds)) {
            case 0: {
                return 4;
            }
            case 1: {
                return 8;
            }
            case 2: {
                return 16;
            }
            case 3: {
                return 32;
            }
            case 4: {
                return 64;
            }
            case 5: {
                return 128;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void setSegmentCrds(int segName, double[] crds) throws UnsupportedOperationException {
        int segType;
        if (!this.m_path.containsSegment(segName)) {
            throw new IllegalArgumentException();
        }
        switch (this.getCtrlType(segName)) {
            case 4: {
                segType = 0;
                break;
            }
            case 8: {
                segType = 1;
                break;
            }
            case 16: {
                segType = 2;
                break;
            }
            case 32: {
                segType = 3;
                break;
            }
            case 64: {
                segType = 4;
                break;
            }
            case 128: {
                segType = 5;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        this.setSegment(segName, segType, crds);
    }

    @Override
    public void setControlPointStarts() {
        if (this.t_locs == null) {
            this.t_locs = new HashMap<Integer, Point2D>();
        } else {
            this.t_locs.clear();
        }
    }

    @Override
    public void setControlPoint(Point2D p, int name) throws UnsupportedOperationException {
        this.t_locs.put(name, p);
    }

    @Override
    public void setControlPointEnds() {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform w2u = cs.getWorldToUserTransform();
        AffineTransform u2w = cs.getUserToWorldTransform();
        HashMap<Integer, Point2D> additionalPointsToSet = new HashMap<Integer, Point2D>();
        Set<Integer> names = this.t_locs.keySet();
        for (int name : names) {
            if (!this.m_path.containsSegment(name)) continue;
            Point2D.Double ctrOld = new Point2D.Double();
            this.m_path.getSegmentRepresentativeLocation(name, ctrOld);
            w2u.transform(ctrOld, ctrOld);
            Point2D ctrNew = this.t_locs.get(name);
            double dx = ctrNew.getX() - ((Point2D)ctrOld).getX();
            double dy = ctrNew.getY() - ((Point2D)ctrOld).getY();
            int spName = this.m_path.getSegmentStartVertex(name);
            Point2D sp = this.m_path.getVertexLocation(spName, new Point2D.Double());
            w2u.transform(sp, sp);
            sp.setLocation(sp.getX() + dx, sp.getY() + dy);
            additionalPointsToSet.put(spName, sp);
            int nPoints = this.m_path.getSegmentPointCount(name);
            int i = 0;
            while (i < nPoints) {
                int pntName = this.m_path.getSegmentPointName(name, i);
                Point2D pnt = this.m_path.getSegmentPointLocation(pntName, new Point2D.Double());
                w2u.transform(pnt, pnt);
                pnt.setLocation(pnt.getX() + dx, pnt.getY() + dy);
                additionalPointsToSet.put(pntName, pnt);
                ++i;
            }
            int epName = this.m_path.getSegmentEndVertex(name);
            Point2D ep = this.m_path.getVertexLocation(epName, new Point2D.Double());
            w2u.transform(ep, ep);
            ep.setLocation(ep.getX() + dx, ep.getY() + dy);
            additionalPointsToSet.put(epName, ep);
        }
        this.t_locs.putAll(additionalPointsToSet);
        for (int name : names) {
            Point2D p = this.t_locs.get(name);
            Point2D.Double pt = new Point2D.Double();
            u2w.transform(p, pt);
            if (this.m_path.containsVertex(name)) {
                this.m_path.setVertexLocation(name, pt);
                this._notifyWasChanged();
                continue;
            }
            if (this.m_path.containsSegment(name)) continue;
            if (this.m_path.containsSegmentPoint(name)) {
                this.m_path.setSegmentPointLocation(name, pt);
                this._notifyWasChanged();
                continue;
            }
            throw new IllegalArgumentException();
        }
    }

    @Override
    public int getControlPointChildrenCount(int name) {
        if (!this.m_path.containsSegment(name)) {
            return 0;
        }
        double[] crds = new double[8];
        int segType = this.m_path.getSegment(name, crds);
        if (segType == 5) {
            return this.m_path.getSegmentPointCount(name);
        }
        return this.m_path.getSegmentPointCount(name) + 2;
    }

    @Override
    public int getControlPointChild(int name, int iChild) {
        int nSegmentPoints = this.m_path.getSegmentPointCount(name);
        if (iChild < nSegmentPoints) {
            return this.m_path.getSegmentPointName(name, iChild);
        }
        if (iChild == nSegmentPoints) {
            return this.m_path.getSegmentStartVertex(name);
        }
        if (iChild == nSegmentPoints + 1) {
            return this.m_path.getSegmentEndVertex(name);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void removeControlPoint(int name) throws UnsupportedOperationException {
        if (this.m_path.containsVertex(name)) {
            this.m_path.removeVertex(name);
        } else if (this.m_path.containsSegment(name)) {
            this.m_path.removeSegment(name);
        } else {
            return;
        }
        this._notifyWasChanged();
    }

    @Override
    public void setCtrlType(int newType, int name) throws UnsupportedOperationException {
        if (!this.m_path.containsSegment(name)) {
            throw new IllegalArgumentException();
        }
        double[] crds = new double[8];
        int oldType = this.getSegment(name, crds);
        int segType = -1;
        block0 : switch (oldType) {
            case 1: {
                Vector2D axial = new Vector2D(crds[0], crds[1], crds[2], crds[3]);
                Vector2D left = new Vector2D(axial).left();
                switch (newType) {
                    case 8: {
                        return;
                    }
                    case 16: {
                        segType = 2;
                        crds[4] = crds[2];
                        crds[5] = crds[3];
                        crds[2] = crds[0] + 0.5 * axial.x + 0.5 * left.x;
                        crds[3] = crds[1] + 0.5 * axial.y + 0.5 * left.y;
                        break block0;
                    }
                    case 32: {
                        segType = 3;
                        crds[6] = crds[2];
                        crds[7] = crds[3];
                        crds[2] = crds[0] + 0.25 * axial.x + 0.25 * left.x;
                        crds[3] = crds[1] + 0.25 * axial.y + 0.25 * left.y;
                        crds[4] = crds[0] + 0.75 * axial.x - 0.25 * left.x;
                        crds[5] = crds[1] + 0.75 * axial.y - 0.25 * left.y;
                        break block0;
                    }
                    case 64: {
                        segType = 4;
                        crds[4] = crds[2];
                        crds[5] = crds[3];
                        crds[2] = crds[0] + 0.25 * axial.x + 0.25 * left.x;
                        crds[3] = crds[1] + 0.25 * axial.y + 0.25 * left.y;
                        break block0;
                    }
                }
                throw new IllegalArgumentException();
            }
            case 2: {
                Vector2D axial = new Vector2D(crds[0], crds[1], crds[4], crds[5]);
                Vector2D lateral = new Vector2D(axial).right();
                if (lateral.length() > Geo2D.getEps()) {
                    double dist = Line2D.ptLineDist(crds[0], crds[1], crds[4], crds[5], crds[2], crds[3]);
                    int relPos = Line2D.relativeCCW(crds[0], crds[1], crds[4], crds[5], crds[2], crds[3]);
                    lateral.normalize().scaleBy(dist * (double)relPos);
                }
                switch (newType) {
                    case 8: {
                        segType = 1;
                        crds[2] = crds[4];
                        crds[3] = crds[5];
                        break block0;
                    }
                    case 16: {
                        return;
                    }
                    case 32: {
                        segType = 3;
                        crds[6] = crds[4];
                        crds[7] = crds[5];
                        crds[2] = crds[0] + 0.25 * axial.x + lateral.x;
                        crds[3] = crds[1] + 0.25 * axial.y + lateral.y;
                        crds[4] = crds[0] + 0.75 * axial.x + lateral.x;
                        crds[5] = crds[1] + 0.75 * axial.y + lateral.y;
                        break block0;
                    }
                    case 64: {
                        segType = 4;
                        crds[2] = crds[0] + 0.5 * axial.x + 0.5 * lateral.x;
                        crds[3] = crds[1] + 0.5 * axial.y + 0.5 * lateral.y;
                        break block0;
                    }
                }
                throw new IllegalArgumentException();
            }
            case 3: {
                Vector2D axial = new Vector2D(crds[0], crds[1], crds[6], crds[7]);
                Vector2D lateral = new Vector2D(axial).right();
                if (lateral.length() > Geo2D.getEps()) {
                    double dst1 = Line2D.ptLineDist(crds[0], crds[1], crds[6], crds[7], crds[2], crds[3]);
                    int relPos1 = Line2D.relativeCCW(crds[0], crds[1], crds[6], crds[7], crds[2], crds[3]);
                    double dst2 = Line2D.ptLineDist(crds[0], crds[1], crds[6], crds[7], crds[4], crds[5]);
                    int relPos2 = Line2D.relativeCCW(crds[0], crds[1], crds[6], crds[7], crds[4], crds[5]);
                    double dist = dst1;
                    double relPos = relPos1;
                    if (dst1 < dst2) {
                        dist = dst2;
                        relPos = relPos2;
                    }
                    lateral.normalize().scaleBy(dist * relPos);
                }
                switch (newType) {
                    case 8: {
                        segType = 1;
                        crds[2] = crds[6];
                        crds[3] = crds[7];
                        break block0;
                    }
                    case 16: {
                        segType = 2;
                        crds[4] = crds[6];
                        crds[5] = crds[7];
                        crds[2] = crds[0] + 0.5 * axial.x + lateral.x;
                        crds[3] = crds[1] + 0.5 * axial.y + lateral.y;
                        break block0;
                    }
                    case 32: {
                        return;
                    }
                    case 64: {
                        segType = 4;
                        crds[4] = crds[6];
                        crds[5] = crds[7];
                        crds[2] = crds[0] + 0.5 * axial.x + 0.5 * lateral.x;
                        crds[3] = crds[1] + 0.5 * axial.y + 0.5 * lateral.y;
                        break block0;
                    }
                }
                throw new IllegalArgumentException();
            }
            case 4: {
                Vector2D axial = new Vector2D(crds[0], crds[1], crds[4], crds[5]);
                Vector2D lateral = new Vector2D(axial).right();
                if (lateral.length() > Geo2D.getEps()) {
                    double dist = Line2D.ptLineDist(crds[0], crds[1], crds[4], crds[5], crds[2], crds[3]);
                    int relPos = Line2D.relativeCCW(crds[0], crds[1], crds[4], crds[5], crds[2], crds[3]);
                    lateral.normalize().scaleBy(dist * (double)relPos);
                }
                switch (newType) {
                    case 8: {
                        segType = 1;
                        crds[2] = crds[4];
                        crds[3] = crds[5];
                        break block0;
                    }
                    case 16: {
                        segType = 2;
                        crds[2] = crds[0] + 0.5 * axial.x + 2.0 * lateral.x;
                        crds[3] = crds[1] + 0.5 * axial.y + 2.0 * lateral.y;
                        break block0;
                    }
                    case 32: {
                        segType = 3;
                        crds[6] = crds[4];
                        crds[7] = crds[5];
                        crds[2] = crds[0] + 0.25 * axial.x + 2.0 * lateral.x;
                        crds[3] = crds[1] + 0.25 * axial.y + 2.0 * lateral.y;
                        crds[4] = crds[0] + 0.75 * axial.x + 2.0 * lateral.x;
                        crds[5] = crds[1] + 0.75 * axial.y + 2.0 * lateral.y;
                        break block0;
                    }
                    case 64: {
                        return;
                    }
                }
                throw new IllegalArgumentException();
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.setSegment(name, segType, crds);
    }

    @Override
    public int split(int name) throws IllegalArgumentException {
        int newSegName = this.m_path.splitSegment(name);
        this._notifyWasChanged();
        return newSegName;
    }

    @Override
    public NamedListIterator<AttributedShape> shapeIterator() {
        return NamedListIteratorAdapter.singletonNamedListIterator(this._getShape());
    }

    @Override
    public void transformBy(AffineTransform mat) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform trf = cs.getWorldToUserTransform();
        trf.preConcatenate(mat);
        trf.preConcatenate(cs.getUserToWorldTransform());
        this.m_path.transformBy(trf);
        this._notifyWasChanged();
    }

    @Override
    public boolean hasFeature(String name) {
        int i = 0;
        while (i < FEATURE_NAMES.length) {
            if (name.equals(FEATURE_NAMES[i])) {
                return true;
            }
            ++i;
        }
        return super.hasFeature(name);
    }

    @Override
    public Feature getFeature(String name) {
        if (name.equals(FEATURE_NAMES[0])) {
            CoordSpace cs = CoordSpace.getCoordSpace();
            AffineTransform w2u = cs.getWorldToUserTransform();
            double scale = w2u.getScaleX();
            DistanceFeature f = new DistanceFeature(FEATURE_NAMES[0], this.m_path.length() * scale);
            f.setChangeable(false);
            return f;
        }
        if (name.equals(FEATURE_NAMES[1])) {
            CoordSpace cs = CoordSpace.getCoordSpace();
            AffineTransform w2u = cs.getWorldToUserTransform();
            double scale = w2u.getScaleX();
            double area = this.m_path.area() * scale * scale;
            AreaFeature f = new AreaFeature(FEATURE_NAMES[1], area);
            f.setChangeable(false);
            return f;
        }
        return super.getFeature(name);
    }

    @Override
    public void setFeature(Feature feature) {
        if (feature.getName().equals(FEATURE_NAMES[0])) {
            throw new UnsupportedOperationException();
        }
        if (feature.getName().equals(FEATURE_NAMES[1])) {
            throw new UnsupportedOperationException();
        }
        super.setFeature(feature);
    }

    @Override
    public Iterator<Feature> featureIterator() {
        final Iterator<Feature> itThis = new Iterator<Feature>(){
            private int m_index = 0;

            @Override
            public boolean hasNext() {
                return this.m_index < FEATURE_NAMES.length;
            }

            @Override
            public Feature next() {
                if (this.hasNext()) {
                    return ComponentPath2D.this.getFeature(FEATURE_NAMES[this.m_index++]);
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        final Iterator<Feature> itBase = super.featureIterator();
        return new Iterator<Feature>(){

            @Override
            public boolean hasNext() {
                return itBase.hasNext() | itThis.hasNext();
            }

            @Override
            public Feature next() {
                if (itBase.hasNext()) {
                    return (Feature)itBase.next();
                }
                if (itThis.hasNext()) {
                    return (Feature)itThis.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public class _NamedListIteratorAdapter
    extends NamedListIteratorAdapter<Point2D> {
        private List<Integer> m_names = new ArrayList<Integer>();

        public _NamedListIteratorAdapter() {
            int nVertex = ComponentPath2D.this.m_path.getVertexCount();
            int i = 0;
            while (i < nVertex) {
                this.m_names.add(ComponentPath2D.this.m_path.getVertexName(i));
                ++i;
            }
            int nSegments = ComponentPath2D.this.m_path.getSegmentCount();
            int i2 = 0;
            while (i2 < nSegments) {
                int segmentName = ComponentPath2D.this.m_path.getSegmentName(i2);
                this.m_names.add(segmentName);
                int nSegmentPoints = ComponentPath2D.this.m_path.getSegmentPointCount(segmentName);
                int j = 0;
                while (j < nSegmentPoints) {
                    this.m_names.add(ComponentPath2D.this.m_path.getSegmentPointName(segmentName, j));
                    ++j;
                }
                ++i2;
            }
        }

        @Override
        protected int _name(int index) {
            return this.m_names.get(index);
        }

        @Override
        protected int _size() {
            return this.m_names.size();
        }

        @Override
        protected Point2D _get(int index) {
            return ComponentPath2D.this.getControlPoint(this._name(index));
        }

        @Override
        protected void _set(int index, Point2D p) {
            ComponentPath2D.this.setControlPoint(p, this._name(index));
        }

        @Override
        protected void _remove(int index) {
            if (index >= 0 && index < ComponentPath2D.this.m_path.getVertexCount()) {
                ComponentPath2D.this.m_path.removeVertex(this._name(index));
                ComponentPath2D.this._notifyWasChanged();
            }
        }
    }
}

