/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.db.layer;

import cib.cad.db.Database;
import cib.cad.db.att.AttributeManager;
import cib.cad.db.att.Attributes;
import cib.cad.db.layer.LayerManager;
import cib.cad.db.layer.LayerSet;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.cmd.CmdAbortedException;
import cib.util.cmd.CmdAdapter;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;

public class DumpLayers
extends CmdAdapter {
    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        LayerSet layerSet = db.getLayerSet();
        LayerManager lm = LayerManager.getLayerManager();
        AttributeManager am = AttributeManager.getAttributeManager();
        String DEFAULT = "NULL_LAYER";
        String LOC_DEFAULT = lm.getLocalizedLayerName("NULL_LAYER");
        if (layerSet.size() == 0) {
            krnl.readOK(Messages.getString("db.layer.DumpLayers.0"), Messages.getString("db.layer.DumpLayers.1"), Messages.getString("db.layer.DumpLayers.2"), 6);
            return;
        }
        Set<String> names = lm.getLayers();
        HashMap<String, String> locNameMap = new HashMap<String, String>();
        for (String name : names) {
            if (name.equals("NULL_LAYER")) continue;
            locNameMap.put(lm.getLocalizedLayerName(name), name);
        }
        ArrayList locNameList = new ArrayList(locNameMap.keySet());
        Collections.sort(locNameList, Collator.getInstance());
        locNameList.add(0, LOC_DEFAULT);
        locNameMap.put(LOC_DEFAULT, "NULL_LAYER");
        int i = 1;
        String status = "";
        for (String locName : locNameList) {
            status = String.valueOf(status) + "\n" + i++ + ".\t" + locName;
            String name = (String)locNameMap.get(locName);
            Attributes attr = lm.getLayer(name).getAttributes();
            status = String.valueOf(status) + " <" + am.getLocalizedLineWidthName(attr.getLineWidth());
            status = String.valueOf(status) + ", " + am.getLocalizedLinePatternName(attr.getLinePattern());
            status = String.valueOf(status) + ", " + am.getLocalizedDrawPaintName(attr.getDrawPaint());
            status = String.valueOf(status) + ", " + am.getLocalizedFillPaintName(attr.getFillPaint());
            status = String.valueOf(status) + ", " + am.getLocalizedFontFamilyName(attr.getFontFamily());
            status = String.valueOf(status) + ", " + am.getLocalizedTextSizeName(attr.getTextSize());
            status = String.valueOf(status) + ", " + am.getLocalizedVisibilityName(attr.getVisibility());
            status = String.valueOf(status) + ">";
        }
        status = String.valueOf(status) + "\n\n";
        String name = lm.getDefaultLayer();
        String locName = lm.getLocalizedLayerName(name);
        status = String.valueOf(status) + layerSet.size() + " " + Messages.getString("db.layer.DumpLayers.11") + " " + Messages.getString("db.layer.DumpLayers.13") + " <" + locName + ">.\n";
        krnl.readOK(Messages.getString("db.layer.DumpLayers.15"), Messages.getString("db.layer.DumpLayers.16"), status, 6);
    }
}

