/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.db.layer;

import cib.cad.db.Database;
import cib.cad.db.att.AttributeManager;
import cib.cad.db.att.Attributes;
import cib.cad.db.layer.Layer;
import cib.cad.db.layer.LayerSet;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.cad.view.BasicUserForm;
import cib.util.NameSpace;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;

public class ModDefaultLayer
implements Cmd {
    private String m_toString = null;
    private Layer m_svLayer = null;
    private String m_svName = null;
    private Attributes m_svDefAttributes = null;
    private static final String LAYER_NAME = Messages.getString("db.layer.ModDefaultLayer.0");
    private static final String LINE_WIDTH = Messages.getString("db.layer.ModDefaultLayer.1");
    private static final String LINE_PATTERN = Messages.getString("db.layer.ModDefaultLayer.2");
    private static final String DRAW_PAINT = Messages.getString("db.layer.ModDefaultLayer.3");
    private static final String FILL_PAINT = Messages.getString("db.layer.ModDefaultLayer.4");
    private static final String TEXT_FONT = Messages.getString("db.layer.ModDefaultLayer.5");
    private static final String TEXT_SIZE = Messages.getString("db.layer.ModDefaultLayer.6");
    private static final String VISIBILITY = Messages.getString("db.layer.ModDefaultLayer.7");
    private static final String DEFAULT_ATTRIBUTES = Messages.getString("db.layer.ModDefaultLayer.9");

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        NameSpace ns = db.getNameSpace();
        LayerSet ls = db.getLayerSet();
        AttributeManager am = db.getAttributeManager();
        Layer defaultLayer = ls.getDefaultLayer();
        this.m_svName = ns.getName(defaultLayer);
        this.m_svLayer = new Layer();
        this.m_svLayer.setAttributes(new Attributes(defaultLayer.getAttributes()));
        final BasicUserForm dlg = new BasicUserForm(krnl, Messages.getString("db.layer.ModDefaultLayer.10"));
        String string = ns.getName(defaultLayer);
        String string2 = Messages.getString("db.layer.ModDefaultLayer.11");
        BasicUserForm basicUserForm = dlg;
        basicUserForm.getClass();
        dlg.addInput(LAYER_NAME, string, string2, new BasicUserForm.NonExistingNameVerifier(basicUserForm, LAYER_NAME, this.m_svName));
        Set<String> names = am.getLineWidths();
        final HashMap<String, String> lineWidthNameMap = new HashMap<String, String>();
        for (String name : names) {
            if (name.equals("DEFAULT")) continue;
            lineWidthNameMap.put(am.getLocalizedLineWidthName(name), name);
        }
        ArrayList locNames = new ArrayList(lineWidthNameMap.keySet());
        Collections.sort(locNames);
        final String locDefaultLineWidth = Messages.getString("db.att.Attribute.LineWidth.Name.DEFAULT");
        locNames.add(0, locDefaultLineWidth);
        dlg.addInput(LINE_WIDTH, locNames.toArray(), Messages.getString("db.layer.ModDefaultLayer.13"));
        names = am.getLinePatterns();
        final HashMap<String, String> linePatternNameMap = new HashMap<String, String>();
        for (String name : names) {
            if (name.equals("DEFAULT")) continue;
            linePatternNameMap.put(am.getLocalizedLinePatternName(name), name);
        }
        locNames = new ArrayList(linePatternNameMap.keySet());
        Collections.sort(locNames);
        final String locDefaultLinePattern = Messages.getString("db.att.Attribute.LinePattern.Name.DEFAULT");
        locNames.add(0, locDefaultLinePattern);
        dlg.addInput(LINE_PATTERN, locNames.toArray(), Messages.getString("db.layer.ModDefaultLayer.14"));
        names = am.getDrawPaints();
        final HashMap<String, String> drawPaintNameMap = new HashMap<String, String>();
        for (String name : names) {
            if (name.equals("DEFAULT")) continue;
            drawPaintNameMap.put(am.getLocalizedDrawPaintName(name), name);
        }
        locNames = new ArrayList(drawPaintNameMap.keySet());
        Collections.sort(locNames);
        final String locDefaultDrawPaint = Messages.getString("db.att.Attribute.DrawPaint.Name.DEFAULT");
        locNames.add(0, locDefaultDrawPaint);
        dlg.addInput(DRAW_PAINT, locNames.toArray(), Messages.getString("db.layer.ModDefaultLayer.15"));
        names = am.getFillPaints();
        final HashMap<String, String> fillPaintNameMap = new HashMap<String, String>();
        for (String name : names) {
            if (name.equals("DEFAULT")) continue;
            fillPaintNameMap.put(am.getLocalizedFillPaintName(name), name);
        }
        locNames = new ArrayList(fillPaintNameMap.keySet());
        Collections.sort(locNames);
        final String locDefaultFillPaint = Messages.getString("db.att.Attribute.FillPaint.Name.DEFAULT");
        locNames.add(0, locDefaultFillPaint);
        dlg.addInput(FILL_PAINT, locNames.toArray(), Messages.getString("db.layer.ModDefaultLayer.16"));
        names = am.getFontFamilies();
        final HashMap<String, String> fontFamilyNameMap = new HashMap<String, String>();
        for (String name : names) {
            if (name.equals("DEFAULT")) continue;
            fontFamilyNameMap.put(am.getLocalizedFontFamilyName(name), name);
        }
        locNames = new ArrayList(fontFamilyNameMap.keySet());
        Collections.sort(locNames);
        final String locDefaultFontFamily = Messages.getString("db.att.Attribute.FontFamily.Name.DEFAULT");
        locNames.add(0, locDefaultFontFamily);
        dlg.addInput(TEXT_FONT, locNames.toArray(), Messages.getString("db.layer.ModDefaultLayer.17"));
        names = am.getTextSizes();
        final HashMap<String, String> textSizeNameMap = new HashMap<String, String>();
        for (String name : names) {
            if (name.equals("DEFAULT")) continue;
            textSizeNameMap.put(am.getLocalizedTextSizeName(name), name);
        }
        locNames = new ArrayList(textSizeNameMap.keySet());
        Collections.sort(locNames);
        final String locDefaultTextSize = Messages.getString("db.att.Attribute.TextSize.Name.DEFAULT");
        locNames.add(0, locDefaultTextSize);
        dlg.addInput(TEXT_SIZE, locNames.toArray(), Messages.getString("db.layer.ModDefaultLayer.18"));
        names = am.getVisibilities();
        HashMap<String, String> visibilityNameMap = new HashMap<String, String>();
        for (String name : names) {
            if (name.equals("DEFAULT")) continue;
            visibilityNameMap.put(am.getLocalizedVisibilityName(name), name);
        }
        locNames = new ArrayList(visibilityNameMap.keySet());
        Collections.sort(locNames);
        String locDefaultVisibility = Messages.getString("db.att.Attribute.Visibility.Name.DEFAULT");
        locNames.add(0, locDefaultVisibility);
        dlg.addInput(VISIBILITY, locNames.toArray(), Messages.getString("db.layer.ModDefaultLayer.19"));
        dlg.addInput(DEFAULT_ATTRIBUTES, Boolean.TRUE, Messages.getString("db.layer.ModDefaultLayer.20"));
        final AttributeManager atm = AttributeManager.getAttributeManager();
        String name = defaultLayer.getAttributes().getLineWidth();
        String locName = atm.getLocalizedLineWidthName(name);
        dlg.setValue(LINE_WIDTH, (Object)locName);
        name = defaultLayer.getAttributes().getLinePattern();
        locName = atm.getLocalizedLinePatternName(name);
        dlg.setValue(LINE_PATTERN, (Object)locName);
        name = defaultLayer.getAttributes().getDrawPaint();
        locName = atm.getLocalizedDrawPaintName(name);
        dlg.setValue(DRAW_PAINT, (Object)locName);
        name = defaultLayer.getAttributes().getFillPaint();
        locName = atm.getLocalizedFillPaintName(name);
        dlg.setValue(FILL_PAINT, (Object)locName);
        name = defaultLayer.getAttributes().getFontFamily();
        locName = atm.getLocalizedFontFamilyName(name);
        dlg.setValue(TEXT_FONT, (Object)locName);
        name = defaultLayer.getAttributes().getTextSize();
        locName = atm.getLocalizedTextSizeName(name);
        dlg.setValue(TEXT_SIZE, (Object)locName);
        name = defaultLayer.getAttributes().getVisibility();
        locName = atm.getLocalizedVisibilityName(name);
        dlg.setValue(VISIBILITY, (Object)locName);
        final BasicUserForm.AttributePreviewIcon helpIcon = new BasicUserForm.AttributePreviewIcon(150, 150);
        dlg.setHelpIcon(helpIcon);
        dlg.addListener(new BasicUserForm.Listener(){

            @Override
            public void valueChanged(String name, Object oldValue, Object newValue) {
                String locName = dlg.getStringValue(LINE_WIDTH);
                name = locName.equals(locDefaultLineWidth) ? "DEFAULT" : (String)lineWidthNameMap.get(locName);
                helpIcon.setLineWidth(atm.getLineWidth(name));
                locName = dlg.getStringValue(DRAW_PAINT);
                name = locName.equals(locDefaultDrawPaint) ? "DEFAULT" : (String)drawPaintNameMap.get(locName);
                helpIcon.setDrawPaint(atm.getDrawPaint(name));
                locName = dlg.getStringValue(FILL_PAINT);
                name = locName.equals(locDefaultFillPaint) ? "DEFAULT" : (String)fillPaintNameMap.get(locName);
                helpIcon.setFillPaint(atm.getFillPaint(name));
                locName = dlg.getStringValue(TEXT_FONT);
                name = locName.equals(locDefaultFontFamily) ? "DEFAULT" : (String)fontFamilyNameMap.get(locName);
                locName = dlg.getStringValue(TEXT_SIZE);
                String name2 = locName.equals(locDefaultTextSize) ? "DEFAULT" : (String)textSizeNameMap.get(locName);
                helpIcon.setTextFont(atm.getFontFamily(name), atm.getTextSize(name2));
                locName = dlg.getStringValue(LINE_PATTERN);
                name = locName.equals(locDefaultLinePattern) ? "DEFAULT" : (String)linePatternNameMap.get(locName);
                helpIcon.setLinePattern(atm.getLinePattern(name));
                helpIcon.setText(dlg.getStringValue(LAYER_NAME));
                dlg.repaint();
            }
        });
        int result = dlg.start();
        if (result == -1) {
            throw new CmdAbortedException();
        }
        Attributes at = new Attributes();
        locName = dlg.getStringValue(LINE_WIDTH);
        name = locName.equals(locDefaultLineWidth) ? "DEFAULT" : (String)lineWidthNameMap.get(locName);
        at.setLineWidth(name);
        locName = dlg.getStringValue(LINE_PATTERN);
        name = locName.equals(locDefaultLinePattern) ? "DEFAULT" : (String)linePatternNameMap.get(locName);
        at.setLinePattern(name);
        locName = dlg.getStringValue(DRAW_PAINT);
        name = locName.equals(locDefaultDrawPaint) ? "DEFAULT" : (String)drawPaintNameMap.get(locName);
        at.setDrawPaint(name);
        locName = dlg.getStringValue(FILL_PAINT);
        name = locName.equals(locDefaultFillPaint) ? "DEFAULT" : (String)fillPaintNameMap.get(locName);
        at.setFillPaint(name);
        locName = dlg.getStringValue(TEXT_FONT);
        name = locName.equals(locDefaultFontFamily) ? "DEFAULT" : (String)fontFamilyNameMap.get(locName);
        at.setFontFamily(name);
        locName = dlg.getStringValue(TEXT_SIZE);
        name = locName.equals(locDefaultTextSize) ? "DEFAULT" : (String)textSizeNameMap.get(locName);
        at.setTextSize(name);
        locName = dlg.getStringValue(VISIBILITY);
        name = locName.equals(locDefaultVisibility) ? "DEFAULT" : (String)visibilityNameMap.get(locName);
        at.setVisibility(name);
        name = dlg.getStringValue(LAYER_NAME);
        ns.remove(defaultLayer);
        ns.put(defaultLayer, name);
        defaultLayer.setAttributes(at);
        ls.wasChanged(defaultLayer);
        if (dlg.getBooleanValue(DEFAULT_ATTRIBUTES)) {
            Attributes dat = am.getDefaultAttributes();
            this.m_svDefAttributes = new Attributes(dat);
            am.setDefaultAttributes(defaultLayer.getAttributes());
        }
        this.m_toString = String.valueOf(Messages.getString("db.layer.ModDefaultLayer.21")) + " " + ns.getName(defaultLayer) + " " + Messages.getString("db.layer.ModDefaultLayer.23") + " <" + at.toString() + "> " + Messages.getString("db.layer.ModDefaultLayer.24");
        System.out.println(this);
    }

    @Override
    public void undoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        NameSpace ns = db.getNameSpace();
        LayerSet ls = db.getLayerSet();
        AttributeManager am = db.getAttributeManager();
        Layer defaultLayer = ls.getDefaultLayer();
        String _tempName = ns.getName(defaultLayer);
        ns.remove(defaultLayer);
        ns.put(defaultLayer, this.m_svName);
        this.m_svName = _tempName;
        Layer _tempLayer = new Layer();
        _tempLayer.setAttributes(new Attributes(defaultLayer.getAttributes()));
        defaultLayer.setAttributes(new Attributes(this.m_svLayer.getAttributes()));
        this.m_svLayer = _tempLayer;
        if (this.m_svDefAttributes != null) {
            Attributes _temp = new Attributes(am.getDefaultAttributes());
            am.setDefaultAttributes(this.m_svDefAttributes);
            this.m_svDefAttributes = _temp;
        }
    }

    @Override
    public void redoCmd(Object context) {
        this.undoCmd(context);
    }

    @Override
    public boolean changesState() {
        return true;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }
}

