/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.dxf;

import cib.cad.ext.dxf.ExportEntityHeader;
import cib.util.dxf.DXFWriter;
import cib.util.dxf.GroupCode;
import java.io.IOException;

public class ExportBlockReference
extends ExportEntityHeader {
    private String m_name = null;
    private double m_x = 0.0;
    private double m_y = 0.0;

    public ExportBlockReference(String name) {
        this.m_name = name;
    }

    @Override
    public boolean commit(DXFWriter writer) throws IOException {
        if (this._isNaN()) {
            return false;
        }
        writer.writeGroup(GroupCode.GC0, "INSERT");
        writer.writeGroup(GroupCode.GC5, writer.nextHandle());
        writer.writeGroup(GroupCode.GC100, "AcDbEntity");
        super.commit(writer);
        writer.writeGroup(GroupCode.GC100, "AcDbBlockReference");
        writer.writeGroup(GroupCode.GC2, this.m_name);
        writer.writeGroup(GroupCode.GC10, this.m_x);
        writer.writeGroup(GroupCode.GC20, this.m_y);
        writer.writeGroup(GroupCode.GC30, 0.0);
        return true;
    }

    private boolean _isNaN() {
        return Double.isNaN(this.m_x) || Double.isNaN(this.m_y);
    }
}

