/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.dxf;

import cib.cad.ext.dxf.ExportEntityHeader;
import cib.util.dxf.DXFWriter;
import cib.util.dxf.GroupCode;
import java.io.IOException;

public class ExportLine
extends ExportEntityHeader {
    private double m_x1 = 0.0;
    private double m_y1 = 0.0;
    private double m_x2 = 0.0;
    private double m_y2 = 0.0;

    public ExportLine(double x1, double y1, double x2, double y2) {
        this.m_x1 = x1;
        this.m_y1 = y1;
        this.m_x2 = x2;
        this.m_y2 = y2;
    }

    @Override
    public boolean commit(DXFWriter writer) throws IOException {
        if (this._isNaN()) {
            return false;
        }
        writer.writeGroup(GroupCode.GC0, "LINE");
        writer.writeGroup(GroupCode.GC5, writer.nextHandle());
        writer.writeGroup(GroupCode.GC100, "AcDbEntity");
        super.commit(writer);
        writer.writeGroup(GroupCode.GC100, "AcDbLine");
        writer.writeGroup(GroupCode.GC10, this.m_x1);
        writer.writeGroup(GroupCode.GC20, this.m_y1);
        writer.writeGroup(GroupCode.GC11, this.m_x2);
        writer.writeGroup(GroupCode.GC21, this.m_y2);
        return true;
    }

    private boolean _isNaN() {
        return Double.isNaN(this.m_x1) || Double.isNaN(this.m_y1) || Double.isNaN(this.m_x2) || Double.isNaN(this.m_y2);
    }
}

