/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.mod;

import cib.cad.db.Database;
import cib.cad.db.MarkerMap;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.CtrlSegments;
import cib.cad.ext.mod.SplitSegments;
import cib.cad.ext.mod.ToPath;
import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UndoableCmd;
import cib.cad.kernel.UserInterface;
import cib.cad.lang.Messages;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.NamedListIterator;
import cib.util.coll.ObservableSet;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.Iterator;

public class ChangeSegmentType
extends UndoableCmd {
    private int m_segmentType = -1;
    private String m_toString = null;
    private ToPath m_toPathCmd = new ToPath();

    public static boolean isDoable() {
        return SplitSegments.isDoable();
    }

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        final UserInterface ui = krnl.getUserInterface();
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        MarkerMap mm = db.getMarkerMap();
        this.m_toPathCmd.doCmd(context);
        CmdLineDialog dlg = ui.getCmdLineDialog();
        dlg.setUniqueName("ext.mod.ChangeSegmentType-menu0");
        dlg.setPrompt(Messages.getString("ext.mod.ChangeSegmentType.0"));
        dlg.addChoice("Line");
        dlg.addChoice("Quad");
        dlg.addChoice("Cubic");
        dlg.addChoice("Arc");
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void choiceSelected(int iChoice) {
                switch (iChoice) {
                    case 0: {
                        ChangeSegmentType.this.m_segmentType = 8;
                        break;
                    }
                    case 1: {
                        ChangeSegmentType.this.m_segmentType = 16;
                        break;
                    }
                    case 2: {
                        ChangeSegmentType.this.m_segmentType = 32;
                        break;
                    }
                    case 3: {
                        ChangeSegmentType.this.m_segmentType = 64;
                    }
                }
                ui.disposeCmdLineDialog();
            }

            @Override
            public void dialogAborted() {
                ChangeSegmentType.this.m_segmentType = -1;
                ui.disposeCmdLineDialog();
            }
        });
        ui.showCmdLineDialog(dlg);
        if (this.m_segmentType < 0) {
            throw new CmdAbortedException();
        }
        boolean segmentNotChangeable = false;
        Iterator it = selSet.iterator();
        int nChangedSegments = 0;
        while (it.hasNext()) {
            int name;
            Component comp = (Component)it.next();
            if (!(comp instanceof CtrlSegments)) continue;
            CtrlSegments ctrlSegments = (CtrlSegments)comp;
            if (!mm.hasMarkedPrimitives(comp, 2)) continue;
            this._saveState(comp);
            HashSet<Integer> segNames = new HashSet<Integer>();
            NamedListIterator<Point2D> lit = comp.controlPointIterator();
            while (lit.hasNext()) {
                lit.next();
                int index = lit.previousIndex();
                name = lit.previousName();
                if (mm.primitiveMarked(comp, 2, index) && (ctrlSegments.getCtrlType(name) & 0xFC) != 0) {
                    segNames.add(name);
                }
                mm.markPrimitive(comp, 2, index, false);
            }
            Iterator sit = segNames.iterator();
            while (sit.hasNext()) {
                name = (Integer)sit.next();
                try {
                    ctrlSegments.setCtrlType(this.m_segmentType, name);
                    ++nChangedSegments;
                }
                catch (UnsupportedOperationException e) {
                    segmentNotChangeable = true;
                }
            }
        }
        String hints = "";
        if (segmentNotChangeable) {
            hints = String.valueOf(hints) + Messages.getString("ext.mod.ChangeSegmentType.6");
        }
        if (!this.changesState()) {
            hints = String.valueOf(hints) + Messages.getString("ext.mod.ChangeSegmentType.7");
        }
        if (hints.length() != 0) {
            krnl.readOK(Messages.getString("ext.mod.ChangeSegmentType.8"), "CADEMIA", hints, 2);
        }
        if (this.changesState()) {
            this.m_toString = String.valueOf(Messages.getString("ext.mod.ChangeSegmentType.10")) + nChangedSegments + Messages.getString("ext.mod.ChangeSegmentType.11");
            System.out.println(this);
        }
    }

    @Override
    public void undoCmd(Object context) {
        super.undoCmd(context);
        this.m_toPathCmd.undoCmd(context);
    }

    @Override
    public void redoCmd(Object context) {
        this.m_toPathCmd.redoCmd(context);
        super.redoCmd(context);
    }

    @Override
    public boolean changesState() {
        return super.changesState() || this.m_toPathCmd.changesState();
    }

    @Override
    public boolean isUndoable() {
        return super.isUndoable() && this.m_toPathCmd.isUndoable();
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }
}

