/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.mod;

import cib.cad.db.Database;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.Group;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.ObservableSet;

public class OpenGroup
implements Cmd {
    private Group m_group = null;

    public static boolean isDoable() {
        Kernel krnl = Kernel.getInstance();
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        return selSet.size() == 1 && selSet.iterator().next() instanceof Group;
    }

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        if (selSet.size() != 1) {
            System.err.println(Messages.getString("ext.mod.OpenGroup.0"));
            return;
        }
        Component comp = (Component)selSet.iterator().next();
        if (!(comp instanceof Group)) {
            System.err.println(Messages.getString("ext.mod.OpenGroup.1"));
            return;
        }
        this.m_group = (Group)comp;
        krnl.openGroup(this.m_group, false);
        db = krnl.getDatabase();
        System.out.println(this);
    }

    @Override
    public void undoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        krnl.closeGroup();
    }

    @Override
    public void redoCmd(Object context) {
        if (this.m_group != null) {
            Kernel krnl = (Kernel)context;
            krnl.openGroup(this.m_group, false);
        }
    }

    @Override
    public boolean changesState() {
        return this.m_group != null;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    public String toString() {
        return Messages.getString("ext.mod.OpenGroup.2");
    }
}

