/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.mod;

import cib.cad.db.Database;
import cib.cad.db.MarkerMap;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentArc2D;
import cib.cad.db.comp.ComponentCircle2D;
import cib.cad.db.comp.ComponentLine2D;
import cib.cad.db.comp.ComponentPath2D;
import cib.cad.db.comp.CtrlSegments;
import cib.cad.db.layer.Layer;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UndoableCmd;
import cib.cad.lang.Messages;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.ObservableSet;
import cib.util.coll.ReverseAccessMap;
import java.util.ArrayList;
import java.util.List;

public class ToPath
extends UndoableCmd {
    List<Component> m_originals = new ArrayList<Component>();
    List<ComponentPath2D> m_newPaths = new ArrayList<ComponentPath2D>();
    private String m_toString = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        ObservableSet<Component> selSet = db.getSelectSet();
        MarkerMap mm = db.getMarkerMap();
        ReverseAccessMap<Component, Layer> layerMap = db.getLayerMap();
        double[] crds = new double[8];
        for (Component comp : selSet) {
            ComponentPath2D path = null;
            if (comp instanceof ComponentLine2D && mm.primitiveMarked(comp, 2, 2)) {
                this._saveSelectState(comp);
                if (8 != ((CtrlSegments)comp).getSegmentCrds(2, crds)) {
                    throw new InternalError();
                }
                path = new ComponentPath2D();
                path.moveTo(crds[0], crds[1]);
                path.lineTo(crds[2], crds[3]);
            } else if (comp instanceof ComponentArc2D && mm.primitiveMarked(comp, 2, 0)) {
                this._saveSelectState(comp);
                if (64 != ((CtrlSegments)comp).getSegmentCrds(0, crds)) {
                    throw new InternalError();
                }
                path = new ComponentPath2D();
                path.moveTo(crds[0], crds[1]);
                path.arcTo(crds[2], crds[3], crds[4], crds[5]);
            } else if (comp instanceof ComponentCircle2D && mm.primitiveMarked(comp, 2, 0)) {
                this._saveSelectState(comp);
                if (64 != ((CtrlSegments)comp).getSegmentCrds(0, crds)) {
                    throw new InternalError();
                }
                path = new ComponentPath2D();
                path.moveTo(crds[0], crds[1]);
                path.arcTo(crds[2], crds[3], crds[4], crds[5]);
            }
            if (path == null) continue;
            this.m_originals.add(comp);
            this.m_newPaths.add(path);
        }
        cmpSet.addAll(this.m_newPaths);
        selSet.addAll(this.m_newPaths);
        for (ComponentPath2D path : this.m_newPaths) {
            mm.markPrimitive(path, 2, 2, true);
        }
        int n = this.m_originals.size();
        int i = 0;
        while (i < n) {
            Component original = this.m_originals.get(i);
            Component newPath = this.m_newPaths.get(i);
            newPath.setAttributes(original.getAttributes());
            Layer layer = (Layer)layerMap.get(original);
            if (layer != null) {
                layerMap.put(newPath, layer);
            }
            ++i;
        }
        cmpSet.removeAll(this.m_originals);
        if (this.changesState()) {
            this.m_toString = String.valueOf(Messages.getString("ext.mod.ToPath.0")) + this.m_originals + Messages.getString("ext.mod.ToPath.1");
            System.out.println(this);
        }
    }

    @Override
    public void undoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        ObservableSet<Component> selSet = db.getSelectSet();
        ReverseAccessMap<Component, Layer> layerMap = db.getLayerMap();
        cmpSet.addAll(this.m_originals);
        selSet.addAll(this.m_originals);
        int n = this.m_originals.size();
        int i = 0;
        while (i < n) {
            Component original = this.m_originals.get(i);
            Component newPath = this.m_newPaths.get(i);
            Layer layer = (Layer)layerMap.get(newPath);
            if (layer != null) {
                layerMap.put(original, layer);
            }
            ++i;
        }
        cmpSet.removeAll(this.m_newPaths);
        super.undoCmd(context);
    }

    @Override
    public void redoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        ObservableSet<Component> selSet = db.getSelectSet();
        MarkerMap mm = db.getMarkerMap();
        ReverseAccessMap<Component, Layer> layerMap = db.getLayerMap();
        cmpSet.addAll(this.m_newPaths);
        selSet.addAll(this.m_newPaths);
        for (ComponentPath2D path : this.m_newPaths) {
            mm.markPrimitive(path, 2, 2, true);
        }
        int n = this.m_originals.size();
        int i = 0;
        while (i < n) {
            Component original = this.m_originals.get(i);
            Component newPath = this.m_newPaths.get(i);
            Layer layer = (Layer)layerMap.get(original);
            if (layer != null) {
                layerMap.put(newPath, layer);
            }
            ++i;
        }
        cmpSet.removeAll(this.m_originals);
    }

    @Override
    public boolean changesState() {
        return !this.m_originals.isEmpty();
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }
}

