/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel;

import cib.cad.kernel.CmdLineToken;
import cib.cad.kernel.interpreter.TokenInterpreter;
import cib.cad.lang.Messages;
import java.awt.Point;

public class DigitizeToken
implements CmdLineToken {
    private int m_x = 0;
    private int m_y = 0;
    private int m_win = 0;

    public DigitizeToken() {
    }

    public DigitizeToken(int x, int y, int winMask) {
        this.m_x = x;
        this.m_y = y;
        this.m_win = winMask;
    }

    @Override
    public void fromString(String token) {
        int[] args = TokenInterpreter.getDigitize(token);
        if (args.length != 3) {
            throw new IllegalArgumentException(Messages.getString("kernel.DigitizeToken.0"));
        }
        this.m_x = args[0];
        this.m_y = args[1];
        this.m_win = args[2];
    }

    public String toString() {
        return "#dig(" + this.m_x + ' ' + this.m_y + ' ' + this.m_win + ')';
    }

    public int getX() {
        return this.m_x;
    }

    public int getY() {
        return this.m_y;
    }

    public Point getLocation() {
        return new Point(this.m_x, this.m_y);
    }

    public int getWindow() {
        return this.m_win;
    }
}

