/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel;

import cib.cad.kernel.CmdLineToken;

public class TextToken
implements CmdLineToken {
    private String m_text = "";

    public TextToken() {
    }

    public TextToken(String token) {
        this.m_text = TextToken.literalToString(token);
    }

    public static String literalToString(String literal) {
        int l = literal.length();
        if (l == 0) {
            return literal;
        }
        StringBuffer buf = new StringBuffer(literal);
        if (l >= 2 && buf.charAt(0) == '\"' && buf.charAt(l - 1) == '\"') {
            buf.deleteCharAt(l - 1);
            buf.deleteCharAt(0);
            int i = 0;
            while (i < buf.length()) {
                if (buf.charAt(i) == '\\') {
                    buf.deleteCharAt(i);
                    switch (buf.charAt(i)) {
                        case 'b': {
                            buf.setCharAt(i, '\b');
                            break;
                        }
                        case 't': {
                            buf.setCharAt(i, '\t');
                            break;
                        }
                        case 'n': {
                            buf.setCharAt(i, '\n');
                            break;
                        }
                        case 'f': {
                            buf.setCharAt(i, '\f');
                            break;
                        }
                        case 'r': {
                            buf.setCharAt(i, '\r');
                        }
                    }
                }
                ++i;
            }
        }
        return buf.toString();
    }

    public static String stringToLiteral(String string) {
        StringBuffer buf = new StringBuffer(string);
        int i = 0;
        while (i < buf.length()) {
            switch (buf.charAt(i)) {
                case '\b': {
                    buf.setCharAt(i, '\\');
                    buf.insert(++i, 'b');
                    break;
                }
                case '\t': {
                    buf.setCharAt(i, '\\');
                    buf.insert(++i, 't');
                    break;
                }
                case '\n': {
                    buf.setCharAt(i, '\\');
                    buf.insert(++i, 'n');
                    break;
                }
                case '\f': {
                    buf.setCharAt(i, '\\');
                    buf.insert(++i, 'f');
                    break;
                }
                case '\r': {
                    buf.setCharAt(i, '\\');
                    buf.insert(++i, 'r');
                    break;
                }
                case '\\': {
                    buf.setCharAt(i, '\\');
                    buf.insert(++i, '\\');
                    break;
                }
                case '\"': {
                    buf.setCharAt(i, '\\');
                    buf.insert(++i, '\"');
                    break;
                }
                case '\'': {
                    buf.setCharAt(i, '\\');
                    buf.insert(++i, '\'');
                }
            }
            ++i;
        }
        return "\"" + buf.toString() + "\"";
    }

    @Override
    public void fromString(String token) {
        this.m_text = TextToken.literalToString(token);
    }

    public String toString() {
        return this.m_text;
    }

    public String toLiteral() {
        return TextToken.stringToLiteral(this.m_text);
    }
}

