/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentPath2D;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.cmds.util.CubicCurveRubberBand;
import cib.cad.lang.Messages;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.ObservableSet;
import cib.util.geo.Geo2D;
import java.awt.geom.Point2D;

public class AddBezierCurve
implements Cmd {
    private ComponentPath2D m_comp = null;
    private String m_toString = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        CubicCurveRubberBand rb = null;
        try {
            Point2D p1 = krnl.readPoint(Messages.getString("kernel.cmds.AddBezierCurve.0"));
            rb = new CubicCurveRubberBand(krnl, p1);
            Point2D p4 = krnl.readPoint(Messages.getString("kernel.cmds.AddBezierCurve.1"));
            rb.setP4(p4);
            Point2D p2 = krnl.readPoint(Messages.getString("kernel.cmds.AddBezierCurve.2"));
            rb.setP2(p2);
            Point2D p3 = krnl.readPoint(Messages.getString("kernel.cmds.AddBezierCurve.3"));
            this.m_comp = new ComponentPath2D();
            this.m_comp.moveTo(p1.getX(), p1.getY());
            this.m_comp.cubicTo(p2.getX(), p2.getY(), p3.getX(), p3.getY(), p4.getX(), p4.getY());
            Database db = krnl.getDatabase();
            ObservableSet<Component> cmpSet = db.getComponentSet();
            cmpSet.add(this.m_comp);
            this.m_toString = String.valueOf(Messages.getString("kernel.cmds.AddBezierCurve.4")) + Geo2D.formatCoordinate(p1.getX()) + Messages.getString("kernel.cmds.AddBezierCurve.5") + Geo2D.formatCoordinate(p1.getY()) + Messages.getString("kernel.cmds.AddBezierCurve.6") + Geo2D.formatCoordinate(p2.getX()) + Messages.getString("kernel.cmds.AddBezierCurve.7") + Geo2D.formatCoordinate(p2.getY()) + Messages.getString("kernel.cmds.AddBezierCurve.8") + Geo2D.formatCoordinate(p3.getX()) + Messages.getString("kernel.cmds.AddBezierCurve.9") + Geo2D.formatCoordinate(p3.getY()) + Messages.getString("kernel.cmds.AddBezierCurve.10") + Geo2D.formatCoordinate(p4.getX()) + Messages.getString("kernel.cmds.AddBezierCurve.11") + Geo2D.formatCoordinate(p4.getY()) + Messages.getString("kernel.cmds.AddBezierCurve.12");
            System.out.println(this);
        }
        finally {
            if (rb != null) {
                rb.close();
            }
        }
    }

    @Override
    public void undoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        cmpSet.remove(this.m_comp);
    }

    @Override
    public void redoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        cmpSet.add(this.m_comp);
    }

    @Override
    public boolean changesState() {
        return this.m_comp != null;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.m_toString != null ? this.m_toString : super.toString();
    }
}

