/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.db.att.AttributeManager;
import cib.cad.db.att.Attributes;
import cib.cad.db.layer.Layer;
import cib.cad.db.layer.LayerSet;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.NameSpace;
import cib.util.cmd.CmdAbortedException;
import cib.util.cmd.CmdAdapter;

public class AttriSave
extends CmdAdapter {
    private static Attributes s_savedAttributes = null;
    private static String s_savedLayerName = null;
    private static Layer s_savedLayer = null;
    private String m_toString = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        AttributeManager atm = db.getAttributeManager();
        LayerSet layerSet = db.getLayerSet();
        NameSpace ns = db.getNameSpace();
        s_savedAttributes = atm.getDefaultAttributes();
        if (s_savedAttributes != null) {
            s_savedAttributes = (Attributes)atm.getDefaultAttributes().clone();
        }
        if ((s_savedLayer = layerSet.getDefaultLayer()) != null) {
            s_savedLayerName = ns.getName(s_savedLayer);
            s_savedLayer = (Layer)layerSet.getDefaultLayer().clone();
        }
        this.m_toString = Messages.getString("kernel.cmds.AttriSave.0");
        System.out.println(this);
    }

    public static Attributes getSavedAttributes() {
        return s_savedAttributes != null ? (Attributes)s_savedAttributes.clone() : null;
    }

    public static Layer getSavedLayer() {
        if (s_savedLayerName == null || s_savedLayer == null) {
            return null;
        }
        Kernel krnl = Kernel.getInstance();
        Database db = krnl.getDatabase();
        NameSpace ns = db.getNameSpace();
        Layer layer = (Layer)ns.getObject(s_savedLayerName);
        layer.setAttributes(s_savedLayer.getAttributes());
        return layer;
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }
}

