/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.db.att.AttributeManager;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.Group;
import cib.cad.db.feature.DrawPaintFeature;
import cib.cad.db.feature.Feature;
import cib.cad.db.feature.FillPaintFeature;
import cib.cad.db.feature.FontFamilyFeature;
import cib.cad.db.feature.LayerFeature;
import cib.cad.db.feature.LinePatternFeature;
import cib.cad.db.feature.LineWidthFeature;
import cib.cad.db.feature.StringFeature;
import cib.cad.db.feature.TextSizeFeature;
import cib.cad.db.feature.VisibilityFeature;
import cib.cad.db.layer.Layer;
import cib.cad.db.layer.LayerManager;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UndoableCmd;
import cib.cad.kernel.UserInterface;
import cib.cad.lang.Messages;
import cib.cad.view.FeatureDialog;
import cib.cad.view.GraphicalUserInterface;
import cib.util.NameSpace;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.ObservableSet;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ChangeFeatures
extends UndoableCmd {
    private String m_toString = null;

    public static boolean isDoable() {
        Kernel krnl = Kernel.getInstance();
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        return !selSet.isEmpty() || krnl.getOpenGroup() != null;
    }

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        String locName;
        Group group;
        final Kernel krnl = (Kernel)context;
        UserInterface ui = krnl.getUserInterface();
        final Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        AttributeManager atm = db.getAttributeManager();
        final LayerManager lm = LayerManager.getLayerManager();
        NameSpace ns = db.getNameSpace();
        String defaultValue = "DEFAULT";
        final HashSet<Component> cmpSet = new HashSet<Component>(selSet);
        if (cmpSet.isEmpty() && (group = krnl.getOpenGroup()) != null) {
            cmpSet.add(group);
        }
        if (cmpSet.size() == 0) {
            return;
        }
        HashMap enumMap = new HashMap();
        Set<String> names = atm.getLineWidths();
        ArrayList<String> list = new ArrayList<String>();
        for (String name : names) {
            if (name.equals("DEFAULT")) continue;
            locName = atm.getLocalizedLineWidthName(name);
            list.add(locName);
        }
        Collections.sort(list, Collator.getInstance());
        list.add(0, Messages.getString("db.att.Attribute.LineWidth.Name.DEFAULT"));
        enumMap.put(LineWidthFeature.class, list);
        names = atm.getLinePatterns();
        list = new ArrayList();
        for (String name : names) {
            if (name.equals("DEFAULT")) continue;
            locName = atm.getLocalizedLinePatternName(name);
            list.add(locName);
        }
        Collections.sort(list, Collator.getInstance());
        list.add(0, Messages.getString("db.att.Attribute.LinePattern.Name.DEFAULT"));
        enumMap.put(LinePatternFeature.class, list);
        names = atm.getDrawPaints();
        list = new ArrayList();
        for (String name : names) {
            if (name.equals("DEFAULT")) continue;
            locName = atm.getLocalizedDrawPaintName(name);
            list.add(locName);
        }
        Collections.sort(list, Collator.getInstance());
        list.add(0, Messages.getString("db.att.Attribute.DrawPaint.Name.DEFAULT"));
        enumMap.put(DrawPaintFeature.class, list);
        names = atm.getFillPaints();
        list = new ArrayList();
        for (String name : names) {
            if (name.equals("DEFAULT")) continue;
            locName = atm.getLocalizedFillPaintName(name);
            list.add(locName);
        }
        Collections.sort(list, Collator.getInstance());
        list.add(0, Messages.getString("db.att.Attribute.FillPaint.Name.DEFAULT"));
        enumMap.put(FillPaintFeature.class, list);
        names = atm.getFontFamilies();
        list = new ArrayList();
        for (String name : names) {
            if (name.equals("DEFAULT")) continue;
            locName = atm.getLocalizedFontFamilyName(name);
            list.add(locName);
        }
        Collections.sort(list, Collator.getInstance());
        list.add(0, Messages.getString("db.att.Attribute.FontFamily.Name.DEFAULT"));
        enumMap.put(FontFamilyFeature.class, list);
        names = atm.getTextSizes();
        list = new ArrayList();
        for (String name : names) {
            if (name.equals("DEFAULT")) continue;
            locName = atm.getLocalizedTextSizeName(name);
            list.add(locName);
        }
        Collections.sort(list, Collator.getInstance());
        list.add(0, Messages.getString("db.att.Attribute.TextSize.Name.DEFAULT"));
        enumMap.put(TextSizeFeature.class, list);
        names = atm.getVisibilities();
        list = new ArrayList();
        for (String name : names) {
            if (name.equals("DEFAULT")) continue;
            locName = atm.getLocalizedVisibilityName(name);
            list.add(locName);
        }
        Collections.sort(list, Collator.getInstance());
        list.add(0, Messages.getString("db.att.Attribute.Visibility.Name.DEFAULT"));
        enumMap.put(VisibilityFeature.class, list);
        GraphicalUserInterface gui = (GraphicalUserInterface)ui;
        final FeatureDialog featureDialog = new FeatureDialog(gui, krnl);
        Iterator<String> emptyEnumsIt = new HashSet().iterator();
        for (Component comp : cmpSet) {
            String compName = ns.getName(comp);
            StringFeature nameFeature = new StringFeature("GENERAL.NAME", compName);
            nameFeature.setChangeable(false);
            featureDialog.addFeature(nameFeature, emptyEnumsIt);
            String type = comp.getClass().getName();
            String key = "FEATURE.GENERAL.TYPE." + type;
            String locType = Messages.getString(key);
            if (locType.startsWith("!") && !Messages.containsKey(key)) {
                locType = type;
            }
            StringFeature typeFeature = new StringFeature("GENERAL.TYPE", locType);
            typeFeature.setChangeable(false);
            featureDialog.addFeature(typeFeature, emptyEnumsIt);
            Layer layer = lm.getComponentLayer(comp);
            String layerName = lm.getLayerName(layer);
            LayerFeature layerFeature = new LayerFeature("GENERAL.LAYER", layerName);
            List enums = new ArrayList();
            names = lm.getLayers();
            list = new ArrayList();
            for (String name : names) {
                if (name.equals("NULL_LAYER")) continue;
                String locName2 = lm.getLocalizedLayerName(name);
                list.add(locName2);
            }
            Collections.sort(list);
            list.add(0, lm.getLocalizedLayerName("NULL_LAYER"));
            featureDialog.addFeature(layerFeature, list.iterator());
            Iterator<Feature> fit = comp.featureIterator();
            while (fit.hasNext()) {
                Feature f = fit.next();
                Iterator<String> enumsIt = emptyEnumsIt;
                if (enumMap.containsKey(f.getClass())) {
                    enums = (List)enumMap.get(f.getClass());
                    enumsIt = enums.iterator();
                }
                featureDialog.addFeature(f, enumsIt);
            }
        }
        featureDialog.setFeatureChangeListener(new FeatureDialog.FeatureChangeListener(){

            @Override
            public void wasChanged(String name, String value) {
                for (Component comp : cmpSet) {
                    if (comp.hasFeature(name)) {
                        if (!ChangeFeatures.this._hasSavedObjectState(comp)) {
                            ChangeFeatures.this._saveObjectState(comp);
                        }
                        try {
                            Feature f = comp.getFeature(name);
                            f.valueFromString(value);
                            comp.setFeature(f);
                        }
                        catch (IllegalArgumentException e) {
                            System.err.println(e);
                        }
                        continue;
                    }
                    if (!name.equals("GENERAL.LAYER")) continue;
                    Layer layer = lm.getLayer(value);
                    lm.setComponentLayer(comp, layer);
                }
                db.updateDatabase();
                HashMap<String, Feature> _map = new HashMap<String, Feature>();
                for (Component comp : cmpSet) {
                    Iterator<Feature> fit = comp.featureIterator();
                    while (fit.hasNext()) {
                        Feature f = fit.next();
                        String fName = f.getName();
                        if (_map.containsKey(fName)) {
                            String fValue;
                            Feature _f = (Feature)_map.get(fName);
                            if (_f == null || (fValue = _f.valueToString()).equals(f.valueToString())) continue;
                            _map.put(fName, null);
                            continue;
                        }
                        _map.put(fName, f);
                    }
                    Layer layer = lm.getComponentLayer(comp);
                    String layerName = lm.getLayerName(layer);
                    _map.put("GENERAL.LAYER", new LayerFeature("GENERAL.LAYER", layerName));
                }
                featureDialog.updateFeatureDialog(_map);
                krnl.getUserInterface().updateUserInterface();
            }
        });
        featureDialog.setVisible(true);
        if (featureDialog.wasAborted()) {
            this.undoCmd(krnl);
        } else {
            this.m_toString = this.changesState() ? String.valueOf(Messages.getString("kernel.cmds.ChangeFeatures.1")) + cmpSet.size() + Messages.getString("kernel.cmds.ChangeFeatures.2") : Messages.getString("kernel.cmds.ChangeFeatures.3");
            System.out.println(this);
        }
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }
}

