/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.db.comp.Component;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.cmds.Copy;
import cib.cad.lang.Messages;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.ObservableSet;
import cib.util.geo.Vector2D;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CopyRectArray
extends Copy {
    private int m_nx = 0;
    private int m_ny = 0;
    private String m_toString = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        super.doCmd(context);
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        if (this.m_toString == null) {
            int n = selSet.size();
            this.m_toString = String.valueOf(Messages.getString("kernel.cmds.CopyRectArray.0")) + this.m_nx + Messages.getString("kernel.cmds.CopyRectArray.1") + this.m_ny + Messages.getString("kernel.cmds.CopyRectArray.2") + n + Messages.getString("kernel.cmds.CopyRectArray.3") + (n > 1 ? Messages.getString("kernel.cmds.CopyRectArray.4") : " ") + Messages.getString("kernel.cmds.CopyRectArray.6");
        }
        System.out.println(this);
        this._notifyPostDoCopy();
    }

    @Override
    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }

    @Override
    protected void _copy(Object context, Map<Component, List<Component>> cloningMap) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        ObservableSet<Component> selSet = db.getSelectSet();
        do {
            this.m_nx = krnl.readInteger(Messages.getString("kernel.cmds.CopyRectArray.7"));
        } while (this.m_nx <= 0);
        do {
            this.m_ny = krnl.readInteger(Messages.getString("kernel.cmds.CopyRectArray.8"));
        } while (this.m_ny <= 0);
        Vector2D vec = krnl.readVector(Messages.getString("kernel.cmds.CopyRectArray.9"));
        double dx = vec.getX();
        double dy = vec.getY();
        AffineTransform mat = new AffineTransform();
        for (Component comp : selSet) {
            ArrayList<Component> clones = new ArrayList<Component>();
            int ix = 0;
            while (ix < this.m_nx) {
                int iy = 0;
                while (iy < this.m_ny) {
                    if (ix != 0 || iy != 0) {
                        Component cpy = (Component)comp.clone();
                        mat.setToTranslation((double)ix * dx, (double)iy * dy);
                        cpy.transformBy(mat);
                        cmpSet.add(cpy);
                        clones.add(cpy);
                    }
                    ++iy;
                }
                ++ix;
            }
            if (clones.isEmpty()) continue;
            cloningMap.put(comp, clones);
        }
    }
}

