/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.kernel.Kernel;
import cib.cad.kernel.UserInterface;
import cib.util.cmd.CmdAdapter;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class HelpCommands
extends CmdAdapter {
    private static final String HELP = "// FILE\nnew                   Clears the database\nload                  Loads the database from a file\nstore                 Stores the database to the file loaded\nstoreas               Stores the database to a file\nchecksum              Calculates the Checksum of the database\nplay                  Plays/ runs a script file\nrecord                Records executed commands in a file\nstop                  Stops recording executed commands\nsuspend               Suspends recording executed commands\nresume                Resumes recording executed commands\nprint                 Prints (plots) the database\nprint1                Print method appropriate for Mac OS\nprint2                Print method appropriate for Windows\nprint0                Print method appropriate for Linux\nimportdxf             Import DXF data\nexportdxf             Export DXF data\nexit / bye / quit     Terminates program instance\n\n// EDIT\nundo                  Undoes a command\nredo                  Redoes a command\nagain                 Does the last executed command\nselectall             Selects all components\nselectbyname          Selects a component by its name\nselectbypick          Selects all components that intersect the pick box\nselectbypickinside    Selects all components that are inside the pick box\nselectpoints          Selects all control points that are inside the pick box\npicknear              Selects a component that intersect the pick box near\nunselectall           Unselects all components\nunselectbyname        Unselects a component by its name\nunselectbypick        Unselects all components that intersect the pick box\nunselectbypickinside  Unselects all components that are inside the pick box\nunselectpoints        Unselects all control points that are inside the pick box\nremove                Removes selected components\n\n// ATTRIBUTES\naddattributecmds      Adds cmds concerning attributes\ndeflinewidth          Defines a line width\ndeflinepattern        Defines a line pattern\ndefdrawpaint          Defines a draw paint\ndeffillpaint          Defines a fill paint\ndeffontfamily         Defines a font family\ndeftextsize           Defines a text size\nadddinattributes      Defines DIN 1356-1 attributes\n\nmoddefattribute       Modifies default attribute tuple\nmoddeflinewidth       Modifies default line width\nmoddeflinepattern     Modifies default line pattern\nmoddefdrawpaint       Modifies default draw paint\nmoddeffillpaint       Modifies default fill paint\nmoddeffontfamily      Modifies default font family\nmoddeftextsize        Modifies default text size\nmoddefattbydeflayer   Modifies default attribute by default layer\n\naddlayer              Adds a layer\nsetdefaultlayer       Sets the default layer\nmodDefaultLayer       Modifies the default layer\nadddinlayers          Adds layers according to the DIN\n\n// ADD\naddline               Adds a line component\naddpath               Adds a path component\naddbeziercurve        Adds a Bezier curve component\naddrect               Adds a rectangle component\naddcircle             Adds a circle component\naddarc                Adds an arc component\naddtext               Adds a text component\naddimage              Adds an image component\nadddim                Adds dimensioning components\naddmacrocell          Adds a cell defined as a macro\n\ncopytranslate         Copies and translates selected components\ncopyrotate            Copies and rotates selected components\ncopyscale             Copies and scales selected components\ncopymirror            Copies and mirrors selected components\ncopyrectarray         Copies a rectangular array of selected components\n\n// MODIFY\nmodattbylayer         Modifies selected components' attributes by their layer\nsetlayer              Modifies selected components' layer\nmodlinewidth          Modifies selected components' line width\nmodlinepattern        Modifies selected components' line pattern\nmoddrawpaint          Modifies selected components' draw paint\nmodfillpaint          Modifies selected components' fill paint\nmodfontfamily         Modifies selected components' font family\nmodtextsize           Modifies selected components' text size\n\ntranslate             Translates selected components\nrotate                Rotates selected components\nscale                 Scales selected components\nmirror                Mirrors selected components\n\nextend                Extends marked segments to intersection points\nextendBy              Extends marked segments about a distance\ntrim                  Trims marked segments to intersection points\ntrimBy                Trims marked segments about a distance\n\nsplit                 Splits selected segments\nchangetype            Changes the type of selected segments\n\ncontinuepath          Continues an existing path component\n\nchangefeatures        Changes selected components' features\n\n// MISC\nsetscale              Sets the scale factor\nsetucs                Sets the User Coordinate System\nsetNaturalUnit        Sets the natural unit like [m] or [mm]\nsetWorldUnits         Sets the world to natural units ratio\nputcmd                Puts a command\nremovecmd             Removes a command\naddClasspath          Adda a directory or a jar file to the classpath\naddPlugin             Adda a plugin\nremovecmd             Removes a command\nputViewController     Puts a View Controller\nsetprop               Sets a property\nsetMouseStrokeProp    Sets a mouse stroke property\nexec                  Executes a command in another process\naddMenuItem           Adds a menu item to the menu bar\nsetConSettings        Changes the construction settings\n\n// INFO\nsettings              Shows the database settings\ndump                  Dumps database components\ndumpBindings          Dumps database bindings\ndumplayers            Dumps database layers\ndumpattributes        Dumps database attributes\ndumpClasspath         Shows the CADEMIA classpath\ndumpPlugins           Shows all loaded plugins\ndumpprops             Shows all properties\ndumpMouseStrokeProps  Shows all mouse stroke properties\nchecksum              Shows checksum of the database\nstat                  Shows statistics of the database\n\necho                  Prints a message to the status bar\nmessage               Shows a message in a message box\n\ncondistance           Constructs a distance\nconangle              Constructs an angle\nconpoint              Constructs a point\ngetpoint              Gets a point\nconvector             Constructs a vector\nconline               Constructs a line\nconcircle             Constructs a circle\n\n// WINDOW\nrepaintGUI            Repaints the graphical user interface\nwinfit                Shows all components in the window\nwinzoom               Zooms the window\nwinscale              Scales the window\nwinmove               Moves the window\nsetlayout             Sets the window layout\n\nposBack               Moves components to the back\nposBackward           Moves components one position backward\nposSwap               Swaps the position of two components\nposForward            Moves components one position forward\nposFront              Moves components to the front\n\ngrid                  Sets the grid on/ off\nsetrectangulargrid    Sets the rectangular grid params\n\ngui                   Starts the graphical user interface\naddmenu               Adds the menu bar\naddtoolbar            Adds the toolbar\nclearinfoarea         Clears the info area\n\n// HELP\nhelp                  Prints this help\ninfo                  Prints information about the program\n\n// SPECIAL COMMANDS\nmacroload             Load the database providing a convenient way of argument passing in macros\nWinScaleByMouseWheel  Scales a window dynamically via mouse wheel\nWinMoveByMouseDrag    Mouse a window dynamically via mouse drag\nTranslateByMouseDrag  Translates components via mouse drag\nConSave               Save construction settings\nConRestore            Restore construction settings\nAttriSave             Save attributes\nAttriRestore          Restore attributes\n\n// TEST\ndemodlg               Tests the demo dialog\ngetchoice             Tests the choices\ngetdouble             Prints a double argument\ngetinteger            Prints an integer argument\ngetmouse              Prints a mouse event\ngetstring             Prints a string argument\ntest                  Tests something";

    @Override
    public void doCmd(Object context) {
        Kernel krnl = (Kernel)context;
        UserInterface ui = krnl.getUserInterface();
        JDialog dialog = new JDialog((JFrame)((Object)ui), "Info", true);
        JTextArea text = new JTextArea(HELP);
        text.setEditable(false);
        text.setLineWrap(true);
        text.setWrapStyleWord(true);
        text.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        text.setFont(new Font("Courier", 0, 13));
        JScrollPane scrollpane = new JScrollPane(text);
        dialog.getContentPane().add(scrollpane);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = ((JFrame)((Object)ui)).getSize();
        Dimension dialogSize = new Dimension(frameSize.width * 2 / 3, frameSize.height * 2 / 3);
        if (dialogSize.height < screenSize.height / 4) {
            dialogSize.height = screenSize.height / 4;
        }
        if (dialogSize.width < screenSize.width / 4) {
            dialogSize.width = screenSize.width / 4;
        }
        dialog.setSize(dialogSize);
        dialog.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
        dialog.setVisible(true);
    }
}

