/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.db.comp.Component;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.cmds.Transform;
import cib.cad.lang.Messages;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.ObservableSet;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;

public class Mirror
extends Transform {
    private static final AffineTransform FLIP_X = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);
    private String m_toString = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        super.doCmd(context);
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        int n = selSet.size();
        if (n > 0) {
            this.m_toString = String.valueOf(n) + Messages.getString("kernel.cmds.Mirror.0") + (n > 1 ? Messages.getString("kernel.cmds.Mirror.1") : " ") + Messages.getString("kernel.cmds.Mirror.3");
            System.out.println(this);
        }
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }

    @Override
    protected AffineTransform _getTransform(Kernel krnl) throws CmdAbortedException {
        Line2D.Double axis = new Line2D.Double();
        krnl.getConstruction().line2D(Messages.getString("kernel.cmds.Mirror.4"), axis);
        double dx = ((Line2D)axis).getX1();
        double dy = ((Line2D)axis).getY1();
        double angle = Math.atan2(((Line2D)axis).getY2() - ((Line2D)axis).getY1(), ((Line2D)axis).getX2() - ((Line2D)axis).getX1());
        AffineTransform mat = AffineTransform.getTranslateInstance(dx, dy);
        mat.rotate(angle);
        mat.concatenate(FLIP_X);
        mat.rotate(-angle);
        mat.translate(-dx, -dy);
        return mat;
    }
}

