/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.db.comp.Component;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.ObservableSet;
import cib.util.coll.SwappableList;
import java.util.ArrayList;
import java.util.List;

public class PosBack
implements Cmd {
    private List<Integer> m_originalPositions = new ArrayList<Integer>();
    private String m_toString = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        SwappableList<Component> cmpList = db.getComponentList();
        if (selSet.isEmpty()) {
            System.err.println(Messages.getString("kernel.cmds.PosBack.0"));
            return;
        }
        int posTo = 0;
        int i = 0;
        while (i < cmpList.size()) {
            Component comp = (Component)cmpList.get(i);
            if (selSet.contains(comp)) {
                this.m_originalPositions.add(i);
                int j = i;
                while (j > posTo) {
                    cmpList.swap(j, j - 1);
                    --j;
                }
                ++posTo;
            }
            ++i;
        }
        this.m_toString = String.valueOf(selSet.size()) + Messages.getString("kernel.cmds.PosBack.1");
        System.out.println(this);
    }

    @Override
    public void undoCmd(Object context) {
        Kernel krnl = Kernel.getInstance();
        Database db = krnl.getDatabase();
        SwappableList<Component> cmpList = db.getComponentList();
        int i = this.m_originalPositions.size() - 1;
        while (i >= 0) {
            int posTo = this.m_originalPositions.get(i);
            int j = i;
            while (j < posTo) {
                cmpList.swap(j, j + 1);
                ++j;
            }
            --i;
        }
    }

    @Override
    public void redoCmd(Object context) {
        Kernel krnl = Kernel.getInstance();
        Database db = krnl.getDatabase();
        SwappableList<Component> cmpList = db.getComponentList();
        int posTo = 0;
        int i = 0;
        while (i < this.m_originalPositions.size()) {
            int posFrom;
            int j = posFrom = this.m_originalPositions.get(i).intValue();
            while (j > posTo) {
                cmpList.swap(j, j - 1);
                --j;
            }
            ++posTo;
            ++i;
        }
    }

    @Override
    public boolean changesState() {
        Kernel krnl = Kernel.getInstance();
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        return !selSet.isEmpty();
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }
}

