/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.kernel.CmdJournaler;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UserInterface;
import cib.cad.lang.Messages;
import cib.util.cmd.CmdAbortedException;
import cib.util.cmd.CmdAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class Record
extends CmdAdapter {
    public static CmdJournaler JOURNALER = null;
    private Kernel m_krnl;
    private UserInterface m_ui;
    private _Dialog m_dlg = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        this.m_krnl = (Kernel)context;
        this.m_ui = this.m_krnl.getUserInterface();
        File file = this.m_krnl.readFile(new Kernel.FileDialogConfiguration(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".cademia_macro");
            }

            @Override
            public String[] getExtensions() {
                return new String[]{"cademia_macro"};
            }

            @Override
            public String getPrompt() {
                return Messages.getString("kernel.cmds.Record.1");
            }

            @Override
            public boolean isOpenDialog() {
                return false;
            }

            @Override
            public File getCurrentFile() {
                return new File("journal.cademia_macro");
            }

            @Override
            public String getFileFormatDescription() {
                return String.valueOf(Messages.getString("kernel.cmds.Record.3")) + " (*." + "cademia_macro" + ")";
            }
        });
        if (file.exists()) {
            System.out.println(Messages.getString("kernel.cmds.Record.6"));
        } else {
            System.out.println(Messages.getString("kernel.cmds.Record.7"));
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                return;
            }
        }
        if (!file.canWrite()) {
            System.err.println(String.valueOf(Messages.getString("kernel.cmds.Record.8")) + file.getAbsolutePath());
            return;
        }
        this.m_krnl.removeListener(JOURNALER);
        JOURNALER = new CmdJournaler(file, this.m_krnl);
        this.m_krnl.addListener(JOURNALER);
        System.out.println(String.valueOf(Messages.getString("kernel.cmds.Record.9")) + file.getAbsolutePath());
        this.m_dlg = new _Dialog((JFrame)((Object)this.m_ui), String.valueOf(Messages.getString("kernel.cmds.Record.10")) + file.getAbsolutePath());
        Point p = new Point();
        this.m_dlg.setLocation(this.m_ui.getUpperLeftLocationOnScreen(p));
        final CmdJournaler.Listener l = new CmdJournaler.Listener(){

            @Override
            public void cmdRecorded(String cmd) {
                Record.this.m_dlg.appendText(cmd);
            }
        };
        JOURNALER.addListener(l);
        JOURNALER.init();
        this.m_dlg.setDefaultCloseOperation(2);
        WindowAdapter wl = new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (JOURNALER != null) {
                    JOURNALER.removeListener(l);
                }
            }
        };
        this.m_dlg.addWindowListener(wl);
        this.m_dlg.setVisible(true);
    }

    private class _Dialog
    extends JDialog {
        private static final long serialVersionUID = 0L;
        private JTextArea m_textArea;

        public _Dialog(Frame frame, String title) {
            super(frame, title);
            this.setSize(300, 200);
            this.getContentPane().setLayout(new BorderLayout());
            this.m_textArea = new JTextArea();
            this.m_textArea.setEditable(false);
            this.getContentPane().add((Component)new JScrollPane(this.m_textArea), "Center");
        }

        public void appendText(String text) {
            this.m_textArea.append(text);
            int pos = this.m_textArea.getDocument().getLength();
            this.m_textArea.setCaretPosition(pos > 0 ? pos - 1 : 0);
        }
    }
}

