/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.CoordSpace;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;

public class SetWorldUnits
implements Cmd {
    private double m_nuPerWu;
    private String m_toString = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        double nuPerWu;
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        CoordSpace cs = db.getCoordSpace();
        this.m_nuPerWu = cs.getNaturalUnitsPerWorldUnit();
        while ((nuPerWu = krnl.readDouble(Messages.getString("kernel.cmds.SetWorldUnits.0"), 10000.0)) <= 0.0) {
            System.out.println(Messages.getString("kernel.cmds.SetWorldUnits.1"));
        }
        System.out.println(String.valueOf(Messages.getString("kernel.cmds.SetWorldUnits.2")) + nuPerWu + Messages.getString("kernel.cmds.SetWorldUnits.3"));
        if (!krnl.readYesNo(Messages.getString("kernel.cmds.SetWorldUnits.4"), 2)) {
            throw new CmdAbortedException();
        }
        cs.setNaturalUnitsPerWorldUnit(nuPerWu);
        this.m_toString = String.valueOf(Messages.getString("kernel.cmds.SetWorldUnits.5")) + nuPerWu + Messages.getString("kernel.cmds.SetWorldUnits.6");
        System.out.println(this);
        krnl.readOK(Messages.getString("kernel.cmds.SetWorldUnits.7"), Messages.getString("kernel.cmds.SetWorldUnits.8"), this.m_toString, 6);
        krnl.getUserInterface().repaintUserInterface();
    }

    @Override
    public void undoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        CoordSpace cs = db.getCoordSpace();
        double nuPerWu = this.m_nuPerWu;
        this.m_nuPerWu = cs.getNaturalUnitsPerWorldUnit();
        cs.setNaturalUnitsPerWorldUnit(nuPerWu);
        krnl.getUserInterface().repaintUserInterface();
    }

    @Override
    public void redoCmd(Object context) {
        this.undoCmd(context);
    }

    @Override
    public boolean changesState() {
        return true;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }
}

