/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.cmd.CmdAbortedException;
import cib.util.cmd.CmdAdapter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;

public class StoreAs
extends CmdAdapter {
    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        String EXT = "cademia";
        File file = krnl.readFile(new Kernel.FileDialogConfiguration(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".cademia");
            }

            @Override
            public String[] getExtensions() {
                return new String[]{"cademia"};
            }

            @Override
            public String getPrompt() {
                return Messages.getString("kernel.cmds.StoreAs.1");
            }

            @Override
            public boolean isOpenDialog() {
                return false;
            }

            @Override
            public File getCurrentFile() {
                return new File(String.valueOf(Messages.getString("kernel.cmds.StoreAs.2")) + "cademia");
            }

            @Override
            public String getFileFormatDescription() {
                return String.valueOf(Messages.getString("kernel.cmds.StoreAs.3")) + " (*." + "cademia" + ")";
            }
        });
        if (file.exists()) {
            System.out.println(Messages.getString("kernel.cmds.StoreAs.6"));
        } else {
            System.out.println(Messages.getString("kernel.cmds.StoreAs.7"));
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                return;
            }
        }
        if (!file.canWrite()) {
            System.err.println(String.valueOf(Messages.getString("kernel.cmds.StoreAs.8")) + file.getAbsolutePath());
            return;
        }
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));
            krnl.storeDatabase(out);
        }
        catch (IOException e) {
            System.err.println(e);
            return;
        }
        krnl.setDatabasePathname(file.getAbsolutePath());
        System.out.println(String.valueOf(Messages.getString("kernel.cmds.StoreAs.9")) + file.getAbsolutePath() + Messages.getString("kernel.cmds.StoreAs.10"));
    }
}

