/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UserInterface;
import cib.util.cmd.Cmd;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class WinFlags
implements Cmd {
    private Map<GeometryPanel, Integer> m_panelFlags = new HashMap<GeometryPanel, Integer>();
    protected String m_toString = null;

    protected void _setFlags(int windows, int flags, int flagMask) {
        UserInterface ui = Kernel.getInstance().getUserInterface();
        Iterator<GeometryPanel> it = ui.geometryPanelIterator();
        while (it.hasNext()) {
            int oldFlags;
            GeometryPanel panel = it.next();
            if ((panel.getId() & windows) == 0) continue;
            int newFlags = oldFlags = panel.getFlags();
            newFlags &= ~flagMask;
            if ((newFlags |= flags) == oldFlags) continue;
            this.m_panelFlags.put(panel, oldFlags);
            panel.setFlags(newFlags);
            panel.repaintPanel();
        }
    }

    @Override
    public void undoCmd(Object context) {
        Set<GeometryPanel> panels = this.m_panelFlags.keySet();
        for (GeometryPanel panel : panels) {
            int oldFlags = this.m_panelFlags.get(panel);
            this.m_panelFlags.put(panel, panel.getFlags());
            panel.setFlags(oldFlags);
            panel.repaintPanel();
        }
    }

    @Override
    public void redoCmd(Object context) {
        this.undoCmd(context);
    }

    @Override
    public boolean changesState() {
        return !this.m_panelFlags.isEmpty();
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }
}

