/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UserInterface;
import cib.cad.lang.Messages;
import cib.cad.view.DrawPanel;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.view.Projection2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class WinScale
implements Cmd {
    private static final double EPS = 0.001;
    private int m_winMask = 0;
    private double m_scale = -1.0;
    private String m_toString = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        double scale = krnl.readDouble(Messages.getString("kernel.cmds.WinScale.0"));
        if (scale < 0.001) {
            return;
        }
        this.m_winMask = krnl.readWindowIds(Messages.getString("kernel.cmds.WinScale.1"));
        this.m_scale = scale;
        this.scale(krnl);
        this.m_toString = Messages.getString("kernel.cmds.WinScale.2");
        System.out.println(this);
    }

    @Override
    public void undoCmd(Object context) {
        Kernel krnl = (Kernel)context;
        this.m_scale = 1.0 / this.m_scale;
        this.scale(krnl);
    }

    @Override
    public void redoCmd(Object context) {
        this.undoCmd(context);
    }

    @Override
    public boolean changesState() {
        return this.m_winMask != 0 && this.m_scale > 0.0;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }

    private void scale(Kernel krnl) {
        UserInterface ui = krnl.getUserInterface();
        Iterator<GeometryPanel> it = ui.geometryPanelIterator();
        while (it.hasNext()) {
            DrawPanel drawPanel = (DrawPanel)it.next();
            if ((drawPanel.getId() & this.m_winMask) == 0) continue;
            Projection2D prj = drawPanel.getProjection();
            Rectangle2D rect = prj.getViewPort();
            double ctrX = rect.getCenterX();
            double ctrY = rect.getCenterY();
            double vecX = this.m_scale * (rect.getMaxX() - ctrX);
            double vecY = this.m_scale * (rect.getMaxY() - ctrY);
            rect.setFrameFromDiagonal(ctrX - vecX, ctrY - vecY, ctrX + vecX, ctrY + vecY);
            if (!prj.setViewPort(rect)) {
                System.out.println(Messages.getString("kernel.cmds.WinScale.3"));
                continue;
            }
            drawPanel.setProjection(prj);
        }
    }
}

