/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.kernel.DigitizeObject;
import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.cad.view.DrawPanel;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.view.Projection2D;
import java.awt.Point;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class WinScaleByMouseWheel
implements Cmd {
    private double m_scale = 1.0;
    private DigitizeObject m_dig = null;
    private Rectangle2D m_vp = null;
    private static final int WAIT = 400;
    private long m_timer = 0L;
    private String m_toString = null;
    private static boolean s_entered = false;
    private static Object s_lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        try {
            Kernel krnl = (Kernel)context;
            Object object = s_lock;
            synchronized (object) {
                if (s_entered) {
                    if (!krnl.hasArgument()) return;
                    krnl.consumeArgument();
                    return;
                }
                s_entered = true;
            }
            DigitizeObject dig = krnl.readDigitizeObject(Messages.getString("kernel.cmds.WinScaleByMouseWheel.0"));
            GeometryPanel panel = dig.getGeometryPanel();
            this.m_vp = (Rectangle2D)panel.getProjection().getViewPort().clone();
            this.m_dig = dig;
            if (!(panel instanceof DrawPanel)) return;
            DrawPanel dp = (DrawPanel)panel;
            boolean microscopeEnabled = dp.microscopeEnabled();
            if (microscopeEnabled) {
                dp.enableMicroscope(false);
            }
            MouseWheelListener mwl = new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                    WinScaleByMouseWheel.this.m_timer = System.currentTimeMillis();
                    WinScaleByMouseWheel winScaleByMouseWheel = WinScaleByMouseWheel.this;
                    winScaleByMouseWheel.m_scale = winScaleByMouseWheel.m_scale * (e.getWheelRotation() > 0 ? 0.8 : 1.25);
                    WinScaleByMouseWheel.this.scale();
                }
            };
            dp.addMouseWheelListener(mwl);
            this.m_timer = System.currentTimeMillis();
            do {
                try {
                    Thread.sleep(80L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (System.currentTimeMillis() - this.m_timer <= 400L);
            dp.removeMouseWheelListener(mwl);
            if (this.m_dig == null) return;
            DrawPanel drawPanel = (DrawPanel)this.m_dig.getGeometryPanel();
            Projection2D prj = drawPanel.getProjection();
            Rectangle2D rect = prj.getViewPort();
            Point pnt = this.m_dig.getPoint();
            AffineTransform v2m = this.m_dig.getGeometryPanel().getProjection().getViewToModel();
            Point2D mp = v2m.transform(pnt, new Point2D.Double());
            double pntX = mp.getX();
            double pntY = mp.getY();
            double vecMinX = (pntX - rect.getMinX()) / this.m_scale;
            double vecMaxX = (rect.getMaxX() - pntX) / this.m_scale;
            double vecMinY = (pntY - rect.getMinY()) / this.m_scale;
            double vecMaxY = (rect.getMaxY() - pntY) / this.m_scale;
            rect.setFrameFromDiagonal(pntX - vecMinX, pntY - vecMinY, pntX + vecMaxX, pntY + vecMaxY);
            if (!prj.setViewPort(rect)) {
                this.m_toString = Messages.getString("kernel.cmds.WinScaleByMouseWheel.1");
            } else {
                drawPanel.setProjection(prj);
                this.m_toString = Messages.getString("kernel.cmds.WinScaleByMouseWheel.2");
            }
            System.out.println(this);
            if (!microscopeEnabled) return;
            dp.enableMicroscope(true);
            return;
        }
        finally {
            s_entered = false;
        }
    }

    @Override
    public void undoCmd(Object context) {
        Projection2D proj = this.m_dig.getGeometryPanel().getProjection();
        Rectangle2D _vp = (Rectangle2D)proj.getViewPort().clone();
        proj.setViewPort(this.m_vp);
        this.m_dig.getGeometryPanel().setProjection(proj);
        this.m_vp = _vp;
    }

    @Override
    public void redoCmd(Object context) {
        this.undoCmd(context);
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public boolean changesState() {
        return true;
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }

    private void scale() {
        DrawPanel drawPanel = (DrawPanel)this.m_dig.getGeometryPanel();
        double x = this.m_dig.getX();
        double y = this.m_dig.getY();
        AffineTransform trf = AffineTransform.getTranslateInstance(x, y);
        trf.scale(this.m_scale, this.m_scale);
        trf.translate(-x, -y);
        drawPanel.transformPanelImmediately(trf);
    }
}

