/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.kernel.DigitizeObject;
import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UserInterface;
import cib.cad.kernel.cmds.util.WindowRubberBand;
import cib.cad.lang.Messages;
import cib.cad.view.DrawPanel;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.view.Projection2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class WinZoom
implements Cmd {
    private Map<DrawPanel, Projection2D> m_drawPanelProjections = new HashMap<DrawPanel, Projection2D>();
    private String m_toString = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        UserInterface ui = krnl.getUserInterface();
        WindowRubberBand rb = null;
        try {
            DigitizeObject d1 = krnl.readDigitizeObject(Messages.getString("kernel.cmds.WinZoom.0"));
            Point p1 = d1.getPoint();
            AffineTransform v2m1 = d1.getGeometryPanel().getProjection().getViewToModel();
            Point2D mp1 = v2m1.transform(p1, new Point2D.Double());
            rb = new WindowRubberBand(krnl, d1);
            DigitizeObject d2 = krnl.readDigitizeObject(Messages.getString("kernel.cmds.WinZoom.1"));
            rb.close();
            Point p2 = d2.getPoint();
            AffineTransform v2m2 = d2.getGeometryPanel().getProjection().getViewToModel();
            Point2D mp2 = v2m2.transform(p2, new Point2D.Double());
            Rectangle2D.Double viewPort = new Rectangle2D.Double();
            viewPort.setFrameFromDiagonal(mp1, mp2);
            int winMask = krnl.readWindowIds(Messages.getString("kernel.cmds.WinZoom.2"));
            Iterator<GeometryPanel> it = ui.geometryPanelIterator();
            while (it.hasNext()) {
                DrawPanel drawPanel = (DrawPanel)it.next();
                if ((drawPanel.getId() & winMask) == 0) continue;
                this.m_drawPanelProjections.put(drawPanel, drawPanel.getProjection());
                this.zoom(drawPanel, viewPort);
            }
            this.m_toString = Messages.getString("kernel.cmds.WinZoom.3");
            System.out.println(this);
        }
        finally {
            if (rb != null) {
                rb.close();
            }
        }
    }

    @Override
    public void undoCmd(Object context) {
        Set<DrawPanel> set = this.m_drawPanelProjections.keySet();
        for (DrawPanel drawPanel : set) {
            Projection2D projection = this.m_drawPanelProjections.get(drawPanel);
            this.m_drawPanelProjections.put(drawPanel, drawPanel.getProjection());
            drawPanel.setProjection(projection);
        }
    }

    @Override
    public void redoCmd(Object context) {
        this.undoCmd(context);
    }

    @Override
    public boolean changesState() {
        return !this.m_drawPanelProjections.isEmpty();
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }

    private void zoom(DrawPanel drawPanel, Rectangle2D viewPort) {
        Projection2D projection = drawPanel.getProjection();
        if (!projection.setViewPort(viewPort)) {
            System.out.println(Messages.getString("kernel.cmds.WinZoom.4"));
            return;
        }
        drawPanel.setProjection(projection);
    }
}

