/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds.util;

import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UserInterface;
import cib.util.geo.Geo2D;
import cib.util.geo.NullVectorException;
import cib.util.geo.Vector2D;
import cib.util.view.Projection2D;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JPanel;

public class ArcAngleRubberBand
implements GeometryPanel.RubberbandListener {
    private UserInterface m_ui = null;
    private Point2D m_center = new Point2D.Double();
    private double m_radius = 0.0;
    private double m_startAngle = 0.0;
    private double m_sweepAngle = Double.NaN;
    private double m_signumSweepAngle = 1.0;
    private Shape m_shape = null;
    private Line2D m_radialLineStart = new Line2D.Double();
    private Line2D m_radialLineEnd = new Line2D.Double();
    private double m_lastAngle = 1.0;
    private Map<JPanel, Graphics2D> m_panelToGfx = new HashMap<JPanel, Graphics2D>();

    public ArcAngleRubberBand(Kernel krnl, Point2D ctr, double rad) {
        this.m_ui = krnl.getUserInterface();
        this.m_center.setLocation(ctr);
        this.m_radius = rad;
        this.m_radialLineStart.setLine(ctr, ctr);
        this.m_radialLineEnd.setLine(ctr, ctr);
        Iterator<GeometryPanel> it = this.m_ui.geometryPanelIterator();
        while (it.hasNext()) {
            GeometryPanel gp = it.next();
            JPanel panel = (JPanel)((Object)gp);
            Graphics2D gfx = (Graphics2D)panel.getGraphics();
            gfx.setXORMode(panel.getBackground());
            gfx.setColor(panel.getForeground());
            this.m_panelToGfx.put(panel, gfx);
            gp.addListener(this);
        }
    }

    @Override
    public void reset() {
        this.m_shape = null;
    }

    @Override
    public void paintStarts() {
        this._draw();
        this.m_shape = null;
    }

    @Override
    public void paintEnds() {
        this.m_shape = null;
        Iterator<GeometryPanel> it = this.m_ui.geometryPanelIterator();
        while (it.hasNext()) {
            GeometryPanel gp = it.next();
            JPanel panel = (JPanel)((Object)gp);
            Point p = panel.getMousePosition();
            if (p == null) continue;
            Point2D.Double pin = new Point2D.Double();
            Point2D.Double pout = new Point2D.Double();
            Projection2D prj2D = gp.getProjection();
            ((Point2D)pin).setLocation(((Point2D)p).getX(), ((Point2D)p).getY());
            prj2D.getViewToModel().transform(pin, pout);
            if (Double.isNaN(this.m_sweepAngle)) {
                Vector2D vp = new Vector2D(this.m_center, pout);
                this.m_startAngle = vp.getAngleCCW(vp);
                double dist = this.m_center.distance(pout);
                if (dist >= this.m_radius) {
                    this.m_radialLineStart.setLine(this.m_center, pout);
                } else if (dist >= Geo2D.getEps()) {
                    Vector2D vec = new Vector2D(this.m_center, pout);
                    vec.normalize();
                    vec.scaleBy(this.m_radius);
                    vec.add(this.m_center);
                    this.m_radialLineStart.setLine(this.m_center, vec);
                }
            } else {
                Vector2D vsp = new Vector2D(this.m_startAngle);
                Vector2D vp = new Vector2D(this.m_center, pout);
                double angleCCW = vsp.getAngleCCW(vp);
                if (angleCCW > 0.0 && angleCCW < 1.5707963267948966 && this.m_lastAngle > 4.71238898038469 && this.m_lastAngle < Math.PI * 2) {
                    this.m_signumSweepAngle = 1.0;
                } else if (this.m_lastAngle > 0.0 && this.m_lastAngle < 1.5707963267948966 && angleCCW > 4.71238898038469 && angleCCW < Math.PI * 2) {
                    this.m_signumSweepAngle = -1.0;
                }
                this.m_lastAngle = angleCCW;
                this.m_sweepAngle = this.m_signumSweepAngle > 0.0 ? angleCCW : angleCCW - Math.PI * 2;
                double dist = this.m_center.distance(pout);
                if (dist >= this.m_radius) {
                    this.m_radialLineEnd.setLine(this.m_center, pout);
                } else if (dist >= Geo2D.getEps()) {
                    Vector2D vec = new Vector2D(this.m_center, pout);
                    vec.normalize();
                    vec.scaleBy(this.m_radius);
                    vec.add(this.m_center);
                    this.m_radialLineEnd.setLine(this.m_center, vec);
                }
            }
            this.m_shape = this._getShape();
            break;
        }
        this._draw();
    }

    public void close() {
        Iterator<GeometryPanel> it = this.m_ui.geometryPanelIterator();
        while (it.hasNext()) {
            GeometryPanel gp = it.next();
            gp.removeListener(this);
            JPanel panel = (JPanel)((Object)gp);
            Graphics gfx = this.m_panelToGfx.get(panel);
            gfx.dispose();
        }
    }

    public void setStartAngle(double angle) {
        this.m_startAngle = angle;
        this.m_sweepAngle = 0.0;
        Vector2D vsp = new Vector2D(angle);
        vsp.scaleBy(this.m_radius);
        vsp.add(this.m_center);
        this.m_radialLineStart.setLine(this.m_center, vsp);
    }

    public double sweepAngleFromPoint(Point2D ep) {
        try {
            Vector2D vsp = new Vector2D(this.m_startAngle);
            Vector2D vp = new Vector2D(this.m_center, ep);
            double angleCCW = vsp.getAngleCCW(vp);
            return this.m_signumSweepAngle > 0.0 ? angleCCW : angleCCW - Math.PI * 2;
        }
        catch (NullVectorException e) {
            return 0.0;
        }
    }

    private Shape _getShape() {
        if (Double.isNaN(this.m_sweepAngle)) {
            Ellipse2D.Double ellipse = new Ellipse2D.Double();
            double x = this.m_center.getX();
            double y = this.m_center.getY();
            ellipse.setFrameFromCenter(x, y, x + this.m_radius, y + this.m_radius);
            return ellipse;
        }
        Vector2D vsp = new Vector2D(this.m_startAngle);
        vsp.scaleBy(this.m_radius);
        vsp.add(this.m_center);
        Vector2D vcp = new Vector2D(this.m_startAngle + 0.5 * this.m_sweepAngle);
        vcp.scaleBy(this.m_radius);
        vcp.add(this.m_center);
        Vector2D vep = new Vector2D(this.m_startAngle + this.m_sweepAngle);
        vep.scaleBy(this.m_radius);
        vep.add(this.m_center);
        return Geo2D.calculateArc2D(vsp, vcp, vep, new Arc2D.Double());
    }

    private synchronized void _draw() {
        if (this.m_shape != null) {
            Iterator<GeometryPanel> it = this.m_ui.geometryPanelIterator();
            while (it.hasNext()) {
                GeometryPanel panel = it.next();
                Graphics2D gfx = this.m_panelToGfx.get(panel);
                if (gfx == null) {
                    throw new InternalError("ArcAngleRubberBand: gfx == null");
                }
                Projection2D prj2D = panel.getProjection();
                AffineTransform m2v = prj2D.getModelToView();
                gfx.draw(m2v.createTransformedShape(this.m_shape));
                gfx.draw(m2v.createTransformedShape(this.m_radialLineStart));
                gfx.draw(m2v.createTransformedShape(this.m_radialLineEnd));
            }
        }
    }
}

