/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.constr;

import cib.cad.db.comp.Component;
import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.CmdLineToken;
import cib.cad.kernel.DigitizeObject;
import cib.cad.kernel.DigitizeToken;
import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.TextToken;
import cib.cad.kernel.cmds.util.AbsoluteAngleRubberBand;
import cib.cad.kernel.cmds.util.RelativeAngleRubberBand;
import cib.cad.kernel.constr.ConObject;
import cib.cad.kernel.constr.ConPoint2D;
import cib.cad.kernel.constr.Construction;
import cib.cad.lang.Messages;
import cib.util.cmd.CmdAbortedException;
import cib.util.geo.Geo2D;
import cib.util.geo.NullVectorException;
import cib.util.geo.Vector2D;
import cib.util.view.Projection2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class ConAngle2D
extends ConObject {
    private double m_defAngle = Double.NaN;
    private transient Object m_input = null;

    public ConAngle2D(Kernel krnl) {
        super(krnl);
        this._init();
    }

    protected ConAngle2D(ConObject con) {
        super(con);
        this._init();
    }

    private void _init() {
        this.setPrompt(Messages.getString("kernel.constr.ConAngle2D.0"));
    }

    public void setDefault(double angle) {
        this.m_defAngle = angle;
    }

    public double getDefault() {
        return this.m_defAngle;
    }

    @Override
    public void show() {
        this.showConAngleDialog(0);
    }

    @Override
    public void dispose() {
        this._getUI().disposeCmdLineDialog();
    }

    @Override
    public void setDigitizeCursor(boolean on) {
        ConPoint2D conPoint = new ConPoint2D(this.m_krnl);
        conPoint.setDigitizeCursor(on);
    }

    private void showConAngleDialog(final int recursionDepth) {
        block12: {
            block11: {
                CmdLineDialog dlg = this._getUI().getCmdLineDialog();
                dlg.setUniqueName("kernel.constr.ConAngle2D-menu0");
                dlg.setPrompt(this.getPrompt());
                dlg.enableDigitize(-1);
                dlg.enableTextInput();
                if (!Double.isNaN(this.m_defAngle)) {
                    dlg.setDefaultText(Geo2D.formatDegrees(Math.toDegrees(this.m_defAngle)));
                }
                dlg.addChoice("Pick");
                dlg.setChoiceHints(0, Messages.getString("kernel.constr.ConAngle2D.3"));
                dlg.addChoice("Construct rel");
                dlg.setChoiceHints(1, Messages.getString("kernel.constr.ConAngle2D.5"));
                dlg.setChoiceChecked(1, true);
                dlg.addChoice("Construct abs");
                dlg.setChoiceHints(2, Messages.getString("kernel.constr.ConAngle2D.7"));
                dlg.addSeparator();
                dlg.addChoice("Add");
                dlg.setChoiceHints(3, Messages.getString("kernel.constr.ConAngle2D.9"));
                dlg.addListener(new CmdLineDialog.Listener(){

                    @Override
                    public void textEntered(String text) {
                        try {
                            Number n = ConAngle2D.this.m_krnl.getNumberInterpreter().getNumber(text);
                            double angle = Math.toRadians(n.doubleValue());
                            if (recursionDepth == 0) {
                                ConAngle2D.this.notifyAngleConstructed(angle);
                                return;
                            }
                            ConAngle2D.this.m_input = new Double(angle);
                            ConAngle2D.this.setDefault(angle);
                            ConAngle2D.this._getUI().disposeCmdLineDialog();
                        }
                        catch (IllegalArgumentException e) {
                            System.err.println(Messages.getString("kernel.constr.ConAngle2D.10"));
                        }
                    }

                    @Override
                    public void choiceSelected(int iChoice) {
                        ConAngle2D.this.m_input = new Integer(iChoice);
                        ConAngle2D.this._getUI().disposeCmdLineDialog();
                    }

                    @Override
                    public void digitized(int x, int y, GeometryPanel gp) {
                        ConAngle2D.this.m_krnl.pushBackArguments(new CmdLineToken[]{new DigitizeToken(x, y, gp.getId())});
                        ConAngle2D.this.m_input = new Integer(1);
                        ConAngle2D.this._getUI().disposeCmdLineDialog();
                    }

                    @Override
                    public void dialogAborted() {
                        ConAngle2D.this.m_input = new CmdAbortedException();
                        ConAngle2D.this.notifyAborted();
                    }

                    @Override
                    public void interruptStarts(String argList) {
                        ConAngle2D.this.setDigitizeCursor(false);
                    }

                    @Override
                    public void interruptEnds() {
                        ConAngle2D.this.setDigitizeCursor(true);
                    }
                });
                this.setDigitizeCursor(true);
                this.m_input = null;
                this._getUI().showCmdLineDialog(dlg);
                this.setDigitizeCursor(false);
                if (this.m_input == null) {
                    return;
                }
                if (!(this.m_input instanceof Integer)) break block11;
                switch ((Integer)this.m_input) {
                    case 0: {
                        this.showPickAngleDialog();
                        break block12;
                    }
                    case 1: {
                        this.showRelativeAngleDialog();
                        break block12;
                    }
                    case 2: {
                        this.showAbsoluteAngleDialog();
                        break block12;
                    }
                    case 3: {
                        double angle = this.getDefault();
                        String prompt = this.getPrompt();
                        this.setDefault(1.5707963267948966);
                        this.setPrompt(String.valueOf(this.getPrompt()) + Messages.getString("kernel.constr.ConAngle2D.11") + Geo2D.formatDegrees(Math.toDegrees(angle)) + Messages.getString("kernel.constr.ConAngle2D.12"));
                        this.showConAngleDialog(recursionDepth + 1);
                        if (this.m_input instanceof CmdAbortedException) {
                            return;
                        }
                        this.setDefault(this.getDefault() + angle);
                        this.setPrompt(prompt);
                        break block12;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
            if (this.m_input instanceof Double) {
                return;
            }
        }
        if (this.m_input instanceof CmdAbortedException) {
            return;
        }
        this.showConAngleDialog(recursionDepth);
    }

    private boolean showPickAngleDialog() {
        CmdLineDialog dlg = this._getUI().getCmdLineDialog();
        dlg.setUniqueName("kernel.constr.ConAngle2D-menu1");
        dlg.setPrompt(String.valueOf(this.getPrompt()) + Messages.getString("kernel.constr.ConAngle2D.14"));
        dlg.enableDigitize(-1);
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void dialogAborted() {
                ConAngle2D.this.m_input = new CmdAbortedException();
                ConAngle2D.this._getUI().disposeCmdLineDialog();
            }

            @Override
            public void digitized(int x, int y, GeometryPanel gp) {
                ConAngle2D.this.m_input = new DigitizeObject(gp, x, y);
                ConAngle2D.this._getUI().disposeCmdLineDialog();
            }
        });
        this._setPickCursor(true);
        this._getUI().showCmdLineDialog(dlg);
        this._setPickCursor(false);
        if (this.m_input instanceof CmdAbortedException) {
            this.notifyAborted();
            return true;
        }
        if (this.m_input instanceof DigitizeObject) {
            DigitizeObject dig = (DigitizeObject)this.m_input;
            Rectangle2D.Double pickBox = new Rectangle2D.Double(dig.getX() - 5, dig.getY() - 5, 10.0, 10.0);
            double[] crds = new double[8];
            GeometryPanel gp = dig.getGeometryPanel();
            Iterator<Component> it = gp.objectIterator(pickBox, true);
            while (it.hasNext()) {
                Component o = it.next();
                if (!this._accepts(o, -1, -1)) continue;
                GeometryPanel.SegmentIterator git = gp.intersectionSegmentIterator(o, pickBox);
                while (git.hasNext()) {
                    Vector2D vec;
                    if (git.next(crds) != 8) continue;
                    Projection2D prj = gp.getProjection();
                    AffineTransform v2m = prj.getViewToModel();
                    Point2D digPnt = v2m.transform(new Point2D.Double(dig.getX(), dig.getY()), new Point2D.Double());
                    Vector2D vector2D = vec = digPnt.distance(crds[0], crds[1]) < digPnt.distance(crds[2], crds[3]) ? new Vector2D(crds[0], crds[1], crds[2], crds[3]) : new Vector2D(crds[2], crds[3], crds[0], crds[1]);
                    if (Geo2D.isNull(vec)) continue;
                    this.setDefault(Vector2D.X_UNIT.getAngleCCW(vec));
                    this.m_input = -1;
                    this._getUI().disposeCmdLineDialog();
                    return true;
                }
            }
            System.err.println(Messages.getString("kernel.constr.ConAngle2D.15"));
        }
        return false;
    }

    private void showRelativeAngleDialog() {
        Point2D.Double apex = new Point2D.Double();
        try {
            Construction.getConstruction(this.m_krnl).point2D(Messages.getString("kernel.constr.ConAngle2D.16"), apex, null, this.m_filter);
        }
        catch (CmdAbortedException e) {
            this.notifyAborted();
            return;
        }
        RelativeAngleRubberBand rb = new RelativeAngleRubberBand(this.m_krnl, apex);
        Point2D.Double p1 = new Point2D.Double();
        try {
            Construction.getConstruction(this.m_krnl).point2D(Messages.getString("kernel.constr.ConAngle2D.17"), p1, null, this.m_filter);
        }
        catch (CmdAbortedException e) {
            rb.close();
            this.notifyAborted();
            return;
        }
        rb.setStartAnglePoint(p1);
        Point2D.Double p2 = new Point2D.Double();
        DigitizeObject dig2 = null;
        try {
            dig2 = Construction.getConstruction(this.m_krnl).point2D(Messages.getString("kernel.constr.ConAngle2D.18"), p2, null, this.m_filter);
        }
        catch (CmdAbortedException e) {
            rb.close();
            this.notifyAborted();
            return;
        }
        rb.close();
        try {
            double relAngle = rb.relativeAngleFromPoint(p2);
            if (dig2 != null && !this.m_krnl.hasArgument()) {
                this.m_krnl.addArgument(new TextToken(String.valueOf(Math.toDegrees(relAngle))));
            }
            relAngle = this.showConfirmAngleDialog(relAngle);
            this.setDefault(relAngle);
        }
        catch (NullVectorException e) {
            System.err.println(Messages.getString("kernel.constr.ConAngle2D.20"));
        }
    }

    private double showConfirmAngleDialog(double angle) {
        CmdLineDialog dlg = this._getUI().getCmdLineDialog();
        dlg.setUniqueName("kernel.constr.ConAngle2D-menu2");
        dlg.setPrompt(String.valueOf(this.getPrompt()) + Messages.getString("kernel.constr.ConAngle2D.22"));
        dlg.setDefaultText(Geo2D.formatDegrees(Math.toDegrees(angle)));
        dlg.enableTextInput(true);
        dlg.addChoice("Invert");
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void choiceSelected(int iChoice) {
                ConAngle2D.this.m_input = new Integer(iChoice);
                ConAngle2D.this._getUI().disposeCmdLineDialog();
            }

            @Override
            public void dialogAborted() {
                ConAngle2D.this.m_input = new CmdAbortedException();
                ConAngle2D.this._getUI().disposeCmdLineDialog();
            }

            @Override
            public void textEntered(String text) {
                try {
                    ConAngle2D.this.m_input = Double.valueOf(text);
                    ConAngle2D.this._getUI().disposeCmdLineDialog();
                }
                catch (NumberFormatException e) {
                    System.err.println(Messages.getString("kernel.constr.ConAngle2D.24"));
                }
            }
        });
        this.m_input = null;
        this._getUI().showCmdLineDialog(dlg);
        if (this.m_input instanceof Integer) {
            int iChoice = (Integer)this.m_input;
            switch (iChoice) {
                case 0: {
                    if (angle < 0.0) {
                        angle += Math.PI * 2;
                        break;
                    }
                    angle -= Math.PI * 2;
                    break;
                }
                default: {
                    System.err.println(Messages.getString("kernel.constr.ConAngle2D.25"));
                    break;
                }
            }
        } else {
            if (this.m_input instanceof Double) {
                angle = (Double)this.m_input;
                angle = Math.toRadians(angle);
                return angle;
            }
            if (this.m_input instanceof CmdAbortedException) {
                this.notifyAborted();
                return angle;
            }
        }
        return this.showConfirmAngleDialog(angle);
    }

    private void showAbsoluteAngleDialog() {
        Point2D.Double apex = new Point2D.Double();
        try {
            Construction.getConstruction(this.m_krnl).point2D(Messages.getString("kernel.constr.ConAngle2D.26"), apex, null, this.m_filter);
        }
        catch (CmdAbortedException e) {
            this.notifyAborted();
            return;
        }
        AbsoluteAngleRubberBand rb = new AbsoluteAngleRubberBand(this.m_krnl, apex);
        Point2D.Double p = new Point2D.Double();
        try {
            Construction.getConstruction(this.m_krnl).point2D(Messages.getString("kernel.constr.ConAngle2D.27"), p, null, this.m_filter);
        }
        catch (CmdAbortedException e) {
            rb.close();
            this.notifyAborted();
            return;
        }
        try {
            Vector2D vec = new Vector2D(apex, p);
            this.setDefault(Vector2D.X_UNIT.getAngleCCW(vec));
        }
        catch (NullVectorException e) {
            System.err.println(Messages.getString("kernel.constr.ConAngle2D.28"));
        }
        rb.close();
    }

    private void notifyAngleConstructed(double angle) {
        Iterator<ConObject.Listener> it = this.listenerIterator();
        while (it.hasNext()) {
            Listener l = (Listener)it.next();
            l.angleConstructed(angle);
        }
    }

    @Override
    protected void notifyAborted() {
        super.notifyAborted();
        this.m_input = new CmdAbortedException();
    }

    public static class Adapter
    implements Listener {
        @Override
        public void dialogAborted() {
        }

        @Override
        public void angleConstructed(double angle) {
        }
    }

    public static interface Listener
    extends ConObject.Listener {
        public void angleConstructed(double var1);
    }
}

