/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.constr;

import cib.cad.db.comp.Component;
import cib.cad.db.feature.Feature;
import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.CmdLineToken;
import cib.cad.kernel.DigitizeObject;
import cib.cad.kernel.DigitizeToken;
import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.constr.ConObject;
import cib.cad.kernel.constr.ConPoint2D;
import cib.cad.kernel.constr.Construction;
import cib.cad.lang.Messages;
import cib.util.cmd.CmdAbortedException;
import cib.util.geo.Geo2D;
import cib.util.geo.Vector2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class ConDistance2D
extends ConObject {
    private double m_defDistance = Double.NaN;
    private transient Object m_input = null;

    public ConDistance2D(Kernel krnl) {
        super(krnl);
        this._init();
    }

    protected ConDistance2D(ConObject con) {
        super(con);
        this._init();
    }

    private void _init() {
        this.setPrompt(Messages.getString("kernel.constr.ConDistance2D.0"));
    }

    public boolean setDefault(double dist) {
        if (dist < 0.0) {
            return false;
        }
        this.m_defDistance = dist;
        return true;
    }

    public double getDefault() {
        return this.m_defDistance;
    }

    @Override
    public void show() {
        this.showConDistanceDialog();
    }

    @Override
    public void dispose() {
        this._getUI().disposeCmdLineDialog();
    }

    @Override
    public void setDigitizeCursor(boolean on) {
        ConPoint2D conPoint = new ConPoint2D(this.m_krnl);
        conPoint.setDigitizeCursor(on);
    }

    private void showConDistanceDialog() {
        CmdLineDialog dlg = this._getUI().getCmdLineDialog();
        dlg.setUniqueName("kernel.constr.ConDistance2D-menu0");
        dlg.setPrompt(this.getPrompt());
        dlg.enableDigitize(-1);
        dlg.enableTextInput();
        if (!Double.isNaN(this.m_defDistance)) {
            dlg.setDefaultText(Geo2D.formatCoordinate(this.m_defDistance));
        }
        dlg.addChoice("Pick");
        dlg.setChoiceHints(0, Messages.getString("kernel.constr.ConDistance2D.3"));
        dlg.addChoice("Vector");
        dlg.setChoiceHints(1, Messages.getString("kernel.constr.ConDistance2D.5"));
        dlg.setChoiceChecked(1, true);
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void textEntered(String text) {
                try {
                    Number n = ConDistance2D.this.m_krnl.getNumberInterpreter().getNumber(text);
                    double dist = n.doubleValue();
                    if (dist >= 0.0) {
                        ConDistance2D.this.notifyDistanceConstructed(dist);
                        return;
                    }
                    System.err.println(Messages.getString("kernel.constr.ConDistance2D.6"));
                }
                catch (IllegalArgumentException e) {
                    System.err.println(Messages.getString("kernel.constr.ConDistance2D.7"));
                }
            }

            @Override
            public void choiceSelected(int iChoice) {
                ConDistance2D.this.m_input = new Integer(iChoice);
                ConDistance2D.this._getUI().disposeCmdLineDialog();
            }

            @Override
            public void digitized(int x, int y, GeometryPanel gp) {
                ConDistance2D.this.m_krnl.pushBackArguments(new CmdLineToken[]{new DigitizeToken(x, y, gp.getId())});
                ConDistance2D.this.m_input = new Integer(1);
                ConDistance2D.this._getUI().disposeCmdLineDialog();
            }

            @Override
            public void dialogAborted() {
                ConDistance2D.this.m_input = new CmdAbortedException();
                ConDistance2D.this.notifyAborted();
            }

            @Override
            public void interruptStarts(String argList) {
                ConDistance2D.this.setDigitizeCursor(false);
            }

            @Override
            public void interruptEnds() {
                ConDistance2D.this.setDigitizeCursor(true);
            }
        });
        this.setDigitizeCursor(true);
        this.m_input = null;
        this._getUI().showCmdLineDialog(dlg);
        this.setDigitizeCursor(false);
        if (this.m_input == null) {
            return;
        }
        if (this.m_input instanceof Integer) {
            switch ((Integer)this.m_input) {
                case 0: {
                    this.showPickDistanceDialog();
                    break;
                }
                case 1: {
                    try {
                        Vector2D vec = new Vector2D();
                        Construction.getConstruction(this.m_krnl).vector2D(this.getPrompt(), vec, null, this.m_filter);
                        this.notifyDistanceConstructed(vec.length());
                        return;
                    }
                    catch (CmdAbortedException e) {
                        this.notifyAborted();
                        this.m_input = new CmdAbortedException();
                        break;
                    }
                }
                default: {
                    throw new InternalError();
                }
            }
        }
        if (this.m_input instanceof CmdAbortedException) {
            return;
        }
        this.showConDistanceDialog();
    }

    private void showPickDistanceDialog() {
        CmdLineDialog dlg = this._getUI().getCmdLineDialog();
        dlg.setUniqueName("kernel.constr.ConDistance2D-menu1");
        dlg.setPrompt(String.valueOf(this.getPrompt()) + Messages.getString("kernel.constr.ConDistance2D.9"));
        dlg.enableDigitize(-1);
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void dialogAborted() {
                ConDistance2D.this.m_input = new CmdAbortedException();
                ConDistance2D.this._getUI().disposeCmdLineDialog();
            }

            @Override
            public void digitized(int x, int y, GeometryPanel gp) {
                ConDistance2D.this.m_input = new DigitizeObject(gp, x, y);
                ConDistance2D.this._getUI().disposeCmdLineDialog();
            }
        });
        this._setPickCursor(true);
        this._getUI().showCmdLineDialog(dlg);
        this._setPickCursor(false);
        if (this.m_input instanceof CmdAbortedException) {
            this.notifyAborted();
        } else if (this.m_input instanceof DigitizeObject) {
            DigitizeObject dig = (DigitizeObject)this.m_input;
            Rectangle2D.Double pickBox = new Rectangle2D.Double(dig.getX() - 5, dig.getY() - 5, 10.0, 10.0);
            Iterator<Component> it = dig.getGeometryPanel().objectIterator(pickBox, true);
            while (it.hasNext()) {
                Feature f;
                Object val;
                Component comp = it.next();
                if (!this._accepts(comp, -1, -1) || !comp.hasFeature("GEOMETRY.LENGTH") || !((val = (f = comp.getFeature("GEOMETRY.LENGTH")).getValue()) instanceof Double)) continue;
                this.setDefault((Double)val);
                return;
            }
            System.err.println(Messages.getString("kernel.constr.ConDistance2D.12"));
        }
    }

    private void notifyDistanceConstructed(double dist) {
        Iterator<ConObject.Listener> it = this.listenerIterator();
        while (it.hasNext()) {
            Listener l = (Listener)it.next();
            l.distanceConstructed(dist);
        }
    }

    @Override
    protected void notifyAborted() {
        super.notifyAborted();
    }

    public static class Adapter
    implements Listener {
        @Override
        public void dialogAborted() {
        }

        @Override
        public void distanceConstructed(double dist) {
        }
    }

    public static interface Listener
    extends ConObject.Listener {
        public void distanceConstructed(double var1);
    }
}

