/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.interpreter;

import cib.cad.kernel.Kernel;
import cib.cad.kernel.interpreter.JavaCharStream;
import cib.cad.kernel.interpreter.ParseException;
import cib.cad.kernel.interpreter.Token;
import cib.cad.kernel.interpreter.TokenInterpreterConstants;
import cib.cad.kernel.interpreter.TokenInterpreterTokenManager;
import cib.cad.kernel.interpreter.TokenMgrError;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class TokenInterpreter
implements TokenInterpreterConstants {
    private static Kernel m_krnl = null;
    public TokenInterpreterTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[6];
    private static int[] jj_la1_0;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    static {
        TokenInterpreter.jj_la1_0();
    }

    public static void main(String[] args) throws ParseException {
        TokenInterpreter interpreter = new TokenInterpreter(System.in);
        while (true) {
            interpreter.ReInit(System.in);
            System.out.print("Enter expression: ");
            System.out.flush();
            try {
                interpreter.start();
                continue;
            }
            catch (TokenMgrError e) {
                System.out.println(e);
                continue;
            }
            catch (ParseException e) {
                System.out.println(e);
                continue;
            }
            break;
        }
    }

    public static void setKernel(Kernel krnl) {
        m_krnl = krnl;
    }

    public static String getMenu(String token) {
        StringReader reader = new StringReader(token);
        TokenInterpreter interpreter = new TokenInterpreter(reader);
        try {
            return interpreter.menu();
        }
        catch (TokenMgrError tokenMgrError) {
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Illegal menu item token");
    }

    public static int[] getDigitize(String token) {
        StringReader reader = new StringReader(token);
        TokenInterpreter interpreter = new TokenInterpreter(reader);
        try {
            return interpreter.digitize();
        }
        catch (TokenMgrError tokenMgrError) {
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Illegal digitize token");
    }

    public static double[] getNormDigitize(String token) {
        StringReader reader = new StringReader(token);
        TokenInterpreter interpreter = new TokenInterpreter(reader);
        try {
            return interpreter.normdigitize();
        }
        catch (TokenMgrError tokenMgrError) {
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Illegal normdigitize token");
    }

    public static String getVariable(String token) {
        StringReader reader = new StringReader(token);
        TokenInterpreter interpreter = new TokenInterpreter(reader);
        try {
            return interpreter.variable();
        }
        catch (TokenMgrError tokenMgrError) {
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Illegal variable token");
    }

    public static void getCancel(String token) {
        StringReader reader = new StringReader(token);
        TokenInterpreter interpreter = new TokenInterpreter(reader);
        try {
            interpreter.cancel();
            return;
        }
        catch (TokenMgrError tokenMgrError) {
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Illegal cancel token");
    }

    public static String getInterrupt(String token) {
        StringReader reader = new StringReader(token);
        TokenInterpreter interpreter = new TokenInterpreter(reader);
        try {
            return interpreter.interrupt();
        }
        catch (TokenMgrError tokenMgrError) {
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Illegal interrupt token");
    }

    public static int getWindow(String token) {
        StringReader reader = new StringReader(token);
        TokenInterpreter interpreter = new TokenInterpreter(reader);
        try {
            return interpreter.window();
        }
        catch (TokenMgrError tokenMgrError) {
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Illegal window token");
    }

    public static String getString(String arg) {
        return arg;
    }

    public final void start() throws ParseException {
        int arg = this.window();
        this.jj_consume_token(7);
        System.out.println("Window: " + arg);
    }

    public final String menu() throws ParseException {
        Token arg = null;
        Token menu = this.jj_consume_token(5);
        this.jj_consume_token(8);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 6: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        arg = this.jj_consume_token(5);
                        break block0;
                    }
                    case 6: {
                        arg = this.jj_consume_token(6);
                        break block0;
                    }
                }
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        this.jj_consume_token(9);
        if (!menu.image.equals("#menu")) {
            throw new ParseException("Invalid menu item token: " + menu.image);
        }
        if (arg != null) {
            if (arg.kind == 5) {
                return arg.image;
            }
            if (arg.kind == 6) {
                return arg.image.substring(1, arg.image.length() - 1);
            }
            throw new ParseException("Invalid argument: " + arg.image);
        }
        return "";
    }

    public final int[] digitize() throws ParseException {
        Token dig = this.jj_consume_token(5);
        this.jj_consume_token(8);
        int arg1 = this.intArg();
        int arg2 = this.intArg();
        int arg3 = this.intArg();
        this.jj_consume_token(9);
        if (!dig.image.equals("#dig")) {
            throw new ParseException("Invalid digitize token: " + dig.image);
        }
        int[] args = new int[]{arg1, arg2, arg3};
        return args;
    }

    public final double[] normdigitize() throws ParseException {
        Token norm = this.jj_consume_token(5);
        this.jj_consume_token(8);
        double arg1 = this.doubleArg();
        double arg2 = this.doubleArg();
        int arg3 = this.intArg();
        this.jj_consume_token(9);
        if (!norm.image.equals("#normdig")) {
            throw new ParseException("Invalid normdigitize token: " + norm.image);
        }
        double[] args = new double[]{arg1, arg2, arg3};
        return args;
    }

    public final String variable() throws ParseException {
        Token token = this.jj_consume_token(5);
        this.jj_consume_token(8);
        Token name = this.jj_consume_token(5);
        this.jj_consume_token(9);
        if (!token.image.equals("#variable")) {
            throw new ParseException("Invalid variable token: " + token.image);
        }
        return name.image;
    }

    public final void cancel() throws ParseException {
        Token cancel = this.jj_consume_token(5);
        this.jj_consume_token(8);
        this.jj_consume_token(9);
        if (!cancel.image.equals("#cancel")) {
            throw new ParseException("Invalid cancel token: " + cancel.image);
        }
    }

    public final String interrupt() throws ParseException {
        StringBuffer buf = new StringBuffer();
        Token interrupt = this.jj_consume_token(5);
        this.jj_consume_token(8);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 6: {
                this.interruptArg(buf);
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
            }
        }
        this.jj_consume_token(9);
        if (!interrupt.image.equals("#interrupt")) {
            throw new ParseException("Invalid interrupt token: " + interrupt.image);
        }
        return buf.toString();
    }

    public final void interruptArg(StringBuffer buf) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                Token arg = this.jj_consume_token(5);
                buf.append(arg.image);
                break;
            }
            case 6: {
                Token arg = this.jj_consume_token(6);
                buf.append(arg.image);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final int window() throws ParseException {
        Object string = null;
        int i = 0;
        Token win = this.jj_consume_token(5);
        this.jj_consume_token(8);
        i = this.intArg();
        this.jj_consume_token(9);
        if (!win.image.equals("#win")) {
            throw new ParseException("Invalid window token: " + win.image);
        }
        return i;
    }

    public final int intArg() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                Token argToken = this.jj_consume_token(5);
                return m_krnl.getNumberInterpreter().getNumber(argToken.image).intValue();
            }
            case 6: {
                Token argToken = this.jj_consume_token(6);
                String arg = argToken.image.substring(1, argToken.image.length() - 1);
                return m_krnl.getNumberInterpreter().getNumber(arg).intValue();
            }
        }
        this.jj_la1[4] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final double doubleArg() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                Token argToken = this.jj_consume_token(5);
                String arg = argToken.image;
                arg.replace(",", ".");
                return m_krnl.getNumberInterpreter().getNumber(arg).doubleValue();
            }
            case 6: {
                Token argToken = this.jj_consume_token(6);
                String arg = argToken.image.substring(1, argToken.image.length() - 1);
                arg.replace(",", ".");
                return m_krnl.getNumberInterpreter().getNumber(arg).doubleValue();
            }
        }
        this.jj_la1[5] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{96, 96, 96, 96, 96, 96};
    }

    public TokenInterpreter(InputStream stream) {
        this(stream, null);
    }

    public TokenInterpreter(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new TokenInterpreterTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 6) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 6) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public TokenInterpreter(Reader stream) {
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new TokenInterpreterTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 6) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 6) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public TokenInterpreter(TokenInterpreterTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 6) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(TokenInterpreterTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 6) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
            ++i;
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[10];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        int i = 0;
        while (i < 6) {
            if (this.jj_la1[i] == this.jj_gen) {
                int j = 0;
                while (j < 32) {
                    if ((jj_la1_0[i] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 10) {
            if (la1tokens[i]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = i;
                this.jj_expentries.addElement(this.jj_expentry);
            }
            ++i;
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        int i2 = 0;
        while (i2 < this.jj_expentries.size()) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
            ++i2;
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }
}

