/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.view;

import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.cad.view.GraphicalUserInterface;
import cib.util.NameSpace;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.CollUtilities;
import cib.util.coll.ReverseAccessMap;
import cib.util.view.FillPaint;
import cib.util.view.Projection2D;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class BasicUserForm
extends JDialog {
    private static final long serialVersionUID = 1L;
    public static final char MNEMONIC_CHAR = '&';
    protected JButton btnESC = new JButton(Messages.getString("view.BasicUserForm.0"));
    protected JButton btnOK = new JButton(Messages.getString("view.BasicUserForm.1"));
    public static final int CANCEL = -1;
    public static final int OK = -2;
    protected LinkedList<String> m_labels;
    protected LinkedList<Object> m_startValues;
    protected LinkedList<String> m_help;
    protected ReverseAccessMap<String, Component> m_values = CollUtilities.reverseAccessMap(new HashMap());
    protected List<JButton> m_buttons = new LinkedList<JButton>();
    protected int m_result = -2;
    protected Kernel m_krnl = null;
    protected GraphicalUserInterface m_ui = null;
    protected Icon m_icon = UIManager.getIcon("OptionPane.questionIcon");
    protected Icon m_helpIcon = null;
    protected int m_helpPanelLoc = 0;
    public static final int HELP_RIGHT = 0;
    public static final int HELP_BOTTOM = 1;
    public static final int NO_HELP = 2;
    protected KeyListener keyUpDownListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 40: {
                    BasicUserForm.this.dispatchEvent(new KeyEvent(e.getComponent(), e.getID(), e.getWhen(), 0, 9, e.getKeyChar()));
                    break;
                }
                case 38: {
                    BasicUserForm.this.dispatchEvent(new KeyEvent(e.getComponent(), e.getID(), e.getWhen(), 64, 9, e.getKeyChar()));
                }
            }
        }
    };
    protected KeyListener keyEnterEscListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 27: {
                    BasicUserForm.this.btnESC.doClick();
                    break;
                }
                case 10: {
                    BasicUserForm.this.btnOK.doClick();
                }
            }
        }
    };
    protected Map<String, InputVerifier> m_verifiers = new HashMap<String, InputVerifier>();
    protected static Map<Class<?>, Border> m_borders = new HashMap();
    protected Set<Listener> m_listeners = new HashSet<Listener>();
    protected ValueListener m_listener = new ValueListener();

    static {
        m_borders.put(JTextField.class, new JTextField().getBorder());
        m_borders.put(JComboBox.class, new JComboBox().getBorder());
        m_borders.put(JCheckBox.class, new JCheckBox().getBorder());
    }

    public BasicUserForm(Kernel krnl, String title) {
        super((GraphicalUserInterface)krnl.getUserInterface(), title, false);
        this.m_krnl = krnl;
        this.m_ui = (GraphicalUserInterface)krnl.getUserInterface();
        this.m_labels = new LinkedList();
        this.m_startValues = new LinkedList();
        this.m_help = new LinkedList();
    }

    public BasicUserForm(Kernel krnl, String title, String[] labels, Object[] values, String[] help) {
        this(krnl, title);
        this.m_startValues.addAll(Arrays.asList(values));
        this.m_help.addAll(Arrays.asList(help));
        int i = 0;
        while (i < labels.length) {
            this.m_labels.add(labels[i]);
            this.m_values.put(this._name(i), this._createInputComponent(labels[i], values[i], this.m_help.get(i), i == 0));
            ++i;
        }
    }

    private String _name(String name) {
        return name.replaceAll("&", "");
    }

    private String _name(int index) {
        return this._name(this.m_labels.get(index).toString());
    }

    private Object _getInput(Object inputComp) {
        try {
            if (inputComp instanceof JTextField) {
                return ((JTextField)inputComp).getText();
            }
            if (inputComp instanceof JComboBox) {
                return ((JComboBox)inputComp).getSelectedItem().toString();
            }
            if (inputComp instanceof JCheckBox) {
                return new Boolean(((JCheckBox)inputComp).isSelected());
            }
        }
        catch (Exception e) {
            return null;
        }
        String cls = inputComp == null ? "null" : inputComp.getClass().getName();
        throw new IllegalArgumentException(String.valueOf(Messages.getString("view.BasicUserForm.6")) + cls + Messages.getString("view.BasicUserForm.7"));
    }

    private void _setInput(Object inputComp, Object value) {
        try {
            if (inputComp instanceof JTextField) {
                ((JTextField)inputComp).setText((String)value);
            }
            if (inputComp instanceof JComboBox) {
                ((JComboBox)inputComp).setSelectedItem(value);
            }
            if (inputComp instanceof JCheckBox) {
                ((JCheckBox)inputComp).setSelected(Boolean.parseBoolean((String)value));
            }
            return;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(String.valueOf(Messages.getString("view.BasicUserForm.8")) + inputComp.getClass().getName() + Messages.getString("view.BasicUserForm.9") + Messages.getString("view.BasicUserForm.10") + value + Messages.getString("view.BasicUserForm.11"));
        }
    }

    public int start() {
        this._init();
        this._notifyAll();
        this._generalCmdLineDialog();
        this.dispose();
        return this.m_result;
    }

    public void addInput(String name, Object value) {
        this.addInput(name, value, name);
    }

    public void addInput(String label, Object value, String help) {
        this.m_labels.add(label);
        int index = this.m_labels.indexOf(label);
        String name = this._name(label);
        this.m_startValues.add(value);
        this.m_help.add(help);
        this.m_values.put(name, this._createInputComponent(label, value, help, index == 0));
    }

    public void addInput(String name, Object value, String help, InputVerifier iv) {
        this.addInput(name, value, help);
        this.putVerification(name, iv);
    }

    public Object getValue(String name) {
        name = this._checkName(name);
        Object o = this.m_values.get(name);
        return this._getInput(o);
    }

    public Object getValue(int index) {
        String name = this._name(index);
        return this.getValue(name);
    }

    public String getStringValue(String name) {
        Object o = this.getValue(name);
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    public String getStringValue(int index) {
        String name = this._name(index);
        return this.getStringValue(name);
    }

    public boolean getBooleanValue(String name) {
        Object o = this.getValue(name);
        if (o != null && o instanceof Boolean) {
            return (Boolean)o;
        }
        throw new IllegalArgumentException(String.valueOf(Messages.getString("view.BasicUserForm.12")) + name + Messages.getString("view.BasicUserForm.13"));
    }

    public boolean getBooleanValue(int index) {
        String name = this._name(index);
        return this.getBooleanValue(name);
    }

    public Object setValue(String name, Object value) {
        name = this._checkName(name);
        Object o = this.m_values.get(name);
        Object oldValue = this._getInput(o);
        this._setInput(o, value);
        return oldValue;
    }

    public Object setValue(int index, Object value) {
        String name = this._name(index);
        return this.setValue(name, value);
    }

    public Icon getIcon() {
        return this.m_icon;
    }

    public void setIcon(Icon icon) {
        this.m_icon = icon;
    }

    public void setHelpPanelLocation(int loc) {
        this.m_helpPanelLoc = loc;
    }

    public void setHelpIcon(Icon help) {
        this.m_helpIcon = help;
    }

    public void addButton(JButton btn) {
        this.m_buttons.add(btn);
    }

    public void putVerification(String name, InputVerifier iv) {
        name = this._checkName(name);
        this.m_verifiers.put(name, iv);
    }

    public void informError(String msg) {
        JOptionPane.showMessageDialog(null, this._name(msg), Messages.getString("view.BasicUserForm.14"), 0);
    }

    protected String _checkName(String name) {
        if (name == null) {
            throw new NullPointerException(Messages.getString("view.BasicUserForm.15"));
        }
        if (!this.m_values.containsKey(name = this._name(name))) {
            throw new IllegalArgumentException(String.valueOf(Messages.getString("view.BasicUserForm.16")) + name + Messages.getString("view.BasicUserForm.17"));
        }
        return name;
    }

    protected boolean _verifyAll() {
        boolean result = true;
        for (String name : this.m_values.keySet()) {
            if (!this.m_verifiers.containsKey(name)) continue;
            Object value = this.getValue(name);
            InputVerifier iv = this.m_verifiers.get(name);
            boolean _result = iv.verify(value);
            JComponent c = (JComponent)this.m_values.get(name);
            if (!_result) {
                c.setBorder(BorderFactory.createLineBorder(new Color(231, 0, 0), 3));
            } else {
                Border b = m_borders.get(c.getClass());
                c.setBorder(b);
            }
            result &= _result;
        }
        return result;
    }

    public void addListener(Listener l) {
        if (l != null) {
            this.m_listeners.add(l);
        }
    }

    public boolean removeListener(Listener l) {
        return this.m_listeners.remove(l);
    }

    protected void _notify(String name, Object oldValue, Object newValue) {
        for (Listener l : this.m_listeners) {
            l.valueChanged(name, oldValue, newValue);
        }
    }

    protected void _notifyAll() {
        for (String name : this.m_values.keySet()) {
            Object value = this.getValue(name);
            this._notify(name, null, value);
        }
    }

    private void _generalCmdLineDialog() {
        CmdLineDialog dlg = this.m_ui.getCmdLineDialog();
        dlg.setPrompt(Messages.getString("view.BasicUserForm.34"));
        int i = 0;
        while (i < this.m_labels.size()) {
            dlg.addChoice(this._name(i));
            ++i;
        }
        dlg.addChoice(Messages.getString("view.BasicUserForm.35"));
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void textEntered(String text) {
                BasicUserForm.this.setValue(BasicUserForm.this._name(0), (Object)text);
                BasicUserForm.this.m_result = -2;
                BasicUserForm.this.m_ui.disposeCmdLineDialog();
            }

            @Override
            public void choiceSelected(int iChoice) {
                BasicUserForm.this.m_result = iChoice;
                BasicUserForm.this.m_ui.disposeCmdLineDialog();
            }

            @Override
            public void dialogAborted() {
                BasicUserForm.this.m_result = -1;
                BasicUserForm.this.m_ui.disposeCmdLineDialog();
            }
        });
        this.setVisible(true);
        this.m_ui.showCmdLineDialog(dlg);
        if (this.m_result >= 0 && this.m_result < this.m_labels.size()) {
            this._inputCmdLineDialog(this._name(this.m_result));
            this._generalCmdLineDialog();
        } else if (this.m_result == this.m_labels.size()) {
            this.m_result = -2;
            this.m_ui.disposeCmdLineDialog();
        }
    }

    private void _inputCmdLineDialog(String name) {
        try {
            String val = this.m_krnl.readString(name);
            this.setValue(name, (Object)val);
        }
        catch (CmdAbortedException cmdAbortedException) {
            // empty catch block
        }
    }

    protected JPanel _createButtonPanel() {
        this.btnESC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                BasicUserForm.this.m_result = -1;
                BasicUserForm.this.m_ui.disposeCmdLineDialog();
                BasicUserForm.this.dispose();
            }
        });
        this.btnESC.addKeyListener(this.keyUpDownListener);
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                BasicUserForm.this.btnOK.requestFocus();
                if (!BasicUserForm.this._verifyAll()) {
                    return;
                }
                BasicUserForm.this.m_result = -2;
                BasicUserForm.this.m_ui.disposeCmdLineDialog();
                BasicUserForm.this.dispose();
            }
        });
        this.btnOK.addKeyListener(this.keyUpDownListener);
        this.btnOK.setPreferredSize(this.btnESC.getPreferredSize());
        JPanel panel = new JPanel(new FlowLayout());
        panel.add(this.btnOK);
        panel.add(this.btnESC);
        Iterator<JButton> it = this.m_buttons.iterator();
        while (it.hasNext()) {
            panel.add(it.next());
        }
        panel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        return panel;
    }

    protected JLabel _createLabel(String label, String help) {
        char mnemonic = '\u0000';
        if (label.indexOf(38) != -1) {
            mnemonic = label.charAt(label.indexOf(38) + 1);
            label.replace('&', '\u0000');
        }
        JLabel l = new JLabel(this._name(label), 2);
        if (mnemonic != '\u0000') {
            l.setDisplayedMnemonic(mnemonic);
        }
        l.setToolTipText(help);
        return l;
    }

    protected JComponent _createInputComponent(String label, Object value, String help, boolean requestFocus) {
        JComponent input = null;
        if (value instanceof Object[]) {
            final JComboBox<Object> combo = new JComboBox<Object>();
            Object[] values = (Object[])value;
            String sel = values[0].toString();
            int j = 0;
            while (j < values.length) {
                combo.addItem(values[j]);
                ++j;
            }
            combo.setSelectedItem(sel);
            combo.setMaximumSize(new Dimension(combo.getMaximumSize().width, combo.getPreferredSize().height));
            combo.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent arg0) {
                    if (arg0.getModifiers() == 8) {
                        if (arg0.getKeyCode() == 40) {
                            combo.showPopup();
                        } else if (arg0.getKeyCode() == 38) {
                            combo.hidePopup();
                        }
                    }
                }
            });
            combo.addItemListener(new ItemListener(){
                private String m_oldValue = null;

                @Override
                public void itemStateChanged(ItemEvent arg0) {
                    int state = arg0.getStateChange();
                    String name = BasicUserForm.this.m_values.getKey(combo);
                    String value = (String)combo.getSelectedItem();
                    switch (state) {
                        case 2: {
                            this.m_oldValue = value;
                            break;
                        }
                        case 1: {
                            BasicUserForm.this._notify(name, this.m_oldValue, value);
                        }
                    }
                }
            });
            input = combo;
        } else if (value instanceof Boolean) {
            boolean bool = (Boolean)value;
            JCheckBox check = new JCheckBox(this._name(label));
            boolean b = (Boolean)value;
            check.setSelected(b);
            check.setFocusPainted(true);
            check.setMaximumSize(new Dimension(check.getMaximumSize().width, check.getPreferredSize().height));
            check.setSelected(bool);
            check.addKeyListener(this.keyUpDownListener);
            if (label.indexOf(38) != -1) {
                char mnemonic = label.charAt(label.indexOf(38) + 1);
                check.setMnemonic(mnemonic);
            }
            Insets ins = check.getBorder().getBorderInsets(check);
            check.setBorder(BorderFactory.createEmptyBorder(ins.top, 0, ins.bottom, ins.right));
            input = check;
        } else {
            final JTextField textField = new JTextField(10);
            textField.setMaximumSize(new Dimension(textField.getMaximumSize().width, textField.getPreferredSize().height));
            if (value != null) {
                textField.setText(value.toString());
            }
            textField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent arg0) {
                    textField.selectAll();
                }
            });
            textField.addKeyListener(this.keyUpDownListener);
            input = textField;
        }
        input.setToolTipText(help);
        input.addKeyListener(this.keyEnterEscListener);
        input.addFocusListener(this.m_listener);
        if (requestFocus) {
            input.requestFocus();
        }
        return input;
    }

    protected JPanel _createFormPanel() {
        JPanel formPanel = new JPanel(new SpringLayout());
        formPanel.setOpaque(true);
        int numPairs = this.m_labels.size();
        int i = 0;
        while (i < numPairs) {
            String help = this.m_help.get(i);
            Object startValue = this.m_startValues.get(i);
            String label = this.m_labels.get(i);
            JLabel l = this._createLabel(label, help);
            if (startValue instanceof Boolean) {
                l.setText("");
            }
            formPanel.add(l);
            JComponent input = (JComponent)this.m_values.get(this._name(label));
            l.setLabelFor(input);
            this.m_values.put(label, input);
            formPanel.add(input);
            ++i;
        }
        this._makeCompactGrid(formPanel, numPairs, 2, 6, 6, 6, 6);
        formPanel.setBorder(new CompoundBorder(new EmptyBorder(10, 0, 0, 0), new CompoundBorder(new TitledBorder(new EtchedBorder(), this.getTitle()), new EmptyBorder(15, 5, 5, 5))));
        return formPanel;
    }

    private void _init() {
        JPanel btnPanel = this._createButtonPanel();
        JPanel formPanel = this._createFormPanel();
        JScrollPane scroll = new JScrollPane(formPanel);
        scroll.setOpaque(false);
        scroll.setBorder(formPanel.getBorder());
        formPanel.setBorder(BorderFactory.createEmptyBorder());
        double maxh = Toolkit.getDefaultToolkit().getScreenSize().getHeight() / 2.0;
        scroll.setMaximumSize(new Dimension((int)scroll.getMaximumSize().getWidth(), (int)Math.min(scroll.getMaximumSize().getHeight(), maxh)));
        scroll.setPreferredSize(new Dimension((int)scroll.getPreferredSize().getWidth(), (int)Math.min(scroll.getPreferredSize().getHeight(), maxh)));
        JLabel iconLabel = new JLabel(this.m_icon);
        iconLabel.setVerticalAlignment(1);
        iconLabel.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)scroll, "North");
        panel.setMinimumSize(panel.getSize());
        this.add((Component)iconLabel, "West");
        this.add((Component)panel, "Center");
        this.add((Component)btnPanel, "South");
        if (this.m_helpIcon != null && this.m_helpIcon.getIconHeight() != -1 && this.m_helpIcon.getIconWidth() != -1) {
            JLabel helpLabel = new JLabel(this.m_helpIcon);
            helpLabel.setVerticalAlignment(0);
            helpLabel.setBorder(new CompoundBorder(new EmptyBorder(10, 0, 0, 0), new CompoundBorder(new TitledBorder(new EtchedBorder(), Messages.getString("view.BasicUserForm.37")), new EmptyBorder(15, 5, 5, 5))));
            switch (this.m_helpPanelLoc) {
                case 0: {
                    this.add((Component)helpLabel, "East");
                    break;
                }
                case 1: {
                    panel.add((Component)helpLabel, "Center");
                }
            }
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                BasicUserForm.this.m_result = -1;
                BasicUserForm.this.m_ui.disposeCmdLineDialog();
                BasicUserForm.this.dispose();
            }
        });
        this.pack();
        final int h = this.getHeight();
        final int w = this.getWidth();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - w) / 2, (screenSize.height - h) / 2);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent arg0) {
                BasicUserForm.this.setSize(Math.max(w, BasicUserForm.this.getWidth()), h);
            }
        });
        this.setMinimumSize(this.getSize());
    }

    private void _makeCompactGrid(Container parent, int rows, int cols, int initialX, int initialY, int xPad, int yPad) {
        SpringLayout layout;
        try {
            layout = (SpringLayout)parent.getLayout();
        }
        catch (ClassCastException exc) {
            System.err.println("The first argument to makeCompactGrid must use SpringLayout.");
            return;
        }
        Spring x = Spring.constant(initialX);
        int c = 0;
        while (c < cols) {
            Spring width = Spring.constant(0);
            int r = 0;
            while (r < rows) {
                width = Spring.max(width, this._getConstraintsForCell(r, c, parent, cols).getWidth());
                ++r;
            }
            r = 0;
            while (r < rows) {
                SpringLayout.Constraints constraints = this._getConstraintsForCell(r, c, parent, cols);
                constraints.setX(x);
                constraints.setWidth(width);
                ++r;
            }
            x = Spring.sum(x, Spring.sum(width, Spring.constant(xPad)));
            ++c;
        }
        Spring y = Spring.constant(initialY);
        int r = 0;
        while (r < rows) {
            Spring height = Spring.constant(0);
            int c2 = 0;
            while (c2 < cols) {
                height = Spring.max(height, this._getConstraintsForCell(r, c2, parent, cols).getHeight());
                ++c2;
            }
            c2 = 0;
            while (c2 < cols) {
                SpringLayout.Constraints constraints = this._getConstraintsForCell(r, c2, parent, cols);
                constraints.setY(y);
                constraints.setHeight(height);
                ++c2;
            }
            y = Spring.sum(y, Spring.sum(height, Spring.constant(yPad)));
            ++r;
        }
        SpringLayout.Constraints pCons = layout.getConstraints(parent);
        pCons.setConstraint("South", y);
        pCons.setConstraint("East", x);
    }

    private SpringLayout.Constraints _getConstraintsForCell(int row, int col, Container parent, int cols) {
        SpringLayout layout = (SpringLayout)parent.getLayout();
        Component c = parent.getComponent(row * cols + col);
        return layout.getConstraints(c);
    }

    public static class AttributePreviewIcon
    extends JLabel
    implements Icon {
        private static final long serialVersionUID = 1L;
        private int m_height = -1;
        private int m_width = -1;
        private int m_lineWidth = 1;
        private Paint m_drawPaint = null;
        private Paint m_fillPaint = null;
        private Font m_textFont = null;
        private float[] m_linePattern = null;
        private String m_text = null;
        private double m_unit = 11.0;

        public AttributePreviewIcon(int width, int height) {
            this.m_height = height;
            this.m_width = width;
            this.setIcon(this);
        }

        public void setDrawPaint(Paint drawPaint) {
            this.m_drawPaint = drawPaint;
        }

        public void setFillPaint(Paint p) {
            if (p instanceof Color) {
                Color c = (Color)p;
                this.m_fillPaint = new Color(c.getRed(), c.getGreen(), c.getBlue(), 180);
            } else if (p instanceof FillPaint) {
                FillPaint fp = (FillPaint)p;
                try {
                    Rectangle2D.Double viewPort = new Rectangle2D.Double(0.0, 0.0, 5.0, 5.0);
                    Projection2D prj = new Projection2D(viewPort, this.m_width, this.m_height);
                    AffineTransform m2v = prj.getModelToView();
                    fp.setTransparency(180);
                    fp.setModelToView(m2v);
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    // empty catch block
                }
                this.m_fillPaint = fp;
            } else {
                this.m_fillPaint = p;
            }
        }

        public void setLinePattern(double[] pattern) {
            if (pattern == null) {
                this.m_linePattern = new float[]{1.0f, 0.0f};
            } else {
                this.m_linePattern = new float[pattern.length];
                int i = 0;
                while (i < pattern.length) {
                    this.m_linePattern[i] = (float)(this.m_unit * pattern[i]);
                    ++i;
                }
            }
        }

        public void setLineWidth(double lineWidth) {
            this.m_lineWidth = (int)Math.max(1.0, this.m_unit * lineWidth);
        }

        public void setTextFont(String textFont, double textSize) {
            textSize = (int)Math.max(6.0, this.m_unit * textSize / 2.0);
            this.m_textFont = Font.decode(textFont).deriveFont((float)textSize);
        }

        @Override
        public void setText(String text) {
            this.m_text = text;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int m = 20;
            int x1 = x + m;
            int y1 = y + m;
            int x2 = x1 + this.m_width - 2 * m;
            int y2 = y1 + this.m_height - 2 * m;
            int l = (x2 - x1) / 3;
            int h = (y2 - y1) / 3;
            Graphics2D g2d = (Graphics2D)g;
            Polygon poly = new Polygon();
            poly.addPoint(x1, y1);
            poly.addPoint(x1 + 3 * l, y1);
            poly.addPoint(x1 + 3 * l, y1 + h);
            poly.addPoint(x1 + l, y1 + h);
            poly.addPoint(x1 + l, y1 + 3 * h);
            poly.addPoint(x1, y1 + 3 * h);
            poly.addPoint(x1, y1);
            if (this.m_fillPaint != null) {
                g2d.setPaint(this.m_fillPaint);
                g.fillPolygon(poly);
            }
            if (this.m_drawPaint != null && this.m_linePattern != null) {
                g2d.setPaint(this.m_drawPaint);
                g2d.setStroke(new BasicStroke(this.m_lineWidth, 1, 1, 1.0f, this.m_linePattern, 0.0f));
                g.drawPolygon(poly);
            }
            if (this.m_text != null && this.m_textFont != null) {
                Rectangle2D rect = this.m_textFont.getStringBounds(this.m_text, g2d.getFontRenderContext());
                double wf = rect.getWidth();
                g.setFont(this.m_textFont);
                g.drawString(this.m_text, (int)(((double)(x1 + x2) - wf) / 2.0), y1 - m / 2);
            }
        }

        @Override
        public int getIconWidth() {
            return this.m_width;
        }

        @Override
        public int getIconHeight() {
            return this.m_height;
        }
    }

    public static interface InputVerifier {
        public boolean verify(Object var1);

        public String getName();
    }

    public static interface Listener {
        public void valueChanged(String var1, Object var2, Object var3);
    }

    public class NonEmptyNonExistingTextVerifier
    implements InputVerifier {
        InputVerifier iv = null;

        public NonEmptyNonExistingTextVerifier(String name) {
            this.iv = new NonEmptyTextVerifier(new NonExistingTextVerifier(name));
        }

        @Override
        public boolean verify(Object value) {
            return this.iv.verify(value);
        }

        @Override
        public String getName() {
            return this.iv.getName();
        }
    }

    public class NonEmptyTextVerifier
    implements InputVerifier {
        private String m_name = null;
        private InputVerifier m_verifyer = null;

        public NonEmptyTextVerifier(String name) {
            this.m_name = BasicUserForm.this._name(name);
        }

        public NonEmptyTextVerifier(InputVerifier verifyer) {
            this.m_name = verifyer.getName();
            this.m_verifyer = verifyer;
        }

        @Override
        public boolean verify(Object value) {
            if (value == null) {
                BasicUserForm.this.informError(String.valueOf(this.m_name) + Messages.getString("view.BasicUserForm.28"));
            } else if ("".equals(value)) {
                BasicUserForm.this.informError(String.valueOf(this.m_name) + Messages.getString("view.BasicUserForm.30"));
            } else {
                return this.m_verifyer == null ? true : this.m_verifyer.verify(value);
            }
            return false;
        }

        @Override
        public String getName() {
            return this.m_name;
        }
    }

    public class NonExistingNameVerifier
    implements InputVerifier {
        private String m_name = null;
        private String m_objName = null;
        private InputVerifier m_verifyer = null;

        public NonExistingNameVerifier(String name, String objName) {
            this.m_name = BasicUserForm.this._name(name);
            this.m_objName = objName;
            this.m_verifyer = new NonEmptyTextVerifier(name);
        }

        public NonExistingNameVerifier(InputVerifier verifyer) {
            this.m_name = verifyer.getName();
            this.m_verifyer = verifyer;
        }

        @Override
        public boolean verify(Object value) {
            if (this.m_objName != null) {
                if (this.m_objName.equals("NullLayer") && !"NullLayer".equals(value)) {
                    BasicUserForm.this.setValue(this.m_name, (Object)this.m_objName);
                    BasicUserForm.this.informError(Messages.getString("view.BasicUserForm.20"));
                } else if (!this.m_objName.equals("NullLayer") && !this.m_objName.equals(value) && BasicUserForm.this.m_krnl.getDatabase().getNameSpace().containsName(value.toString())) {
                    BasicUserForm.this.setValue(this.m_name, (Object)this.m_objName);
                    BasicUserForm.this.informError(String.valueOf(Messages.getString("view.BasicUserForm.22")) + value.toString() + Messages.getString("view.BasicUserForm.23"));
                } else {
                    return this.m_verifyer == null ? true : this.m_verifyer.verify(value);
                }
                return false;
            }
            if (!"NullLayer".equals(value) && !BasicUserForm.this.m_krnl.getDatabase().getNameSpace().containsName(value.toString())) {
                return this.m_verifyer == null ? true : this.m_verifyer.verify(value);
            }
            BasicUserForm.this.setValue(this.m_name, (Object)"");
            BasicUserForm.this.informError(String.valueOf(Messages.getString("view.BasicUserForm.26")) + value.toString() + Messages.getString("view.BasicUserForm.27"));
            return false;
        }

        @Override
        public String getName() {
            return this.m_name;
        }
    }

    public class NonExistingTextVerifier
    implements InputVerifier {
        private String m_name = null;
        private InputVerifier m_verifyer = null;

        public NonExistingTextVerifier(String name) {
            this.m_name = name;
        }

        public NonExistingTextVerifier(InputVerifier verifyer) {
            this.m_name = verifyer.getName();
            this.m_verifyer = verifyer;
        }

        @Override
        public boolean verify(Object value) {
            String name;
            NameSpace ns = BasicUserForm.this.m_krnl.getDatabase().getNameSpace();
            String string = name = value == null ? "" : value.toString();
            if (!ns.containsName(name)) {
                return this.m_verifyer == null ? true : this.m_verifyer.verify(value);
            }
            BasicUserForm.this.informError(String.valueOf(name) + Messages.getString("view.BasicUserForm.32") + ns.getObject(name).getClass().getName() + Messages.getString("view.BasicUserForm.33"));
            return false;
        }

        @Override
        public String getName() {
            return this.m_name;
        }
    }

    protected class ValueListener
    extends FocusAdapter {
        Object m_oldValue = null;

        protected ValueListener() {
        }

        @Override
        public void focusGained(FocusEvent arg0) {
            this.m_oldValue = BasicUserForm.this._getInput(arg0.getComponent());
        }

        @Override
        public void focusLost(FocusEvent arg0) {
            Component c = arg0.getComponent();
            Object value = BasicUserForm.this._getInput(c);
            String name = BasicUserForm.this.m_values.getKey(c);
            if (value == null && this.m_oldValue != null || !value.equals(this.m_oldValue)) {
                if (BasicUserForm.this.m_verifiers.containsKey(name)) {
                    InputVerifier iv = BasicUserForm.this.m_verifiers.get(name);
                    if (iv.verify(value)) {
                        BasicUserForm.this._notify(name, this.m_oldValue, value);
                    }
                } else {
                    BasicUserForm.this._notify(name, this.m_oldValue, value);
                }
            }
        }
    }
}

