/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.view;

import cib.cad.kernel.LayeredGraphics2D;
import cib.cad.kernel.View;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class ImageView
implements View {
    private static final Stroke BORDER_STROKE = new BasicStroke();
    private static final AffineTransform FLIP_X = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);
    private BufferedImage m_image = null;
    private AffineTransform m_trf = null;
    private double m_width = 0.0;
    private double m_height = 0.0;
    private Paint m_paint = Color.BLACK;
    private Stroke m_stroke = BORDER_STROKE;
    Point2D[] m_vertices = new Point2D[0];

    public ImageView(BufferedImage img, double width, double height, AffineTransform trf) {
        this.m_image = img;
        this.m_width = width;
        this.m_height = height;
        this.m_trf = trf;
        this.m_vertices = new Point2D[]{new Point2D.Double(0.0, 0.0), new Point2D.Double(this.m_width, 0.0), new Point2D.Double(this.m_width, this.m_height), new Point2D.Double(0.0, this.m_height)};
        int i = 0;
        while (i < this.m_vertices.length) {
            this.m_trf.transform(this.m_vertices[i], this.m_vertices[i]);
            ++i;
        }
    }

    public void setBorder(Stroke border) {
        this.m_stroke = border;
    }

    @Override
    public void draw(Graphics g) {
        LayeredGraphics2D lg = (LayeredGraphics2D)g;
        if (lg.setLayer("COMPONENT_GRAPHICS")) {
            this._draw(g, this.m_paint);
        }
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        int i = 0;
        while (i < this.m_vertices.length) {
            int j = (i + 1) % 4;
            if (r.intersectsLine(this.m_vertices[i].getX(), this.m_vertices[i].getY(), this.m_vertices[j].getX(), this.m_vertices[j].getY())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public Rectangle2D getBounds() {
        double minx = this.m_vertices[0].getX();
        double miny = this.m_vertices[0].getY();
        double maxx = this.m_vertices[0].getX();
        double maxy = this.m_vertices[0].getY();
        int i = 1;
        while (i < this.m_vertices.length) {
            double y;
            double x = this.m_vertices[i].getX();
            if (x < minx) {
                minx = x;
            }
            if (x > maxx) {
                maxx = x;
            }
            if ((y = this.m_vertices[i].getY()) < miny) {
                miny = y;
            }
            if (y > maxy) {
                maxy = y;
            }
            ++i;
        }
        return new Rectangle2D.Double(minx, miny, maxx - minx, maxy - miny);
    }

    private void _draw(Graphics _g, Paint p) {
        Graphics2D g = (Graphics2D)_g;
        if (this.m_image != null) {
            double scaleX = this.m_width / (double)this.m_image.getWidth();
            double scaleY = this.m_height / (double)this.m_image.getHeight();
            AffineTransform trf = new AffineTransform(this.m_trf);
            trf.scale(scaleX, scaleY);
            trf.translate(0.0, this.m_image.getHeight());
            trf.concatenate(FLIP_X);
            g.drawImage(this.m_image, trf, null);
        }
        g.setColor(Color.BLACK);
        g.setStroke(this.m_stroke);
        int i = 0;
        while (i < this.m_vertices.length) {
            int j = (i + 1) % 4;
            g.drawLine((int)this.m_vertices[i].getX(), (int)this.m_vertices[i].getY(), (int)this.m_vertices[j].getX(), (int)this.m_vertices[j].getY());
            ++i;
        }
    }
}

