/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.view.cmds;

import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UserInterface;
import cib.cad.lang.Messages;
import cib.cad.view.GraphicalUserInterface;
import cib.cad.view.cmds.AddCompToolBar;
import cib.cad.view.cmds.AddDimToolBar;
import cib.cad.view.cmds.AddDrawPaintToolBar;
import cib.cad.view.cmds.AddFileToolBar;
import cib.cad.view.cmds.AddFillPaintToolBar;
import cib.cad.view.cmds.AddFontFamilyToolBar;
import cib.cad.view.cmds.AddInfoToolBar;
import cib.cad.view.cmds.AddLayerToolBar;
import cib.cad.view.cmds.AddLinePatternToolBar;
import cib.cad.view.cmds.AddLineWidthToolBar;
import cib.cad.view.cmds.AddMacToolBar;
import cib.cad.view.cmds.AddMiscToolBar;
import cib.cad.view.cmds.AddModernToolBar;
import cib.cad.view.cmds.AddModifyToolBar;
import cib.cad.view.cmds.AddSelectToolBar;
import cib.cad.view.cmds.AddTextSizeToolBar;
import cib.cad.view.cmds.AddUndoToolBar;
import cib.cad.view.cmds.AddVisibilityToolBar;
import cib.cad.view.cmds.AddWindowToolBar;
import cib.util.cmd.CmdAbortedException;
import cib.util.cmd.CmdAdapter;
import cib.util.view.ViewUtilities;
import javax.swing.JPanel;

public class AddDefaultToolBars
extends CmdAdapter {
    private static final String PROP_TYPE = "AddDefaultToolBars.type";
    private int m_input = -1;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        String osVersion;
        String os = System.getProperty("os.name").toLowerCase();
        if (os.startsWith("mac os x") && (osVersion = System.getProperty("os.version")).startsWith("10.")) {
            int iSubVersion;
            String strSubVersion = osVersion.substring(3);
            int posDot = strSubVersion.indexOf(46);
            if (posDot > 0) {
                strSubVersion = strSubVersion.substring(0, posDot);
            }
            if ((iSubVersion = Integer.parseInt(strSubVersion)) > 4) {
                this.doCmdMac(context);
                return;
            }
        }
        this.doCmdStandard(context);
    }

    public void doCmdMac(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        final UserInterface ui = krnl.getUserInterface();
        String prop = krnl.getProperty(PROP_TYPE);
        CmdLineDialog dlg = ui.getCmdLineDialog();
        dlg.setPrompt("Select toolbar type");
        dlg.setDefaultChoice(dlg.addChoice("Mac"));
        dlg.addChoice("Modern");
        dlg.addChoice("Classic");
        dlg.addSeparator();
        dlg.addChoice("Off");
        dlg.addChoice("Restore");
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void choiceSelected(int iChoice) {
                AddDefaultToolBars.this.m_input = iChoice;
                ui.disposeCmdLineDialog();
            }

            @Override
            public void dialogAborted() {
                AddDefaultToolBars.this.m_input = -1;
                ui.disposeCmdLineDialog();
            }
        });
        ui.showCmdLineDialog(dlg);
        int _input = this.m_input;
        if (_input == 4) {
            try {
                _input = Integer.parseInt(prop);
            }
            catch (NumberFormatException e) {
                _input = 0;
            }
        }
        switch (_input) {
            case 0: {
                this._addMacToolBar(context);
                break;
            }
            case 1: {
                this._addModernToolBar(context);
                break;
            }
            case 2: {
                this._addClassicToolBar(context);
                break;
            }
            case 3: {
                this._removeToolBar(context);
                break;
            }
            default: {
                throw new CmdAbortedException();
            }
        }
        if (this.m_input == 4) {
            return;
        }
        if (krnl.readYesNo(Messages.getString("view.cmds.AddDefaultToolBars.0"), 18)) {
            krnl.setProperty(PROP_TYPE, Integer.toString(_input));
        } else {
            krnl.setProperty(PROP_TYPE, "");
        }
    }

    public void doCmdStandard(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        final UserInterface ui = krnl.getUserInterface();
        String prop = krnl.getProperty(PROP_TYPE);
        CmdLineDialog dlg = ui.getCmdLineDialog();
        dlg.setPrompt("Select toolbar type");
        dlg.setDefaultChoice(dlg.addChoice("Modern"));
        dlg.addChoice("Classic");
        dlg.addChoice("Off");
        dlg.addChoice("Restore");
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void choiceSelected(int iChoice) {
                AddDefaultToolBars.this.m_input = iChoice;
                ui.disposeCmdLineDialog();
            }

            @Override
            public void dialogAborted() {
                AddDefaultToolBars.this.m_input = -1;
                ui.disposeCmdLineDialog();
            }
        });
        ui.showCmdLineDialog(dlg);
        int _input = this.m_input;
        if (_input == 3) {
            try {
                _input = Integer.parseInt(prop);
            }
            catch (NumberFormatException e) {
                _input = 0;
            }
        }
        switch (_input) {
            case 0: {
                this._addModernToolBar(context);
                break;
            }
            case 1: {
                this._addClassicToolBar(context);
                break;
            }
            case 2: {
                this._removeToolBar(context);
                break;
            }
            default: {
                throw new CmdAbortedException();
            }
        }
        if (this.m_input == 3) {
            return;
        }
        if (krnl.readYesNo(Messages.getString("view.cmds.AddDefaultToolBars.1"), 18)) {
            krnl.setProperty(PROP_TYPE, Integer.toString(_input));
        } else {
            krnl.setProperty(PROP_TYPE, "");
        }
    }

    private void _removeToolBar(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        UserInterface ui = krnl.getUserInterface();
        GraphicalUserInterface gui = (GraphicalUserInterface)ui;
        JPanel tbp = gui.getToolBarPanel();
        if (tbp != null) {
            tbp.removeAll();
        }
        ViewUtilities.enableMenuIcons(false);
    }

    private void _addMacToolBar(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        UserInterface ui = krnl.getUserInterface();
        GraphicalUserInterface gui = (GraphicalUserInterface)ui;
        JPanel tbp = gui.getToolBarPanel();
        if (tbp != null) {
            tbp.removeAll();
        }
        new AddMacToolBar().doCmd(context);
    }

    private void _addClassicToolBar(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        UserInterface ui = krnl.getUserInterface();
        GraphicalUserInterface gui = (GraphicalUserInterface)ui;
        JPanel tbp = gui.getToolBarPanel();
        if (tbp != null) {
            tbp.removeAll();
        }
        new AddFileToolBar().doCmd(context);
        new AddUndoToolBar().doCmd(context);
        new AddSelectToolBar().doCmd(context);
        new AddCompToolBar().doCmd(context);
        new AddDimToolBar().doCmd(context);
        new AddModifyToolBar().doCmd(context);
        new AddMiscToolBar().doCmd(context);
        new AddInfoToolBar().doCmd(context);
        new AddWindowToolBar().doCmd(context);
        new AddLayerToolBar().doCmd(context);
        new AddLineWidthToolBar().doCmd(context);
        new AddLinePatternToolBar().doCmd(context);
        new AddDrawPaintToolBar().doCmd(context);
        new AddFillPaintToolBar().doCmd(context);
        new AddFontFamilyToolBar().doCmd(context);
        new AddTextSizeToolBar().doCmd(context);
        new AddVisibilityToolBar().doCmd(context);
    }

    private void _addModernToolBar(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        UserInterface ui = krnl.getUserInterface();
        GraphicalUserInterface gui = (GraphicalUserInterface)ui;
        JPanel tbp = gui.getToolBarPanel();
        if (tbp != null) {
            tbp.removeAll();
        }
        new AddModernToolBar().doCmd(context);
    }
}

