/*
 * Decompiled with CFR 0.152.
 */
package cib.util;

import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;

public class ExtendedMouseAdapter {
    private MouseInputListener m_mouseInputListener = new MouseInputAdapter(){
        private CheckHoldingThread m_holdThread = null;
        private CheckDoubleClickThread m_doubleClickThread = null;
        private int m_clickCount = -1;

        @Override
        public void mousePressed(MouseEvent e) {
            ExtendedMouseAdapter.this.mousePressed(e);
            if ((ExtendedMouseAdapter.this.m_eventFilter & 1) != 0) {
                this.m_holdThread = new CheckHoldingThread(e);
                this.m_holdThread.start();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.m_holdThread != null) {
                this.m_holdThread.setQuiet();
                this.m_holdThread = null;
            }
            ExtendedMouseAdapter.this.mouseReleased(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.m_clickCount >= 0) {
                e = new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getXOnScreen(), e.getYOnScreen(), this.m_clickCount, e.isPopupTrigger(), e.getButton());
            }
            this.m_clickCount = -1;
            if ((ExtendedMouseAdapter.this.m_eventFilter & 2) != 0) {
                if (e.getClickCount() == 0) {
                    if (this.m_doubleClickThread != null) {
                        this.m_doubleClickThread.setQuiet();
                        this.m_doubleClickThread = null;
                    }
                    ExtendedMouseAdapter.this.mouseClicked(e);
                } else if (e.getClickCount() == 1) {
                    if (this.m_doubleClickThread != null) {
                        this.m_doubleClickThread.setQuiet();
                    }
                    this.m_doubleClickThread = new CheckDoubleClickThread(e);
                    this.m_doubleClickThread.start();
                } else if (this.m_doubleClickThread != null) {
                    this.m_doubleClickThread.setMouseEvent(e);
                }
            } else if ((ExtendedMouseAdapter.this.m_eventFilter & 1) != 0) {
                ExtendedMouseAdapter.this.mouseClicked(e);
            } else {
                ExtendedMouseAdapter.this.mouseClicked(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            ExtendedMouseAdapter.this.mouseEntered(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            ExtendedMouseAdapter.this.mouseExited(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.m_holdThread != null) {
                this.m_holdThread.setQuiet();
                this.m_holdThread = null;
            }
            if (this.m_doubleClickThread != null) {
                this.m_doubleClickThread.setQuiet();
                this.m_doubleClickThread = null;
            }
            ExtendedMouseAdapter.this.mouseDragged(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (this.m_holdThread != null) {
                this.m_holdThread.setQuiet();
                this.m_holdThread = null;
            }
            if (this.m_doubleClickThread != null) {
                this.m_doubleClickThread.setQuiet();
                this.m_doubleClickThread = null;
            }
            ExtendedMouseAdapter.this.mouseMoved(e);
        }

        class CheckDoubleClickThread
        extends Thread {
            private static final long WAIT = 200L;
            private long m_startClicked = System.currentTimeMillis();
            private MouseEvent m_mouseEvent = null;

            public CheckDoubleClickThread(MouseEvent e) {
                this.m_mouseEvent = e;
            }

            public void setQuiet() {
                this.m_startClicked = -1L;
            }

            public void setMouseEvent(MouseEvent e) {
                this.m_mouseEvent = e;
            }

            @Override
            public void run() {
                block3: {
                    do {
                        try {
                            Thread.sleep(40L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (this.m_startClicked < 0L) break block3;
                    } while (System.currentTimeMillis() - this.m_startClicked <= 200L);
                    ExtendedMouseAdapter.this.mouseClicked(this.m_mouseEvent);
                }
            }
        }

        class CheckHoldingThread
        extends Thread {
            private static final long WAIT = 300L;
            private long m_startPressed = System.currentTimeMillis();
            private MouseEvent m_mouseEvent = null;

            public CheckHoldingThread(MouseEvent e) {
                this.m_mouseEvent = e;
            }

            public void setQuiet() {
                this.m_startPressed = -1L;
            }

            @Override
            public void run() {
                block3: {
                    do {
                        try {
                            Thread.sleep(60L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (this.m_startPressed < 0L) break block3;
                    } while (System.currentTimeMillis() - this.m_startPressed <= 300L);
                    ExtendedMouseAdapter.this.mouseHolding(this.m_mouseEvent);
                    m_clickCount = 0;
                }
            }
        }
    };
    public static final int HOLDING_EVENT = 1;
    public static final int MULTI_CLICKED_EVENT = 2;
    private int m_eventFilter = 0;

    ExtendedMouseAdapter() {
    }

    public ExtendedMouseAdapter(int filter) {
        this.m_eventFilter = filter;
    }

    public MouseInputListener asMouseInputListener() {
        return this.m_mouseInputListener;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseHolding(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }
}

