/*
 * Decompiled with CFR 0.152.
 */
package cib.util.coll;

import java.util.ListIterator;
import java.util.NoSuchElementException;

public class ListIteratorAdapter<E>
implements ListIterator<E> {
    private int m_index = 0;
    private int m_indexToSet = -1;

    public static <E> ListIterator<E> emptyListIterator() {
        return new ListIteratorAdapter<E>();
    }

    public static <E> ListIterator<E> singletonListIterator(E o) {
        return new _SingletonListIterator(o);
    }

    protected int _size() {
        return 0;
    }

    protected E _get(int index) {
        throw new IllegalArgumentException();
    }

    protected void _add(int index, E o) {
        throw new UnsupportedOperationException();
    }

    protected void _remove(int index) {
        throw new UnsupportedOperationException();
    }

    protected void _set(int index, E value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        return this.m_index < this._size();
    }

    @Override
    public boolean hasPrevious() {
        return this.m_index > 0;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.m_indexToSet = this.m_index;
        return this._get(this.m_index++);
    }

    @Override
    public E previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        this.m_indexToSet = --this.m_index;
        return this._get(this.m_index);
    }

    @Override
    public int nextIndex() {
        return this.m_index;
    }

    @Override
    public int previousIndex() {
        return this.m_index - 1;
    }

    @Override
    public void add(E o) {
        this._add(this.m_index, o);
        this.m_indexToSet = -1;
    }

    @Override
    public void remove() {
        if (this.m_indexToSet == -1) {
            throw new IllegalStateException();
        }
        this._remove(this.m_indexToSet);
        this.m_indexToSet = -1;
    }

    @Override
    public void set(E o) {
        if (this.m_indexToSet == -1) {
            throw new IllegalStateException();
        }
        this._set(this.m_indexToSet, o);
    }

    private static class _SingletonListIterator<E>
    extends ListIteratorAdapter<E> {
        private E m_obj = null;

        private _SingletonListIterator(E obj) {
            this.m_obj = obj;
        }

        @Override
        protected int _size() {
            return 1;
        }

        @Override
        protected E _get(int index) {
            return this.m_obj;
        }
    }
}

