/*
 * Decompiled with CFR 0.152.
 */
package cib.util.coll;

import cib.util.coll.IteratorFilter;
import cib.util.coll._FilterableListIterator;
import java.awt.Point;
import java.util.LinkedList;
import java.util.ListIterator;

class _MultiFilterableListIterator<E>
extends _FilterableListIterator<E>
implements ListIterator<E> {
    private IteratorFilter<E>[] m_filters;
    private int internalCounter = 0;

    protected _MultiFilterableListIterator(ListIterator<E> iterator, IteratorFilter<E>[] filters) {
        super(iterator);
        if (filters.length == 0) {
            throw new RuntimeException("need atleast one filter!");
        }
        this.m_filters = filters;
        this.m_filter = filters[0];
        this.filterNext();
    }

    @Override
    protected void filterNext() {
        while (this.internalCounter < this.m_filters.length) {
            super.filterNext();
            if (this.hasNext || this.internalCounter >= this.m_filters.length - 1) break;
            ++this.internalCounter;
            this.m_filter = this.m_filters[this.internalCounter];
            this.toStart();
        }
    }

    @Override
    protected void filterPrevious() {
        while (this.internalCounter >= 0) {
            super.filterPrevious();
            if (this.hasPrevious || this.internalCounter <= 0) break;
            --this.internalCounter;
            this.m_filter = this.m_filters[this.internalCounter];
            this.toEnd();
        }
    }

    private void toStart() {
        while (this.m_iter.hasPrevious()) {
            this.m_iter.previous();
        }
    }

    private void toEnd() {
        while (this.m_iter.hasNext()) {
            this.m_iter.next();
        }
    }

    public static void main(String[] args) {
        LinkedList<Object> testList = new LinkedList<Object>();
        testList.add(new Integer(0));
        testList.add("A");
        testList.add("B");
        testList.add(new Integer(3));
        testList.add(new Double(4.0));
        testList.add("E");
        testList.add("F");
        testList.add(new Integer(7));
        System.out.println(testList);
        IteratorFilter[] filter = new IteratorFilter[]{new IteratorFilter<Object>(){

            @Override
            public boolean matches(Object o) {
                return o instanceof Integer;
            }

            public String toString() {
                return "Integer";
            }
        }, new IteratorFilter<Object>(){

            @Override
            public boolean matches(Object o) {
                return o instanceof String;
            }

            public String toString() {
                return "String";
            }
        }, new IteratorFilter<Object>(){

            @Override
            public boolean matches(Object o) {
                return o instanceof Integer;
            }

            public String toString() {
                return "Integer";
            }
        }, new IteratorFilter<Object>(){

            @Override
            public boolean matches(Object o) {
                return o instanceof Point;
            }

            public String toString() {
                return "Point";
            }
        }, new IteratorFilter<Object>(){

            @Override
            public boolean matches(Object o) {
                return o instanceof Double;
            }

            public String toString() {
                return "Double";
            }
        }};
        _MultiFilterableListIterator i = new _MultiFilterableListIterator(testList.listIterator(), filter);
        System.out.print("[" + i.previousIndex() + "|" + i.nextIndex() + "]->");
        while (i.hasNext()) {
            System.out.print(" " + i.next() + "<-[" + i.previousIndex() + "|" + i.nextIndex() + "]->");
        }
        System.out.print("[" + i.previousIndex() + "]" + "[" + i.nextIndex() + "]->");
        System.out.println("\n");
        System.out.print("[" + i.previousIndex() + "|" + i.nextIndex() + "]->");
        while (i.hasPrevious()) {
            System.out.print(" " + i.previous() + "<-[" + i.previousIndex() + "|" + i.nextIndex() + "]->");
        }
        System.out.print("[" + i.previousIndex() + "|" + i.nextIndex() + "]->");
        System.out.println("\n");
    }
}

