/*
 * Decompiled with CFR 0.152.
 */
package cib.util.coll;

import cib.util.ObservableObject;
import cib.util.coll.ObservableSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class _ObservableSet<E>
implements ObservableSet<E>,
Serializable {
    private static final long serialVersionUID = 0L;
    protected Set<E> m_observedSet = null;
    protected Set<ObservableSet.Listener<E>> m_listeners = new HashSet<ObservableSet.Listener<E>>();
    protected ObservableObject.Listener m_objectListener = null;

    protected _ObservableSet(Set<E> set) {
        if (set == null) {
            throw new IllegalArgumentException();
        }
        this.m_observedSet = set;
        this.m_objectListener = new ObservableObject.Listener(){
            private static final long serialVersionUID = 0L;

            @Override
            public void wasChanged(ObservableObject oo) {
                for (ObservableSet.Listener<ObservableObject> listener : _ObservableSet.this.m_listeners) {
                    listener.wasChanged(oo);
                }
            }

            @Override
            public void wasCloned(ObservableObject src, ObservableObject dst) {
                for (ObservableSet.Listener<ObservableObject> listener : _ObservableSet.this.m_listeners) {
                    listener.wasCloned(src, dst);
                }
            }
        };
    }

    @Override
    public Set<E> getObservedSet() {
        return this.m_observedSet;
    }

    @Override
    public boolean addListener(ObservableSet.Listener<E> l) {
        return this.m_listeners.add(l);
    }

    @Override
    public boolean removeListener(ObservableSet.Listener<E> l) {
        return this.m_listeners.remove(l);
    }

    @Override
    public void clearListeners() {
        this.m_listeners.clear();
    }

    @Override
    public Iterator<ObservableSet.Listener<E>> listenerIterator() {
        return this.m_listeners.iterator();
    }

    @Override
    public void wasChanged(E e) {
        for (ObservableSet.Listener<E> osl : this.m_listeners) {
            osl.wasChanged(e);
        }
    }

    @Override
    public void wasCloned(E src, E dst) {
        for (ObservableSet.Listener<E> osl : this.m_listeners) {
            osl.wasCloned(src, dst);
        }
    }

    @Override
    public boolean add(E e) {
        if (!this.m_observedSet.add(e)) {
            return false;
        }
        for (ObservableSet.Listener<E> osl : this.m_listeners) {
            osl.wasAdded(e);
        }
        if (e instanceof ObservableObject) {
            ObservableObject oo = (ObservableObject)e;
            oo.addListener(this.m_objectListener);
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        HashSet<E> set = new HashSet<E>(c);
        set.removeAll(this.m_observedSet);
        if (!this.m_observedSet.addAll(c)) {
            return false;
        }
        for (ObservableSet.Listener<E> osl : this.m_listeners) {
            for (E e : set) {
                osl.wasAdded(e);
            }
        }
        for (Object e : set) {
            if (!(e instanceof ObservableObject)) continue;
            ObservableObject oo = (ObservableObject)e;
            oo.addListener(this.m_objectListener);
        }
        return true;
    }

    @Override
    public void clear() {
        this.removeAll(this.m_observedSet);
    }

    @Override
    public boolean contains(Object o) {
        return this.m_observedSet.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.m_observedSet.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return this.m_observedSet.equals(o);
    }

    @Override
    public int hashCode() {
        return this.m_observedSet.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.m_observedSet.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        final Iterator<E> it = this.m_observedSet.iterator();
        return new Iterator<E>(){
            private E m_currentElement = null;

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public E next() {
                this.m_currentElement = it.next();
                return this.m_currentElement;
            }

            @Override
            public void remove() {
                boolean containsObject = _ObservableSet.this.m_observedSet.contains(this.m_currentElement);
                it.remove();
                if (containsObject) {
                    for (ObservableSet.Listener osl : _ObservableSet.this.m_listeners) {
                        osl.wasRemoved(this.m_currentElement);
                    }
                    if (this.m_currentElement instanceof ObservableObject) {
                        ObservableObject oo = (ObservableObject)this.m_currentElement;
                        oo.removeListener(_ObservableSet.this.m_objectListener);
                    }
                }
            }
        };
    }

    @Override
    public boolean remove(Object o) {
        if (!this.m_observedSet.remove(o)) {
            return false;
        }
        for (ObservableSet.Listener<Object> listener : this.m_listeners) {
            listener.wasRemoved(o);
        }
        if (o instanceof ObservableObject) {
            ObservableObject observableObject = (ObservableObject)o;
            observableObject.removeListener(this.m_objectListener);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        HashSet<E> set = new HashSet<E>(c);
        set.retainAll(this.m_observedSet);
        if (!this.m_observedSet.removeAll(c)) {
            return false;
        }
        for (ObservableSet.Listener<?> listener : this.m_listeners) {
            for (Object object : set) {
                listener.wasRemoved(object);
            }
        }
        for (ObservableSet.Listener<Object> listener : set) {
            if (!(listener instanceof ObservableObject)) continue;
            ObservableObject oo = (ObservableObject)((Object)listener);
            oo.removeListener(this.m_objectListener);
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        HashSet<E> set = new HashSet<E>(this.m_observedSet);
        set.removeAll(c);
        if (!this.m_observedSet.retainAll(c)) {
            return false;
        }
        for (ObservableSet.Listener<E> osl : this.m_listeners) {
            for (E e : set) {
                osl.wasRemoved(e);
            }
        }
        for (Object e : set) {
            if (!(e instanceof ObservableObject)) continue;
            ObservableObject oo = (ObservableObject)e;
            oo.removeListener(this.m_objectListener);
        }
        return true;
    }

    @Override
    public int size() {
        return this.m_observedSet.size();
    }

    @Override
    public Object[] toArray() {
        return this.m_observedSet.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.m_observedSet.toArray(a);
    }

    public String toString() {
        return this.m_observedSet.toString();
    }
}

