/*
 * Decompiled with CFR 0.152.
 */
package cib.util.view;

import cib.util.AttributedImage;
import cib.util.AttributedShape;
import cib.util.AttributedText;
import cib.util.CoordSpace;
import cib.util.geo.Geo2D;
import cib.util.view.FillPaint;
import cib.util.view.Projection2D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DeviceRenderer {
    private static final AffineTransform TEXT_TRF = new AffineTransform();
    private static final Stroke DEFAULT_STROKE = new BasicStroke(0.0f, 1, 1, 0.0f, null, 0.0f);
    private List<Object> m_objectsToDraw = new ArrayList<Object>();
    private Projection2D m_projection = null;
    private double m_scale = 1.0;
    public static final double PT_PER_IN = 72.0;
    public static final double IN_PER_M = 39.37;
    private static final AffineTransform FLIP_X = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);

    static {
        double SCALE = 3.5277848333474445E-4;
        TEXT_TRF.preConcatenate(AffineTransform.getScaleInstance(3.5277848333474445E-4, 3.5277848333474445E-4));
        TEXT_TRF.preConcatenate(FLIP_X);
    }

    public DeviceRenderer(Projection2D projection, double scale) {
        if (projection == null) {
            throw new IllegalArgumentException();
        }
        this.m_projection = projection;
        this.m_scale = scale;
    }

    public double getScale() {
        return this.m_scale;
    }

    public Projection2D getProjection() {
        return this.m_projection;
    }

    public double inPerNaturalUnit() {
        CoordSpace cs = CoordSpace.getCoordSpace();
        return 39.37 * cs.getMillimetersPerNaturalUnit() / 1000.0;
    }

    public void addShape(AttributedShape shape) {
        this.m_objectsToDraw.add(shape);
    }

    public void addText(AttributedText text) {
        this.m_objectsToDraw.add(text);
    }

    public void addImage(AttributedImage image) {
        this.m_objectsToDraw.add(image);
    }

    protected final void _render(Graphics2D g) {
        for (Object obj : this.m_objectsToDraw) {
            if (obj instanceof AttributedShape) {
                this._render((AttributedShape)obj, g);
                continue;
            }
            if (obj instanceof AttributedText) {
                this._render((AttributedText)obj, g);
                continue;
            }
            if (!(obj instanceof AttributedImage)) continue;
            this._render((AttributedImage)obj, g);
        }
    }

    private void _render(AttributedShape as, Graphics2D g) {
        this.draw(g, as, false);
    }

    private void _render(AttributedText _at, Graphics2D g) {
        int i;
        FontRenderContext frc = g.getFontRenderContext();
        AttributedText at = (AttributedText)_at.clone();
        AttributedString as = at.getAttributedString();
        AttributedCharacterIterator aci = as.getIterator();
        boolean emptyText = aci.getRunLimit() == 0;
        double scaleInTextDirection = at.getScaleInTextDirection();
        TextLayout[] layouts = null;
        double boundingHeight = 0.0;
        double boundingWidth = 0.0;
        double dx = 0.0;
        double dy = 0.0;
        double textScale = 1.0;
        if (!emptyText) {
            double maxHeight = 0.0;
            int runLimit = 0;
            while (aci.setIndex(runLimit) != '\uffff') {
                double height;
                runLimit = aci.getRunLimit();
                Map<AttributedCharacterIterator.Attribute, Object> map = aci.getAttributes();
                Object value = map.get(TextAttribute.SIZE);
                if (value == null || !(value instanceof Number) || !((height = ((Number)value).doubleValue()) > maxHeight)) continue;
                maxHeight = height;
            }
            double MAX_TEXT_SIZE = 1000.0;
            double OPT_TEXT_SIZE = 1000.0;
            double MIN_TEXT_SIZE = 5.0;
            if (maxHeight > 1000.0 || maxHeight < 5.0) {
                textScale = 1000.0 / maxHeight;
                runLimit = 0;
                while (aci.setIndex(runLimit) != '\uffff') {
                    int runStart = aci.getIndex();
                    runLimit = aci.getRunLimit();
                    Map<AttributedCharacterIterator.Attribute, Object> map = aci.getAttributes();
                    Object value = map.get(TextAttribute.SIZE);
                    if (value == null || !(value instanceof Number)) continue;
                    double height = ((Number)value).doubleValue();
                    as.addAttribute(TextAttribute.SIZE, new Float(height * textScale), runStart, runLimit);
                }
            }
            ArrayList<Integer> lineBreakPositions = new ArrayList<Integer>();
            AttributedCharacterIterator cit = as.getIterator();
            char chr = cit.first();
            while (chr != '\uffff') {
                if (chr == '\n') {
                    int index = cit.getIndex();
                    lineBreakPositions.add(new Integer(index));
                }
                chr = cit.next();
            }
            layouts = new TextLayout[lineBreakPositions.size() + 1];
            int i2 = 0;
            while (i2 < layouts.length) {
                int beginIndex = i2 == 0 ? 0 : (Integer)lineBreakPositions.get(i2 - 1) + 1;
                int endIndex = i2 == layouts.length - 1 ? cit.getEndIndex() : ((Integer)lineBreakPositions.get(i2)).intValue();
                layouts[i2] = null;
                if (beginIndex != endIndex) {
                    AttributedCharacterIterator acit = as.getIterator(null, beginIndex, endIndex);
                    layouts[i2] = new TextLayout(acit, frc);
                }
                ++i2;
            }
            double ascent = layouts[0] == null ? 0.0f : layouts[0].getAscent();
            boundingHeight = 0.0;
            boundingWidth = 0.0;
            int nEmptyLines = 0;
            i = 0;
            while (i < layouts.length) {
                if (layouts[i] == null) {
                    ++nEmptyLines;
                } else {
                    boundingHeight += (double)(layouts[i].getAscent() + layouts[i].getDescent());
                    if ((double)layouts[i].getAdvance() > boundingWidth) {
                        boundingWidth = layouts[i].getAdvance();
                    }
                }
                ++i;
            }
            int nNotEmptyLines = layouts.length - nEmptyLines;
            int avgLineHeight = nNotEmptyLines == 0 ? 0 : (int)Math.round(boundingHeight / (double)nNotEmptyLines);
            int i3 = 0;
            while (i3 < layouts.length) {
                if (layouts[i3] == null) {
                    layouts[i3] = new TextLayout(" ", new Font("SansSerif", 0, avgLineHeight), frc);
                }
                ++i3;
            }
            boundingWidth *= scaleInTextDirection;
            switch (at.getJustification()) {
                case 0: {
                    dx = 0.0;
                    dy = 0.0;
                    break;
                }
                case 9: {
                    dx = 0.0;
                    dy = ascent - boundingHeight;
                    break;
                }
                case 1: {
                    dx = 0.0;
                    dy = lineBreakPositions.isEmpty() ? 0.5 * ascent : ascent - 0.5 * boundingHeight;
                    break;
                }
                case 2: {
                    dx = 0.0;
                    dy = ascent;
                    break;
                }
                case 3: {
                    dx = -0.5 * boundingWidth;
                    dy = 0.0;
                    break;
                }
                case 10: {
                    dx = -0.5 * boundingWidth;
                    dy = ascent - boundingHeight;
                    break;
                }
                case 4: {
                    dx = -0.5 * boundingWidth;
                    dy = lineBreakPositions.isEmpty() ? 0.5 * ascent : ascent - 0.5 * boundingHeight;
                    break;
                }
                case 5: {
                    dx = -0.5 * boundingWidth;
                    dy = ascent;
                    break;
                }
                case 6: {
                    dx = -boundingWidth;
                    dy = 0.0;
                    break;
                }
                case 11: {
                    dx = -boundingWidth;
                    dy = ascent - boundingHeight;
                    break;
                }
                case 7: {
                    dx = -boundingWidth;
                    dy = lineBreakPositions.isEmpty() ? 0.5 * ascent : ascent - 0.5 * boundingHeight;
                    break;
                }
                case 8: {
                    dx = -boundingWidth;
                    dy = ascent;
                    break;
                }
                default: {
                    dx = 0.0;
                    dy = 0.0;
                }
            }
        }
        AffineTransform trf = AffineTransform.getScaleInstance(scaleInTextDirection, 1.0);
        trf.preConcatenate(AffineTransform.getTranslateInstance(dx, dy));
        trf.preConcatenate(AffineTransform.getScaleInstance(1.0 / textScale, 1.0 / textScale));
        trf.preConcatenate(TEXT_TRF);
        AffineTransform atTrf = at.getTransform();
        int flags = atTrf.getType() & 6;
        if (flags == 2 || flags == 4) {
            Point2D.Double o = new Point2D.Double();
            Point2D.Double x = new Point2D.Double(1.0, 0.0);
            Point2D.Double y = new Point2D.Double(0.0, 1.0);
            Point2D o_ = atTrf.transform(o, null);
            Point2D x_ = atTrf.transform(x, null);
            Point2D y_ = atTrf.transform(y, null);
            double scx = 1.0 / Geo2D.distance(o_, x_);
            double scy = 1.0 / Geo2D.distance(o_, y_);
            trf.preConcatenate(AffineTransform.getScaleInstance(scx, scy));
        }
        trf.preConcatenate(atTrf);
        double trfNrmX = trf.getTranslateX();
        double trfNrmY = trf.getTranslateY();
        trf.preConcatenate(AffineTransform.getTranslateInstance(-trfNrmX, -trfNrmY));
        Shape shape = null;
        if (layouts == null || layouts.length == 0) {
            shape = trf.createTransformedShape(new Ellipse2D.Double(-200.0, -200.0, 400.0, 400.0));
        } else {
            Shape _shape = layouts[0].getOutline(trf);
            Path2D.Double path = new Path2D.Double(_shape);
            double tx = 0.0;
            double ty = 0.0;
            i = 1;
            while (i < layouts.length) {
                AffineTransform trfText = AffineTransform.getTranslateInstance(tx, ty += (double)(layouts[i].getAscent() + layouts[i].getDescent()));
                trfText.preConcatenate(trf);
                _shape = layouts[i].getOutline(trfText);
                path.append(_shape, false);
                ++i;
            }
            shape = path;
        }
        AffineTransform trfBack = AffineTransform.getTranslateInstance(trfNrmX, trfNrmY);
        shape = trfBack.createTransformedShape(shape);
        AttributedShape attributedShape = new AttributedShape(shape, null, at.getDrawPaint(), at.getDrawPaint());
        this.draw(g, attributedShape, true);
    }

    private void _render(AttributedImage ai, Graphics2D g) {
        AffineTransform modelToView = this.m_projection.getModelToView();
        AffineTransform trf = ai.getTransform();
        trf.preConcatenate(modelToView);
        BufferedImage image = ai.getImage();
        double scaleX = ai.getWidth() / (double)image.getWidth();
        double scaleY = ai.getHeight() / (double)image.getHeight();
        AffineTransform _trf = new AffineTransform(trf);
        _trf.scale(scaleX, scaleY);
        _trf.translate(0.0, image.getHeight());
        _trf.concatenate(FLIP_X);
        g.drawImage(image, _trf, null);
    }

    private void draw(Graphics2D g, AttributedShape shape, boolean isText) {
        Paint drawPaint;
        AffineTransform modelToView = this.m_projection.getModelToView();
        Rectangle2D r2D = shape.getBounds2D();
        Shape r2DT = modelToView.createTransformedShape(r2D);
        Rectangle r = r2DT.getBounds();
        if (!g.hitClip(r.x, r.y, r.width, r.height)) {
            return;
        }
        Shape shapeT = modelToView.createTransformedShape(shape);
        Paint fill = shape.getFillPaint();
        if (fill != null) {
            Shape shapeFill = shapeT;
            AffineTransform compensateMacOSbug = AffineTransform.getTranslateInstance(this._getFillOffsetX(), this._getFillOffsetY());
            shapeFill = compensateMacOSbug.createTransformedShape(shapeT);
            if (fill instanceof FillPaint) {
                ((FillPaint)fill).setModelToView(modelToView);
            } else if (fill instanceof Color && fill.equals(Color.WHITE)) {
                fill = Color.black;
            }
            g.setPaint(fill);
            g.fill(shapeFill);
        }
        if ((drawPaint = shape.getDrawPaint()) == null) {
            drawPaint = Color.black;
        } else if (drawPaint instanceof Color && drawPaint.equals(Color.WHITE)) {
            drawPaint = Color.black;
        }
        g.setPaint(drawPaint);
        Stroke stroke = shape.getStroke();
        if (stroke == null) {
            stroke = DEFAULT_STROKE;
        }
        if (stroke instanceof BasicStroke) {
            float m2vScale = (float)modelToView.getScaleX();
            BasicStroke basicStroke = (BasicStroke)stroke;
            float width = basicStroke.getLineWidth() * m2vScale;
            int cap = basicStroke.getEndCap();
            int join = basicStroke.getLineJoin();
            float miterlimit = basicStroke.getMiterLimit() * m2vScale;
            float[] dash = basicStroke.getDashArray();
            if (dash != null) {
                int i = 0;
                while (i < dash.length) {
                    int n = i;
                    dash[n] = dash[n] * m2vScale;
                    if (dash[i] < 1.0f) {
                        dash[i] = 1.0f;
                    }
                    ++i;
                }
            }
            float dash_phase = basicStroke.getDashPhase() * m2vScale;
            g.setStroke(new BasicStroke(width, cap, join, miterlimit, dash, dash_phase));
        }
        g.draw(shapeT);
    }

    protected double _getFillOffsetX() {
        return 0.0;
    }

    protected double _getFillOffsetY() {
        return 0.0;
    }
}

