/*
 * Decompiled with CFR 0.152.
 */
package cib.util.view;

import cib.util.CoordSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;

public class Projection2D
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 0L;
    public static final int BORDER = 10;
    private Point2D m_vrp = new Point2D.Double(0.0, 0.0);
    private Point2D m_vup = new Point2D.Double(0.0, 1.0);
    private Rectangle2D m_viewPort = new Rectangle2D.Double(-1.0, -1.0, 10.0, 10.0);
    private double m_deviceWidth = 100.0;
    private double m_deviceHeight = 100.0;
    private transient double m_deviceDX = 0.0;
    private transient double m_deviceDY = 0.0;
    private AffineTransform m_modelToView = new AffineTransform();
    private AffineTransform m_viewToModel = new AffineTransform();

    private Projection2D() {
    }

    public Projection2D(Rectangle2D viewPort, double deviceWidth, double deviceHeight) throws NoninvertibleTransformException {
        this.setViewPort(viewPort);
        this.setDeviceDimensions(deviceWidth, deviceHeight);
        this.setProjection();
    }

    public Object clone() {
        Projection2D clone = new Projection2D();
        clone.m_vrp = new Point2D.Double(this.m_vrp.getX(), this.m_vrp.getY());
        clone.m_vup = new Point2D.Double(this.m_vup.getX(), this.m_vup.getY());
        clone.m_viewPort = new Rectangle2D.Double(this.m_viewPort.getX(), this.m_viewPort.getY(), this.m_viewPort.getWidth(), this.m_viewPort.getHeight());
        clone.m_deviceWidth = this.m_deviceWidth;
        clone.m_deviceHeight = this.m_deviceHeight;
        clone.m_deviceDX = this.m_deviceDX;
        clone.m_deviceDY = this.m_deviceDY;
        clone.m_modelToView = new AffineTransform(this.m_modelToView);
        clone.m_viewToModel = new AffineTransform(this.m_viewToModel);
        return clone;
    }

    public void setProjection() throws NoninvertibleTransformException {
        Rectangle2D vp = this.getViewPort();
        double sb = Math.min(this.m_deviceWidth / vp.getWidth(), this.m_deviceHeight / vp.getHeight());
        double delta = 10.0 / sb;
        Rectangle2D.Double viewPort = new Rectangle2D.Double(vp.getX() - delta, vp.getY() - delta, vp.getWidth() + delta + delta, vp.getHeight() + delta + delta);
        AffineTransform at = AffineTransform.getTranslateInstance(-this.getVrpX(), -this.getVrpY());
        double angle = Math.asin(this.m_vup.getX() / this.m_vup.distance(0.0, 0.0));
        at.preConcatenate(AffineTransform.getRotateInstance(angle));
        double umin = ((RectangularShape)viewPort).getX();
        double vmax = ((RectangularShape)viewPort).getY() + ((RectangularShape)viewPort).getHeight();
        at.preConcatenate(AffineTransform.getTranslateInstance(-umin, -vmax));
        AffineTransform MIRROR_X_TRF = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);
        at.preConcatenate(MIRROR_X_TRF);
        double s = Math.min(this.m_deviceWidth / ((RectangularShape)viewPort).getWidth(), this.m_deviceHeight / ((RectangularShape)viewPort).getHeight());
        at.preConcatenate(AffineTransform.getScaleInstance(s, s));
        double deviceRatio = this.m_deviceWidth / this.m_deviceHeight;
        double viewPortRatio = ((RectangularShape)viewPort).getWidth() / ((RectangularShape)viewPort).getHeight();
        if (deviceRatio < viewPortRatio) {
            double dx = 0.0;
            double ih = this.m_deviceWidth / viewPortRatio;
            double dy = 0.5 * (this.m_deviceHeight - ih);
            this.m_deviceDX = dx;
            this.m_deviceDY = dy += 0.5;
            at.preConcatenate(AffineTransform.getTranslateInstance(dx, dy));
        } else {
            double dy = 0.0;
            double iw = this.m_deviceHeight * viewPortRatio;
            double dx = 0.5 * (this.m_deviceWidth - iw);
            this.m_deviceDX = dx += 0.5;
            this.m_deviceDY = dy;
            at.preConcatenate(AffineTransform.getTranslateInstance(dx, dy));
        }
        this.m_modelToView = at;
        this.m_viewToModel = this.m_modelToView.createInverse();
    }

    public AffineTransform getModelToView() {
        return (AffineTransform)this.m_modelToView.clone();
    }

    public AffineTransform getViewToModel() {
        return (AffineTransform)this.m_viewToModel.clone();
    }

    public void setVrp(double x, double y) {
        this.m_vrp.setLocation(this._toMeter(x), this._toMeter(y));
    }

    public void setVrp(Point2D vrp) {
        this.setVrp(vrp.getX(), vrp.getY());
    }

    public Point2D getVrp() {
        return new Point2D.Double(this.getVrpX(), this.getVrpY());
    }

    public double getVrpX() {
        return this._toNU(this.m_vrp.getX());
    }

    public double getVrpY() {
        return this._toNU(this.m_vrp.getY());
    }

    public void setVup(double x, double y) {
        this.m_vup.setLocation(x, y);
    }

    public void setVup(Point2D vup) {
        this.m_vup.setLocation(vup);
    }

    public Point2D getVup() {
        return (Point2D)this.m_vup.clone();
    }

    public double getVupX() {
        return this.m_vup.getX();
    }

    public double getVupY() {
        return this.m_vup.getY();
    }

    public boolean setViewPort(double x, double y, double w, double h) {
        if (w < Double.MIN_VALUE && h < Double.MIN_VALUE) {
            return false;
        }
        if (w < Double.MIN_VALUE) {
            w = 0.1 * h;
            x -= 0.5 * w;
        } else if (h < Double.MIN_VALUE) {
            h = 0.1 * w;
            y -= 0.5 * h;
        }
        this.m_viewPort.setRect(this._toMeter(x), this._toMeter(y), this._toMeter(w), this._toMeter(h));
        return true;
    }

    public boolean setViewPort(Rectangle2D viewPort) {
        return this.setViewPort(viewPort.getX(), viewPort.getY(), viewPort.getWidth(), viewPort.getHeight());
    }

    public Rectangle2D getViewPort() {
        return new Rectangle2D.Double(this._toNU(this.m_viewPort.getX()), this._toNU(this.m_viewPort.getY()), this._toNU(this.m_viewPort.getWidth()), this._toNU(this.m_viewPort.getHeight()));
    }

    public double getMinU() {
        return this._toNU(this.m_viewPort.getX());
    }

    public double getMinV() {
        return this._toNU(this.m_viewPort.getY());
    }

    public double getMaxU() {
        return this._toNU(this.m_viewPort.getX() + this.m_viewPort.getWidth());
    }

    public double getMaxV() {
        return this._toNU(this.m_viewPort.getY() + this.m_viewPort.getHeight());
    }

    public void setDeviceDimensions(double width, double height) {
        if (width < 1.0 || height < 1.0) {
            throw new IllegalArgumentException();
        }
        this.m_deviceWidth = width;
        this.m_deviceHeight = height;
    }

    public double getDeviceWidth() {
        return this.m_deviceWidth;
    }

    public double getDeviceHeight() {
        return this.m_deviceHeight;
    }

    public double getDeviceDX() {
        return this.m_deviceDX;
    }

    public double getDeviceDY() {
        return this.m_deviceDY;
    }

    private double _mPerNU() {
        CoordSpace cs = CoordSpace.getCoordSpace();
        return cs != null ? 0.001 * cs.getMillimetersPerNaturalUnit() : 1.0;
    }

    private double _toMeter(double inNU) {
        return inNU * this._mPerNU();
    }

    private double _toNU(double inM) {
        return inM / this._mPerNU();
    }
}

