/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swingframework.ruler;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import org.diylc.swingframework.IDrawingProvider;

public class NavigateDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final int MAX_SIZE = 192;
    private GraphicsConfiguration screenGraphicsConfiguration;
    private IDrawingProvider provider;

    public NavigateDialog(JScrollPane scrollPane, IDrawingProvider provider) {
        this.provider = provider;
        this.setAlwaysOnTop(true);
        this.setUndecorated(true);
        this.setCursor(Cursor.getPredefinedCursor(1));
        this.requestFocus();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] devices = graphicsEnvironment.getScreenDevices();
        this.screenGraphicsConfiguration = devices[0].getDefaultConfiguration();
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                NavigateDialog.this.setVisible(false);
            }
        });
        DrawComponent drawComponent = new DrawComponent(scrollPane);
        this.add(drawComponent);
        this.pack();
    }

    class DrawComponent
    extends JComponent {
        private static final long serialVersionUID = 1L;
        private final JScrollPane scrollPane;
        private BufferedImage thumbnailImage;
        private VolatileImage bufferImage;
        double scaleRatio;

        public DrawComponent(JScrollPane scrollPane) {
            this.scrollPane = scrollPane;
            final Dimension dim = NavigateDialog.this.provider.getSize();
            this.scaleRatio = dim.width > dim.height ? 192.0 / (double)dim.width : 192.0 / (double)dim.height;
            int width = (int)((double)dim.width * this.scaleRatio);
            int height = (int)((double)dim.height * this.scaleRatio);
            this.setPreferredSize(new Dimension(width, height));
            this.thumbnailImage = new BufferedImage(width, height, 1);
            Graphics2D g2d = this.thumbnailImage.createGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            NavigateDialog.this.provider.draw(0, g2d, this.scaleRatio);
            g2d.setTransform(new AffineTransform());
            g2d.setColor(Color.lightGray);
            g2d.drawRect(0, 0, width - 1, height - 1);
            g2d.dispose();
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    DrawComponent.this.repaint();
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    DrawComponent.this.repaint();
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent e) {
                    NavigateDialog.this.setVisible(false);
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    int y;
                    int x = (int)((double)DrawComponent.this.getMousePosition().x / DrawComponent.this.scaleRatio - (double)(((DrawComponent)DrawComponent.this).scrollPane.getVisibleRect().width / 2));
                    if (x > dim.width - ((DrawComponent)DrawComponent.this).scrollPane.getViewport().getVisibleRect().width - 1) {
                        x = dim.width - ((DrawComponent)DrawComponent.this).scrollPane.getViewport().getVisibleRect().width - 1;
                    }
                    if (x < 0) {
                        x = 0;
                    }
                    if ((y = (int)((double)DrawComponent.this.getMousePosition().y / DrawComponent.this.scaleRatio - (double)(((DrawComponent)DrawComponent.this).scrollPane.getVisibleRect().height / 2))) > dim.height - ((DrawComponent)DrawComponent.this).scrollPane.getViewport().getVisibleRect().height - 1) {
                        y = dim.height - ((DrawComponent)DrawComponent.this).scrollPane.getViewport().getVisibleRect().height - 1;
                    }
                    if (y < 0) {
                        y = 0;
                    }
                    DrawComponent.this.scrollPane.getViewport().setViewPosition(new Point(x, y));
                    NavigateDialog.this.setVisible(false);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics g) {
            if (this.bufferImage == null) {
                this.createBufferImage();
            }
            do {
                Graphics2D g2d = this.bufferImage.createGraphics();
                int validation = this.bufferImage.validate(NavigateDialog.this.screenGraphicsConfiguration);
                if (validation == 2) {
                    this.createBufferImage();
                }
                g2d.drawImage(this.thumbnailImage, new AffineTransform(), NavigateDialog.this);
                if (this.getMousePosition() == null) {
                    return;
                }
                try {
                    int y;
                    AlphaComposite composite = AlphaComposite.getInstance(3, 0.1f);
                    g2d.setComposite(composite);
                    Rectangle visibleRect = ((JComponent)this.scrollPane.getViewport().getView()).getVisibleRect();
                    int visibleWidth = (int)(visibleRect.getWidth() * this.scaleRatio);
                    int visibleHeight = (int)(visibleRect.getHeight() * this.scaleRatio);
                    int x = this.getMousePosition().x - visibleWidth / 2;
                    if (x < 0) {
                        x = 0;
                    }
                    if (x > this.getWidth() - visibleWidth - 1) {
                        x = this.getWidth() - visibleWidth - 1;
                    }
                    if ((y = this.getMousePosition().y - visibleHeight / 2) < 0) {
                        y = 0;
                    }
                    if (y > this.getHeight() - visibleHeight - 1) {
                        y = this.getHeight() - visibleHeight - 1;
                    }
                    g2d.setColor(Color.blue);
                    g2d.fillRect(x, y, visibleWidth, visibleHeight);
                    g2d.setColor(Color.blue.darker());
                    g2d.drawRect(x, y, visibleWidth, visibleHeight);
                }
                finally {
                    g2d.dispose();
                }
            } while (this.bufferImage.contentsLost());
            g.drawImage(this.bufferImage, 0, 0, this);
        }

        @Override
        public void update(Graphics g) {
            this.paint(g);
        }

        public void createBufferImage() {
            this.bufferImage = NavigateDialog.this.screenGraphicsConfiguration.createCompatibleVolatileImage(this.getWidth(), this.getHeight());
        }
    }
}

