/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.announcements;

import com.diyfever.httpproxy.IFlatProxy;
import com.diyfever.httpproxy.PhpFlatProxy;
import com.diyfever.httpproxy.ProxyFactory;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.diylc.announcements.Announcement;
import org.diylc.announcements.IAnnouncementService;
import org.diylc.appframework.miscutils.ConfigurationManager;

public class AnnouncementProvider {
    private String serviceUrl = "http://www.diy-fever.com/diylc/api/v1/announcements.html";
    private String LAST_READ_KEY = "announcement.lastReadDate";
    private IAnnouncementService service;
    private Date lastDate;
    private List<Announcement> announcements;
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public AnnouncementProvider() {
        String string = ConfigurationManager.getInstance().readString(this.LAST_READ_KEY, null);
        try {
            this.lastDate = string == null ? null : this.dateFormat.parse(string);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.serviceUrl = ConfigurationManager.getInstance().readString("serviceUrl", "http://www.diy-fever.com/diylc/api/v1");
        ProxyFactory proxyFactory = new ProxyFactory((IFlatProxy)new PhpFlatProxy());
        this.service = (IAnnouncementService)proxyFactory.createProxy(IAnnouncementService.class, this.serviceUrl);
    }

    public String getCurrentAnnouncements(boolean bl) throws ParseException {
        this.announcements = this.service.getAnnouncements();
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder("<html>");
        for (int i = 0; i < this.announcements.size(); ++i) {
            Date date = this.dateFormat.parse(this.announcements.get(i).getDate());
            if (this.lastDate != null && !this.lastDate.before(date) && !this.lastDate.equals(date) && (!bl || i != this.announcements.size() - 1)) continue;
            stringBuilder.append("<font size='4'><b>").append(this.announcements.get(i).getTitle()).append("</b> on ").append(this.announcements.get(i).getDate()).append("</font>").append("<p>").append(this.announcements.get(i).getText()).append("</p>");
            bl2 = true;
        }
        if (!bl2) {
            return "";
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    public void dismissed() {
        Date date = new Date();
        ConfigurationManager.getInstance().writeValue(this.LAST_READ_KEY, (Object)this.dateFormat.format(date));
    }
}

