/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Path2D;
import org.diylc.common.LineStyle;
import org.diylc.common.ObjectCache;
import org.diylc.components.AbstractTransparentComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

public abstract class AbstractCurvedComponent<T>
extends AbstractTransparentComponent<T> {
    private static final long serialVersionUID = 1L;
    public static Color GUIDELINE_COLOR = Color.blue;
    public static Size DEFAULT_SIZE = new Size((Double)1.0, SizeUnit.in);
    protected Point[] controlPoints = null;
    protected Point[] controlPoints2 = new Point[]{new Point(0, 0), new Point((int)(DEFAULT_SIZE.convertToPixels() / 2.0), 0), new Point((int)(DEFAULT_SIZE.convertToPixels() / 2.0), (int)DEFAULT_SIZE.convertToPixels()), new Point((int)DEFAULT_SIZE.convertToPixels(), (int)DEFAULT_SIZE.convertToPixels())};
    protected Color color = this.getDefaultColor();
    protected PointCount pointCount = PointCount.FOUR;
    protected LineStyle style = LineStyle.SOLID;
    protected Boolean smooth = true;
    private int lastUpdatePointIndex = -1;

    protected abstract void drawCurve(Path2D var1, Graphics2D var2, ComponentState var3, IDrawingObserver var4);

    protected abstract Color getDefaultColor();

    @Override
    public void drawIcon(Graphics2D graphics2D, int n, int n2) {
        graphics2D.setColor(this.getDefaultColor().darker());
        graphics2D.setStroke(ObjectCache.getInstance().fetchBasicStroke(3.0f));
        CubicCurve2D.Double double_ = new CubicCurve2D.Double(1.0, n2 - 1, n / 4, n2 / 3, 3 * n / 4, 2 * n2 / 3, n - 1, 1.0);
        graphics2D.draw(double_);
        graphics2D.setColor(this.getDefaultColor());
        graphics2D.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        graphics2D.draw(double_);
    }

    @Override
    public void draw(Graphics2D graphics2D, ComponentState componentState, boolean bl, Project project, IDrawingObserver iDrawingObserver) {
        if (this.checkPointsClipped(graphics2D.getClip())) {
            return;
        }
        Point[] pointArray = this.getControlPoints();
        if (this.getSmooth().booleanValue() && this.lastUpdatePointIndex >= 0) {
            if (this.getPointCount() == PointCount.FIVE && (this.lastUpdatePointIndex == 1 || this.lastUpdatePointIndex == 2)) {
                pointArray[3] = this.findThirdPoint(pointArray[2], pointArray[1]);
            }
            if (this.getPointCount() == PointCount.FIVE && this.lastUpdatePointIndex == 3) {
                pointArray[1] = this.findThirdPoint(pointArray[2], pointArray[3]);
            }
            if (this.getPointCount() == PointCount.SEVEN && (this.lastUpdatePointIndex == 2 || this.lastUpdatePointIndex == 3)) {
                pointArray[4] = this.findThirdPoint(pointArray[3], pointArray[2]);
            }
            if (this.getPointCount() == PointCount.SEVEN && this.lastUpdatePointIndex == 4) {
                pointArray[2] = this.findThirdPoint(pointArray[3], pointArray[4]);
            }
            this.lastUpdatePointIndex = -1;
        }
        if (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING) {
            iDrawingObserver.stopTracking();
            graphics2D.setStroke(Constants.DASHED_STROKE);
            graphics2D.setColor(GUIDELINE_COLOR);
            for (int i = 0; i < pointArray.length - 1; ++i) {
                graphics2D.drawLine(pointArray[i].x, pointArray[i].y, pointArray[i + 1].x, pointArray[i + 1].y);
            }
            iDrawingObserver.startTracking();
        }
        Path2D.Double double_ = new Path2D.Double();
        ((Path2D)double_).moveTo(pointArray[0].x, pointArray[0].y);
        if (this.getPointCount() == PointCount.TWO) {
            ((Path2D)double_).lineTo(pointArray[1].x, pointArray[1].y);
        } else if (this.getPointCount() == PointCount.THREE) {
            ((Path2D)double_).curveTo(pointArray[1].x, pointArray[1].y, pointArray[1].x, pointArray[1].y, pointArray[2].x, pointArray[2].y);
        } else if (this.getPointCount() == PointCount.FOUR) {
            ((Path2D)double_).curveTo(pointArray[1].x, pointArray[1].y, pointArray[2].x, pointArray[2].y, pointArray[3].x, pointArray[3].y);
        } else if (this.getPointCount() == PointCount.FIVE) {
            ((Path2D)double_).quadTo(pointArray[1].x, pointArray[1].y, pointArray[2].x, pointArray[2].y);
            ((Path2D)double_).quadTo(pointArray[3].x, pointArray[3].y, pointArray[4].x, pointArray[4].y);
        } else if (this.getPointCount() == PointCount.SEVEN) {
            ((Path2D)double_).curveTo(pointArray[1].x, pointArray[1].y, pointArray[2].x, pointArray[2].y, pointArray[3].x, pointArray[3].y);
            ((Path2D)double_).curveTo(pointArray[4].x, pointArray[4].y, pointArray[5].x, pointArray[5].y, pointArray[6].x, pointArray[6].y);
        }
        Composite composite = graphics2D.getComposite();
        if (this.alpha < MAX_ALPHA) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
        }
        this.drawCurve(double_, graphics2D, componentState, iDrawingObserver);
        graphics2D.setComposite(composite);
    }

    @EditableProperty(name="Point Count")
    public PointCount getPointCount() {
        if (this.pointCount == null) {
            this.pointCount = PointCount.FOUR;
        }
        return this.pointCount;
    }

    protected Point[] getControlPoints() {
        if (this.controlPoints != null) {
            switch (this.getPointCount()) {
                case TWO: {
                    this.controlPoints2 = new Point[2];
                    this.controlPoints2[0] = this.controlPoints[0];
                    this.controlPoints2[1] = this.controlPoints[3];
                    break;
                }
                case THREE: {
                    this.controlPoints2 = new Point[3];
                    this.controlPoints2[0] = this.controlPoints[0];
                    this.controlPoints2[1] = this.controlPoints[1];
                    this.controlPoints2[2] = this.controlPoints[3];
                    break;
                }
                case FOUR: {
                    this.controlPoints2 = new Point[4];
                    this.controlPoints2[0] = this.controlPoints[0];
                    this.controlPoints2[1] = this.controlPoints[1];
                    this.controlPoints2[2] = this.controlPoints[2];
                    this.controlPoints2[3] = this.controlPoints[3];
                    break;
                }
                default: {
                    this.controlPoints2 = this.controlPoints;
                }
            }
            this.controlPoints = null;
        }
        return this.controlPoints2;
    }

    public void setPointCount(PointCount pointCount) {
        Point[] pointArray = this.getControlPoints();
        Point[] pointArray2 = new Point[pointCount.count];
        pointArray2[0] = pointArray[0];
        pointArray2[((PointCount)pointCount).count - 1] = pointArray[pointArray.length - 1];
        if (pointCount == PointCount.THREE) {
            pointArray2[1] = new Point((pointArray2[((PointCount)pointCount).count - 1].x + pointArray2[0].x) / 2, (pointArray2[((PointCount)pointCount).count - 1].y + pointArray2[0].y) / 2);
        } else if (pointCount == PointCount.FOUR) {
            pointArray2[1] = new Point((pointArray2[((PointCount)pointCount).count - 1].x + pointArray2[0].x) / 2, (pointArray2[((PointCount)pointCount).count - 1].y + pointArray2[0].y) / 2);
            pointArray2[2] = new Point((pointArray2[((PointCount)pointCount).count - 1].x + pointArray2[0].x) / 2, (pointArray2[((PointCount)pointCount).count - 1].y + pointArray2[0].y) / 2);
        } else if (pointCount == PointCount.FIVE) {
            pointArray2[2] = new Point((pointArray2[((PointCount)pointCount).count - 1].x + pointArray2[0].x) / 2, (pointArray2[((PointCount)pointCount).count - 1].y + pointArray2[0].y) / 2);
            pointArray2[1] = new Point((pointArray2[2].x + pointArray2[0].x) / 2, (pointArray2[2].y + pointArray2[0].y) / 2);
            pointArray2[3] = new Point((pointArray2[((PointCount)pointCount).count - 1].x + pointArray2[2].x) / 2, (pointArray2[((PointCount)pointCount).count - 1].y + pointArray2[2].y) / 2);
        } else if (pointCount == PointCount.SEVEN) {
            pointArray2[3] = new Point((pointArray2[((PointCount)pointCount).count - 1].x + pointArray2[0].x) / 2, (pointArray2[((PointCount)pointCount).count - 1].y + pointArray2[0].y) / 2);
            pointArray2[2] = new Point((pointArray2[3].x + pointArray2[0].x) / 2, (pointArray2[3].y + pointArray2[0].y) / 2);
            pointArray2[1] = new Point((pointArray2[3].x + pointArray2[0].x) / 2, (pointArray2[3].y + pointArray2[0].y) / 2);
            pointArray2[4] = new Point((pointArray2[((PointCount)pointCount).count - 1].x + pointArray2[3].x) / 2, (pointArray2[((PointCount)pointCount).count - 1].y + pointArray2[3].y) / 2);
            pointArray2[5] = new Point((pointArray2[((PointCount)pointCount).count - 1].x + pointArray2[3].x) / 2, (pointArray2[((PointCount)pointCount).count - 1].y + pointArray2[3].y) / 2);
        }
        this.controlPoints2 = pointArray2;
        this.pointCount = pointCount;
    }

    @Override
    public int getControlPointCount() {
        return this.getControlPoints().length;
    }

    @Override
    public boolean isControlPointSticky(int n) {
        return n == 0 || n == this.getControlPointCount() - 1;
    }

    @Override
    public VisibilityPolicy getControlPointVisibilityPolicy(int n) {
        return VisibilityPolicy.WHEN_SELECTED;
    }

    @Override
    public boolean canControlPointOverlap(int n) {
        return n > 0 && n < this.getControlPointCount() - 1;
    }

    @Override
    public Point getControlPoint(int n) {
        return this.getControlPoints()[n];
    }

    @Override
    public void setControlPoint(Point point, int n) {
        Point[] pointArray = this.getControlPoints();
        pointArray[n].setLocation(point);
        this.lastUpdatePointIndex = n;
    }

    private Point findThirdPoint(Point point, Point point2) {
        return new Point(2 * point.x - point2.x, 2 * point.y - point2.y);
    }

    @EditableProperty(name="Color")
    public Color getLeadColor() {
        return this.color;
    }

    public void setLeadColor(Color color) {
        this.color = color;
    }

    @EditableProperty(name="Style")
    public LineStyle getStyle() {
        if (this.style == null) {
            this.style = LineStyle.SOLID;
        }
        return this.style;
    }

    public void setStyle(LineStyle lineStyle) {
        this.style = lineStyle;
    }

    @EditableProperty
    public Boolean getSmooth() {
        if (this.smooth == null) {
            this.smooth = true;
        }
        return this.smooth;
    }

    public void setSmooth(Boolean bl) {
        this.smooth = bl;
    }

    public static enum PointCount {
        TWO(2),
        THREE(3),
        FOUR(4),
        FIVE(5),
        SEVEN(7);

        private int count;

        private PointCount(int n2) {
            this.count = n2;
        }

        public String toString() {
            return this.name().substring(0, 1) + this.name().substring(1).toLowerCase();
        }
    }
}

